/*
 * @(#)Transport.cpp 1.00 1 June 2000
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#include "settings/Transport.h"

#include "tse3/kdeui/ClockWidget.h"
#include "Application.h"

#include <cmath>

#include <qlabel.h>
#include <qlayout.h>
#include <qcheckbox.h>

#include <kdialogbase.h>

#include "tse3/Transport.h"

/******************************************************************************
 * TransportWidget class
 *****************************************************************************/

TransportWidget::TransportWidget(QWidget *parent, const char *name)
: SettingsWidget(new SettingsImpl<TSE3::TransportListener>
      (Application::application()->transport()), parent, name)
{
    QVBoxLayout *layout = new QVBoxLayout(this, KDialogBase::spacingHint(), -1);

    QGridLayout *gl = new QGridLayout(layout, 6, 2);

    autoStop = new QCheckBox("Auto stop", this);
    gl->addWidget(autoStop, 0, 0);

    QLabel *label = new QLabel("Play lead-in", this);
    label->setAlignment(AlignRight|AlignVCenter);
    gl->addWidget(label, 1, 0);
    playLeadIn = new ClockWidget(this, false);
    gl->addWidget(playLeadIn, 1, 1);

    label = new QLabel("Record lead-in", this);
    label->setAlignment(AlignRight|AlignVCenter);
    gl->addWidget(label, 2, 0);
    recordLeadIn = new ClockWidget(this, false);
    gl->addWidget(recordLeadIn, 2, 1);

    adaptiveLookAhead = new QCheckBox("Adaptive look-ahead", this);
    gl->addWidget(adaptiveLookAhead, 3, 0);

    lookAheadLabel = new QLabel("Look ahead", this);
    lookAheadLabel->setAlignment(AlignRight|AlignVCenter);
    gl->addWidget(lookAheadLabel, 4, 0);
    lookAhead = new ClockWidget(this, false);
    gl->addWidget(lookAhead, 4, 1);

    label = new QLabel("Break-ups", this);
    label->setAlignment(AlignRight|AlignVCenter);
    gl->addWidget(label, 5, 0);
    breakUps = new QLabel("XXX", this);
    gl->addWidget(breakUps, 5, 1);

    layout->addStretch(1);

    connect(adaptiveLookAhead, SIGNAL(toggled(bool)), SLOT(updateDisable()));

    updateWidgets();
}


TransportWidget::~TransportWidget()
{
}


void TransportWidget::setValues()
{
    TSE3::Transport *transport = Application::application()->transport();
    transport->setAutoStop(autoStop->isChecked());
    transport->setPlayLeadIn(playLeadIn->value());
    transport->setRecordLeadIn(recordLeadIn->value());
    transport->setAdaptiveLookAhead(adaptiveLookAhead->isChecked());
    if (!adaptiveLookAhead->isChecked())
    {
        transport->setLookAhead(lookAhead->value());
    }
}


void TransportWidget::updateWidgets()
{
    TSE3::Transport *transport = Application::application()->transport();
    autoStop->setChecked(transport->autoStop());
    playLeadIn->setValue(transport->playLeadIn());
    recordLeadIn->setValue(transport->recordLeadIn());
    adaptiveLookAhead->setChecked(transport->adaptiveLookAhead());
    lookAhead->setValue(transport->lookAhead());
    QString s;
    s.sprintf("%i", transport->breakUps());
    breakUps->setText(s);
    updateDisable();
}


void TransportWidget::updateDisable()
{
    bool enabled = !adaptiveLookAhead->isChecked();
    lookAheadLabel->setEnabled(enabled);
    lookAhead->setEnabled(enabled);
}

