/*
 * @(#)Actions.cpp 1.00 2 may 2002
 *
 * Copyright (c) Pete Goodliffe 2002 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#include "songwindow/Actions.h"

#include <iostream>

#include <ktoolbar.h>
#include <qframe.h>
#include <qlayout.h>

#include "tse3/kdeui/ClockDisplayWidget.h"

/******************************************************************************
 * QWidgetAction
 *****************************************************************************/

QWidgetAction::QWidgetAction(const QString &text, QWidget *widget,
                             QObject *parent, const char* name)
: KAction(text, 0, parent, name), _widget(widget), plugged(false)
{
}


QWidgetAction::~QWidgetAction()
{
}


int QWidgetAction::plug(QWidget* widget, int index)
{
    if (plugged)
    {
        std::cerr << "QWidgetAction: Already plugged\n";
    }

    if (widget->inherits("KToolBar"))
    {
        KToolBar *bar = static_cast<KToolBar*>(widget);
        int id = KAction::getToolButtonID();
        KInstance *instance;

        if (parentCollection())
          instance = parentCollection()->instance();
        else
          instance = KGlobal::instance();

        _widget->reparent(bar, 0, QPoint(0,0));
        bar->insertWidget(id, _widget->sizeHint().width(), _widget);
        bar->setItemAutoSized(id, false);
        addContainer(bar, id);
        connect(bar, SIGNAL(destroyed()), this, SLOT(slotDestroyed()));
        return containerCount() - 1;
    }
    else
    {
        std::cerr << "QWidgetAction: Only plugs into toolbars\n";
    }
    return KAction::plug(widget, index);
}


void QWidgetAction::unplug(QWidget* widget)
{
    if (plugged)
    {
        std::cerr << "QWidgetAction: Not plugged\n";
    }
    if (widget->inherits("KToolBar"))
    {
        KToolBar *bar = static_cast<KToolBar*>(widget);
        int id = KAction::getToolButtonID();

        // XXX does this delete the widget! ???
        bar->removeItem(id);
        widget = 0;
    }
    else
    {
        KAction::unplug(widget);
    }
}


/******************************************************************************
 * AutoRepeatAction
 *****************************************************************************/

AutoRepeatAction::AutoRepeatAction(const QString& text, const QString& pix,
                                   int accel, const QObject* receiver,
                                   const char* slot,
                                   QObject* parent, const char* name = 0)
: KAction(text, pix, accel, receiver, slot, parent, name)
{
}


AutoRepeatAction::~AutoRepeatAction()
{
}


int AutoRepeatAction::plug(QWidget* widget, int index)
{
    int ret = KAction::plug(widget, index);

    // OK, this is a bit evil, but it does the job.
    // I'd like to know if there's a better way of doing this.
    for (int n = 0; n < containerCount(); ++n)
    {
        QWidget *cw = container(n);
        if (cw->inherits("KToolBar"))
        {
            KToolBar *bar = static_cast<KToolBar*>(cw);
            bar->setAutoRepeat(itemId(n), true);
        }
    }

    return ret;
}

/******************************************************************************
 * RepeatToggleAction
 *****************************************************************************/

RepeatToggleAction::RepeatToggleAction(const QString& text, const QString& pix,
                                       int accel, const QObject* receiver,
                                       const char* slot,
                                       QObject* parent, const char* name = 0)
: KToggleAction(text, pix, accel, receiver, slot, parent, name)
{
}


RepeatToggleAction::~RepeatToggleAction()
{
}


void RepeatToggleAction::slotActivated()
{
    setChecked(false); // the user will set me later!
    for (int n = 0; n < containerCount(); ++n)
    {
        updateChecked(n);
    }
    emit activated();
}
