/*
 * @(#)ChannelWidget.h 1.00 29 April 2002
 *
 * Copyright (c) Pete Goodliffe 2002 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#ifndef TSE3_KDEUI_CHANNELWIDGET_H
#define TSE3_KDEUI_CHANNELWIDGET_H

#include <qwidget.h>

/**
 * The ChannelWidget allows the user to select a MIDI channel number.
 * You can also set what "magic values" you will allow.
 *
 * @short   MIDI channel input widget
 * @author  Pete Goodliffe
 * @version 1.0
 */
class ChannelWidget : public QWidget
{
        Q_OBJECT

    public:

        /**
         * @param allow_bad  Whether to allow "bad" port numbers that aren't
         *                   handled by the @ref TSE3::MidiScheduler
         */
        ChannelWidget(bool allow_no, bool allow_all, bool allow_same,
                      int value, QWidget *parent, const char *name = 0);

        /**
         * Returns the value.
         */
        int value() { return _value; }

    signals:

        void valueChanged(int value);

    public slots:

        /**
         * Sets the value. If it is not an allowable value (e.g. allow_bad
         * didn't permit it) the value will be changed to a correct one.
         */
        void setValue(int value);

    private slots:

        void slotNumberSelected(int);

    private:

        bool                  allow_no;
        bool                  allow_all;
        bool                  allow_same;
        int                   _value;

        class ChannelSpinBox *spin;
};

#endif
