/*
 * @(#)ClockDisplayWidget.cpp 1.00 29 April 2002
 *
 * Copyright (c) Pete Goodliffe 2002 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#include "tse3/kdeui/ClockDisplayWidget.h"

#include <qlabel.h>
#include <qlayout.h>

/******************************************************************************
 * ClockDisplayWidget class
 *****************************************************************************/

ClockDisplayWidget::ClockDisplayWidget(TSE3::Clock c, QWidget *parent)
: QWidget(parent, "ClockDisplayWidget"), clock(c),
  barvalue(-1), beatvalue(-1), pulsevalue(-1)
{
    QHBoxLayout *layout = new QHBoxLayout(this);
    bar = new QLabel("XXX", this);
    bar->setMinimumWidth(bar->sizeHint().width());
    bar->setAlignment(AlignRight|AlignVCenter);
    layout->addWidget(bar);
    colon1 = new QLabel(":", this);
    layout->addWidget(colon1);
    beat = new QLabel("XX", this);
    beat->setMinimumWidth(beat->sizeHint().width());
    beat->setAlignment(AlignCenter);
    layout->addWidget(beat);
    colon2 = new QLabel(":", this);
    layout->addWidget(colon2);
    pulse = new QLabel("XXX", this);
    pulse->setMinimumWidth(pulse->sizeHint().width());
    pulse->setAlignment(AlignCenter);
    layout->addWidget(pulse);

    updateLabels();
}

void ClockDisplayWidget::setValue(TSE3::Clock c)
{
    clock = c;
    updateLabels();
}


void ClockDisplayWidget::updateLabels()
{
    int newpulsevalue = clock % TSE3::Clock::PPQN;
    int newbeatvalue  = (clock / TSE3::Clock::PPQN) %4;
    int newbarvalue   = (clock / TSE3::Clock::PPQN) /4;

    if (clock < 0)
    {
        const int tsTop = 4; // XXX
        newbarvalue = 0;
        newbeatvalue--;
        while (newbeatvalue < 0) newbeatvalue += tsTop;
        newpulsevalue += TSE3::Clock::PPQN;
    }

    if (newpulsevalue != pulsevalue)
    {
        pulsevalue = newpulsevalue;
        QString s;
        s.sprintf("%02d", pulsevalue);
        pulse->setText(s);
    }

    if (newbeatvalue != beatvalue)
    {
        beatvalue = newbeatvalue;
        QString s;
        s.sprintf("%02d", beatvalue+1);
        beat->setText(s);
    }

    if (newbarvalue != barvalue)
    {
        barvalue = newbarvalue;
        QString s;
        s.sprintf("%d", barvalue+1);
        bar->setText(s);
    }
}
