/*
 * @(#)ClockDisplayWidget.h 1.00 29 April 2002
 *
 * Copyright (c) Pete Goodliffe 2002 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#ifndef TSE3_KDEUI_CLOCKDISPLAYWIDGET_H
#define TSE3_KDEUI_CLOCKDISPLAYWIDGET_H

#include <qwidget.h>

#include "tse3/Midi.h"

class QLabel;

/**
 * This widget provides a simple display for a @ref TSE3::Clock value.
 *
 * @short   Clock display widget.
 * @author  Pete Goodliffe
 * @version 1.0
 */
class ClockDisplayWidget : public QWidget
{
        Q_OBJECT

    public:

        ClockDisplayWidget(TSE3::Clock clock, QWidget *parent);

        /**
         * Returns the @ref Clock value of the widget
         *
         * @see setValue
         */
        TSE3::Clock value() { return clock; }

    public slots:

        /**
         * Sets the value of this widget.
         *
         * @see value
         */
        void setValue(TSE3::Clock mc);

    private:

        void updateLabels();

        TSE3::Clock  clock;
        QLabel      *bar;
        QLabel      *beat;
        QLabel      *pulse;
        QLabel      *colon1, *colon2;
        int          barvalue, beatvalue, pulsevalue;
};

#endif
