/*
 * @(#)FlagComboBox.h 1.00 9 May 2002
 *
 * Copyright (c) Pete Goodliffe 2002 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#ifndef TSE3_KDEUI_FLAGCOMBOBOX_H
#define TSE3_KDEUI_FLAGCOMBOBOX_H

#include <kcombobox.h>

#include "tse3/Midi.h"
#include "tse3/Notifier.h"
#include "tse3/listen/FlagTrack.h"
#include "tse3/listen/MidiScheduler.h"

class QTimer;

namespace TSE3
{
    class MidiScheduler;
    class FlagTrack;
}

/**
 * The FlagComboBox is a KComboBox that allows the user to select a
 * particular flag value.
 *
 * You can connect to the @ref QComboBox::activated signal to catch
 * flag selections.
 *
 * @short   @ref TSE3::FlagTrack selection/display widget
 * @author  Pete Goodliffe
 * @version 1.0
 */
class FlagComboBox : public KComboBox,
                     public TSE3::Listener<TSE3::FlagTrackListener>
{
        Q_OBJECT

    public:

        /**
         * @param flagTrack
         */
        FlagComboBox(TSE3::FlagTrack *flagTrack,
                     QWidget *parent, const char *name = 0);

        /**
         * Change the @ref TSE3::FlagTrack this combo box displays information
         * for.
         */
        void setFlagTrack(TSE3::FlagTrack *flagTrack);

        /**
         * Watch the specified @ref TSE3::MidiScheduler. When the time
         * changes, update the flag display.
         *
         * To disable this facility set the scheduler back to zero.
         */
        void setMidiScheduler(TSE3::MidiScheduler *scheduler);

        /**
         * @reimplemented
         */
        virtual void EventTrack_EventAltered(TSE3::EventTrack<TSE3::Flag> *,
                                             size_t);

        /**
         * @reimplemented
         */
        virtual void EventTrack_EventInserted(TSE3::EventTrack<TSE3::Flag> *,
                                             size_t);

        /**
         * @reimplemented
         */
        virtual void EventTrack_EventErased(TSE3::EventTrack<TSE3::Flag> *,
                                            size_t);

        /**
         * @reimplemented
         */
        virtual void Notifier_Deleted(TSE3::EventTrack<TSE3::Flag> *);

        /**
         * @reimplemented
         */
        virtual void Notifier_Deleted(TSE3::MidiScheduler *);


    public slots:

        /**
         * Sets the time to display. The appropriate flag is displayed
         * in the combo box.
         */
        void setTime(TSE3::Clock time);

    private slots:

        void slotTimer();

    private:

        void update();

        QTimer              *timer;
        TSE3::MidiScheduler *scheduler;
        TSE3::FlagTrack     *flagTrack;
};

#endif
