/*
 * @(#)PortWidget.h 1.00 29 April 2002
 *
 * Copyright (c) Pete Goodliffe 2002 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#ifndef TSE3_KDEUI_PORTWIDGET_H
#define TSE3_KDEUI_PORTWIDGET_H

#include <qwidget.h>

#include "tse3/Notifier.h"
#include "tse3/listen/MidiScheduler.h"

class KComboBox;

/**
 * The PortWidget allows the user to select a MIDI port number. It
 * can allow only existing ports to be selected, or any number. You can
 * also set what "magic values" you will allow.
 *
 * The widget listens to the @ref TSE3::MidiScheduler and adapts itself
 * in case ports are added or removed.
 *
 * @short   MIDI port input widget
 * @author  Pete Goodliffe
 * @version 1.0
 */
class PortWidget : public QWidget,
                   public TSE3::Listener<TSE3::MidiSchedulerListener>
{
        Q_OBJECT

    public:

        /**
         * @param allow_bad  Whether to allow "bad" port numbers that aren't
         *                   handled by the @ref TSE3::MidiScheduler
         */
        PortWidget(bool allow_bad,
                   bool allow_no, bool allow_all, bool allow_same,
                   int value, QWidget *parent, const char *name = 0);

        /**
         * Returns the value.
         */
        int value() { return _value; }

        /**
         * @reimplemented
         */
        virtual void MidiScheduler_PortAdded(TSE3::MidiScheduler *, size_t);

        /**
         * @reimplemented
         */
        virtual void MidiScheduler_PortRemoved(TSE3::MidiScheduler *, size_t);

        /**
         * Converts a channel/port pair to a text value.
         */
        static QString toText(int channel, int port);

    signals:

        void valueChanged(int value);

    public slots:

        /**
         * Sets the value. If it is not an allowable value (e.g. allow_bad
         * didn't permit it) the value will be changed to a correct one.
         */
        void setValue(int value);

    private slots:

        void slotComboSelected(int);
        void slotNumberSelected(int);

    private:

        void updateSpin();
        void updateCombo();

        int spinValueToComboIndex(int);
        int portNumberToComboIndex(int);

        bool               allow_bad;
        bool               allow_no;
        bool               allow_all;
        bool               allow_same;
        int                _value;
        class PortSpinBox *spin;
        KComboBox         *combo;
};

#endif
