/*
 * @(#)SnapWidget.cpp 1.00 1 June 2000
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#include "tse3/kdeui/SnapWidget.h"

#include <iostream>

/******************************************************************************
 * SnapWidget class
 *****************************************************************************/

const int SnapWidget::values[] =
{
    -2,
    -1,
    TSE3::Clock::PPQN * 4,
    TSE3::Clock::PPQN * 2,
    TSE3::Clock::PPQN,
    TSE3::Clock::PPQN / 2,
    TSE3::Clock::PPQN / 4,
    TSE3::Clock::PPQN / 8
};


SnapWidget::SnapWidget(QWidget *parent, const char *name = 0)
: QComboBox(false, parent, name)
{
    setInsertionPolicy(NoInsertion);
    insertItem("Off");
    insertItem("Bar");
    insertItem("Whole");
    insertItem("Half");
    insertItem("Quarter");
    insertItem("Eighth");
    insertItem("Sixteenth");
    insertItem("32nd");

    setCurrentItem(BarPos);

    connect(this, SIGNAL(activated(int)), SLOT(slotActivated(int)));
}


void SnapWidget::setSnapValue(TSE3::Clock mc)
{
    std::cout << "SnapWidget::setSnapValue TODO\n";
}


void SnapWidget::slotActivated(int index)
{
    emit valueChanged(values[index]);
}

