/*
 * Decompiled with CFR 0.152.
 */
package org.cyberneko.pull.util;

import java.io.IOException;
import java.util.Locale;
import org.apache.xerces.xni.XMLDTDContentModelHandler;
import org.apache.xerces.xni.XMLDTDHandler;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.apache.xerces.xni.parser.XMLPullParserConfiguration;
import org.cyberneko.pull.XMLEvent;
import org.cyberneko.pull.util.EventCollector;
import org.cyberneko.pull.util.EventDispatcher;

public class BufferedPullConfiguration
implements XMLPullParserConfiguration {
    protected XMLParserConfiguration fConfiguration;
    protected XMLPullParserConfiguration fPullConfiguration;
    protected XMLInputSource fInputSource;
    protected XMLDocumentHandler fDocumentHandler;
    protected EventCollector fEventCollector;
    protected EventDispatcher fEventDispatcher;

    public BufferedPullConfiguration(XMLParserConfiguration xMLParserConfiguration) {
        this.fConfiguration = xMLParserConfiguration;
        if (xMLParserConfiguration instanceof XMLPullParserConfiguration) {
            this.fPullConfiguration = (XMLPullParserConfiguration)xMLParserConfiguration;
        }
        this.fEventCollector = new EventCollector();
        this.fEventDispatcher = new EventDispatcher();
    }

    public void setInputSource(XMLInputSource xMLInputSource) throws XMLConfigurationException, IOException {
        this.reset();
        if (this.fPullConfiguration != null) {
            this.fPullConfiguration.setInputSource(xMLInputSource);
        } else {
            this.fInputSource = xMLInputSource;
        }
    }

    public boolean parse(boolean bl) throws XNIException, IOException {
        if (bl) {
            XMLEvent xMLEvent = this.fEventCollector.dequeue();
            while (xMLEvent != null) {
                this.fEventDispatcher.dispatchEvent(xMLEvent);
                xMLEvent = this.fEventCollector.dequeue();
            }
            this.fPullConfiguration.setDocumentHandler(this.fDocumentHandler);
            if (this.fPullConfiguration != null) {
                return this.fPullConfiguration.parse(true);
            }
            XMLInputSource xMLInputSource = this.fInputSource;
            if (xMLInputSource != null) {
                this.fInputSource = null;
            }
            this.fConfiguration.parse(xMLInputSource);
            return true;
        }
        XMLEvent xMLEvent = this.fEventCollector.dequeue();
        boolean bl2 = true;
        if (xMLEvent == null) {
            if (this.fPullConfiguration != null) {
                while (xMLEvent == null && bl2) {
                    bl2 = this.fPullConfiguration.parse(false);
                    xMLEvent = this.fEventCollector.dequeue();
                }
            } else {
                XMLInputSource xMLInputSource = this.fInputSource;
                if (xMLInputSource != null) {
                    this.fInputSource = null;
                }
                this.fConfiguration.parse(xMLInputSource);
                bl2 = false;
            }
        }
        if (xMLEvent != null) {
            this.fEventDispatcher.dispatchEvent(xMLEvent);
        }
        return !this.fEventCollector.isEmpty() || bl2;
    }

    public void cleanup() {
        if (this.fPullConfiguration != null) {
            this.fPullConfiguration.cleanup();
        }
    }

    public void parse(XMLInputSource xMLInputSource) throws XNIException, IOException {
        this.setInputSource(xMLInputSource);
        this.parse(true);
    }

    public void addRecognizedFeatures(String[] stringArray) {
        this.fConfiguration.addRecognizedFeatures(stringArray);
    }

    public void setFeature(String string, boolean bl) throws XMLConfigurationException {
        this.fConfiguration.setFeature(string, bl);
    }

    public boolean getFeature(String string) throws XMLConfigurationException {
        return this.fConfiguration.getFeature(string);
    }

    public void addRecognizedProperties(String[] stringArray) {
        this.fConfiguration.addRecognizedProperties(stringArray);
    }

    public void setProperty(String string, Object object) throws XMLConfigurationException {
        this.fConfiguration.setProperty(string, object);
    }

    public Object getProperty(String string) throws XMLConfigurationException {
        return this.fConfiguration.getProperty(string);
    }

    public void setErrorHandler(XMLErrorHandler xMLErrorHandler) {
        this.fConfiguration.setErrorHandler(xMLErrorHandler);
    }

    public XMLErrorHandler getErrorHandler() {
        return this.fConfiguration.getErrorHandler();
    }

    public void setDocumentHandler(XMLDocumentHandler xMLDocumentHandler) {
        this.fDocumentHandler = xMLDocumentHandler;
    }

    public XMLDocumentHandler getDocumentHandler() {
        return this.fDocumentHandler;
    }

    public void setDTDHandler(XMLDTDHandler xMLDTDHandler) {
        this.fConfiguration.setDTDHandler(xMLDTDHandler);
    }

    public XMLDTDHandler getDTDHandler() {
        return this.fConfiguration.getDTDHandler();
    }

    public void setDTDContentModelHandler(XMLDTDContentModelHandler xMLDTDContentModelHandler) {
        this.fConfiguration.setDTDContentModelHandler(xMLDTDContentModelHandler);
    }

    public XMLDTDContentModelHandler getDTDContentModelHandler() {
        return this.fConfiguration.getDTDContentModelHandler();
    }

    public void setEntityResolver(XMLEntityResolver xMLEntityResolver) {
        this.fConfiguration.setEntityResolver(xMLEntityResolver);
    }

    public XMLEntityResolver getEntityResolver() {
        return this.fConfiguration.getEntityResolver();
    }

    public void setLocale(Locale locale) throws XNIException {
        this.fConfiguration.setLocale(locale);
    }

    public Locale getLocale() {
        return this.fConfiguration.getLocale();
    }

    protected void reset() throws XMLConfigurationException {
        this.fEventCollector.clear();
        this.fConfiguration.setDocumentHandler((XMLDocumentHandler)this.fEventCollector);
        this.fEventDispatcher.setDocumentHandler(this.fDocumentHandler);
    }
}

