/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.PropertySet;
import org.apache.tools.ant.util.CollectionUtils;
import org.apache.tools.ant.util.DOMElementWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EchoProperties
extends Task {
    private static final String PROPERTIES = "properties";
    private static final String PROPERTY = "property";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_VALUE = "value";
    private File inFile = null;
    private File destfile = null;
    private boolean failonerror = true;
    private Vector propertySets = new Vector();
    private String format = "text";
    static /* synthetic */ Class class$java$io$OutputStream;
    static /* synthetic */ Class class$java$lang$String;

    public void setSrcfile(File file) {
        this.inFile = file;
    }

    public void setDestfile(File destfile) {
        this.destfile = destfile;
    }

    public void setFailOnError(boolean failonerror) {
        this.failonerror = failonerror;
    }

    public void setPrefix(String prefix) {
        PropertySet ps = new PropertySet();
        ps.setProject(this.getProject());
        ps.appendPrefix(prefix);
        this.addPropertyset(ps);
    }

    public void addPropertyset(PropertySet ps) {
        this.propertySets.addElement(ps);
    }

    public void setFormat(FormatAttribute ea) {
        this.format = ea.getValue();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        block37: {
            block39: {
                block38: {
                    block41: {
                        block40: {
                            allProps = new Hashtable<K, V>();
                            if (this.inFile != null || this.propertySets.size() != 0) break block40;
                            CollectionUtils.putAll(allProps, (Dictionary)this.getProject().getProperties());
                            break block41;
                        }
                        if (this.inFile != null) {
                            if (this.inFile.exists() && this.inFile.isDirectory()) {
                                message = "srcfile is a directory!";
                                if (this.failonerror) {
                                    throw new BuildException(message, this.getLocation());
                                }
                                this.log(message, 0);
                                return;
                            }
                            if (this.inFile.exists() && !this.inFile.canRead()) {
                                message = "Can not read from the specified srcfile!";
                                if (this.failonerror) {
                                    throw new BuildException(message, this.getLocation());
                                }
                                this.log(message, 0);
                                return;
                            }
                            in = null;
                            try {
                                try {
                                    in = new FileInputStream(this.inFile);
                                    props = new Properties();
                                    props.load(in);
                                    CollectionUtils.putAll(allProps, (Dictionary)props);
                                }
                                catch (FileNotFoundException fnfe) {
                                    message = "Could not find file " + this.inFile.getAbsolutePath();
                                    if (this.failonerror) {
                                        throw new BuildException(message, (Throwable)fnfe, this.getLocation());
                                    }
                                    this.log(message, 1);
                                    var7_8 = null;
                                    try {
                                        if (null == in) return;
                                        in.close();
                                        return;
                                    }
                                    catch (IOException ioe) {
                                        // empty catch block
                                    }
                                    return;
                                }
                                catch (IOException ioe) {
                                    message = "Could not read file " + this.inFile.getAbsolutePath();
                                    if (this.failonerror) {
                                        throw new BuildException(message, (Throwable)ioe, this.getLocation());
                                    }
                                    this.log(message, 1);
                                    var7_9 = null;
                                    ** try [egrp 2[TRYBLOCK] [3 : 318->330)] { 
lbl49:
                                    // 1 sources

                                    if (null == in) return;
                                    in.close();
                                    return;
lbl52:
                                    // 1 sources

                                    catch (IOException ioe) {
                                        // empty catch block
                                    }
                                    return;
                                }
                                var7_7 = null;
                                {
                                }
                            }
                            catch (Throwable var6_21) {
                                var7_10 = null;
                                ** try [egrp 2[TRYBLOCK] [3 : 318->330)] { 
lbl61:
                                // 1 sources

                                if (null == in) throw var6_21;
                                in.close();
                                throw var6_21;
lbl64:
                                // 1 sources

                                catch (IOException ioe) {
                                    // empty catch block
                                }
                                throw var6_21;
                            }
                            try {}
                            catch (IOException ioe) {}
                            if (null != in) {
                                in.close();
                            }
                        }
                    }
                    enum = this.propertySets.elements();
                    while (true) {
                        if (!enum.hasMoreElements()) {
                            os = null;
                            ** try [egrp 3[TRYBLOCK] [5 : 374->582)] { 
lbl79:
                            // 1 sources

                            break;
                        }
                        ps = (PropertySet)enum.nextElement();
                        CollectionUtils.putAll(allProps, (Dictionary)ps.getProperties());
                    }
                    {
                        try {
                            if (this.destfile == null) {
                                os = new ByteArrayOutputStream();
                                this.saveProperties(allProps, os);
                                this.log(os.toString(), 2);
                                break block37;
                            }
                            if (this.destfile.exists() && this.destfile.isDirectory()) {
                                message = "destfile is a directory!";
                                if (this.failonerror) {
                                    throw new BuildException(message, this.getLocation());
                                }
                                this.log(message, 0);
                                var10_22 = null;
                                if (os == null) return;
                                break block38;
                            }
                            if (this.destfile.exists() && !this.destfile.canWrite()) {
                                message = "Can not write to the specified destfile!";
                                if (this.failonerror) {
                                    throw new BuildException(message, this.getLocation());
                                }
                                this.log(message, 0);
                                break block39;
                            }
                            os = new FileOutputStream(this.destfile);
                            this.saveProperties(allProps, os);
                            break block37;
                        }
                        catch (IOException ioe) {
                            if (this.failonerror) {
                                throw new BuildException((Throwable)ioe, this.getLocation());
                            }
                            this.log(ioe.getMessage(), 2);
                            var10_25 = null;
                            if (os == null) return;
                            try {
                                os.close();
                                return;
                            }
                            catch (IOException e) {
                                return;
                            }
                        }
                    }
lbl120:
                    // 1 sources

                    catch (Throwable var9_32) {
                        var10_26 = null;
                        if (os == null) throw var9_32;
                        ** try [egrp 5[TRYBLOCK] [6 : 596->603)] { 
lbl125:
                        // 1 sources

                        os.close();
                        throw var9_32;
lbl127:
                        // 1 sources

                        catch (IOException e) {
                            // empty catch block
                        }
                        throw var9_32;
                    }
                }
                ** try [egrp 5[TRYBLOCK] [6 : 596->603)] { 
lbl132:
                // 1 sources

                os.close();
                return;
lbl134:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                return;
            }
            var10_23 = null;
            if (os == null) return;
            ** try [egrp 5[TRYBLOCK] [6 : 596->603)] { 
lbl141:
            // 1 sources

            os.close();
            return;
lbl143:
            // 1 sources

            catch (IOException e) {
                // empty catch block
            }
            return;
        }
        var10_24 = null;
        if (os == null) return;
        try {}
        catch (IOException e) {}
        os.close();
        return;
    }

    protected void saveProperties(Hashtable allProps, OutputStream os) throws IOException, BuildException {
        Properties props = new Properties();
        Enumeration enumeration = allProps.keys();
        while (enumeration.hasMoreElements()) {
            String name = enumeration.nextElement().toString();
            String value = allProps.get(name).toString();
            ((Hashtable)props).put(name, value);
        }
        if ("text".equals(this.format)) {
            this.jdkSaveProperties(props, os, "Ant properties");
        } else if ("xml".equals(this.format)) {
            this.xmlSaveProperties(props, os);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void xmlSaveProperties(Properties props, OutputStream os) throws IOException {
        Document doc = EchoProperties.getDocumentBuilder().newDocument();
        Element rootElement = doc.createElement(PROPERTIES);
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            Element propElement = doc.createElement(PROPERTY);
            propElement.setAttribute(ATTR_NAME, name);
            propElement.setAttribute(ATTR_VALUE, props.getProperty(name));
            rootElement.appendChild(propElement);
        }
        OutputStreamWriter wri = null;
        try {
            try {
                wri = new OutputStreamWriter(os, "UTF8");
                wri.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                new DOMElementWriter().write(rootElement, (Writer)wri, 0, "\t");
                ((Writer)wri).flush();
            }
            catch (IOException ioe) {
                throw new BuildException("Unable to write XML file", (Throwable)ioe);
            }
            Object var10_8 = null;
            if (wri == null) return;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            if (wri == null) throw throwable;
            ((Writer)wri).close();
            throw throwable;
        }
        ((Writer)wri).close();
    }

    protected void jdkSaveProperties(Properties props, OutputStream os, String header) throws IOException {
        try {
            Method m = props.getClass().getMethod("store", class$java$io$OutputStream == null ? (class$java$io$OutputStream = EchoProperties.class$("java.io.OutputStream")) : class$java$io$OutputStream, class$java$lang$String == null ? (class$java$lang$String = EchoProperties.class$("java.lang.String")) : class$java$lang$String);
            m.invoke((Object)props, os, header);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            this.jdk10SaveProperties(props, os, header);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable ex) {
            this.jdk10SaveProperties(props, os, header);
        }
    }

    protected void jdk10SaveProperties(Properties props, OutputStream os, String header) {
        props.save(os, header);
    }

    private static DocumentBuilder getDocumentBuilder() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class FormatAttribute
    extends EnumeratedAttribute {
        private String[] formats = new String[]{"xml", "text"};

        public String[] getValues() {
            return this.formats;
        }
    }
}

