/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.clearcase;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.optional.clearcase.ClearCase;
import org.apache.tools.ant.types.Commandline;

public class CCMklabel
extends ClearCase {
    private boolean m_Replace = false;
    private boolean m_Recurse = false;
    private String m_Version = null;
    private String m_TypeName = null;
    private String m_VOB = null;
    private String m_Comment = null;
    private String m_Cfile = null;
    public static final String FLAG_REPLACE = "-replace";
    public static final String FLAG_RECURSE = "-recurse";
    public static final String FLAG_VERSION = "-version";
    public static final String FLAG_COMMENT = "-c";
    public static final String FLAG_COMMENTFILE = "-cfile";
    public static final String FLAG_NOCOMMENT = "-nc";

    public void execute() throws BuildException {
        Commandline commandLine = new Commandline();
        Project aProj = this.getProject();
        int result = 0;
        if (this.getTypeName() == null) {
            throw new BuildException("Required attribute TypeName not specified");
        }
        if (this.getViewPath() == null) {
            this.setViewPath(aProj.getBaseDir().getPath());
        }
        commandLine.setExecutable(this.getClearToolCommand());
        commandLine.createArgument().setValue("mklabel");
        this.checkOptions(commandLine);
        result = this.run(commandLine);
        if (result != 0) {
            String msg = "Failed executing: " + commandLine.toString();
            throw new BuildException(msg, this.location);
        }
    }

    private void checkOptions(Commandline cmd) {
        if (this.getReplace()) {
            cmd.createArgument().setValue(FLAG_REPLACE);
        }
        if (this.getRecurse()) {
            cmd.createArgument().setValue(FLAG_RECURSE);
        }
        if (this.getVersion() != null) {
            this.getVersionCommand(cmd);
        }
        if (this.getComment() != null) {
            this.getCommentCommand(cmd);
        } else if (this.getCommentFile() != null) {
            this.getCommentFileCommand(cmd);
        } else {
            cmd.createArgument().setValue(FLAG_NOCOMMENT);
        }
        if (this.getTypeName() != null) {
            this.getTypeCommand(cmd);
        }
        cmd.createArgument().setValue(this.getViewPath());
    }

    public void setReplace(boolean repl) {
        this.m_Replace = repl;
    }

    public boolean getReplace() {
        return this.m_Replace;
    }

    public void setRecurse(boolean recurse) {
        this.m_Recurse = recurse;
    }

    public boolean getRecurse() {
        return this.m_Recurse;
    }

    public void setVersion(String ver) {
        this.m_Version = ver;
    }

    public String getVersion() {
        return this.m_Version;
    }

    public void setComment(String comment) {
        this.m_Comment = comment;
    }

    public String getComment() {
        return this.m_Comment;
    }

    public void setCommentFile(String cfile) {
        this.m_Cfile = cfile;
    }

    public String getCommentFile() {
        return this.m_Cfile;
    }

    public void setTypeName(String tn) {
        this.m_TypeName = tn;
    }

    public String getTypeName() {
        return this.m_TypeName;
    }

    public void setVOB(String vob) {
        this.m_VOB = vob;
    }

    public String getVOB() {
        return this.m_VOB;
    }

    private void getVersionCommand(Commandline cmd) {
        if (this.getVersion() != null) {
            cmd.createArgument().setValue(FLAG_VERSION);
            cmd.createArgument().setValue(this.getVersion());
        }
    }

    private void getCommentCommand(Commandline cmd) {
        if (this.getComment() != null) {
            cmd.createArgument().setValue(FLAG_COMMENT);
            cmd.createArgument().setValue(this.getComment());
        }
    }

    private void getCommentFileCommand(Commandline cmd) {
        if (this.getCommentFile() != null) {
            cmd.createArgument().setValue(FLAG_COMMENTFILE);
            cmd.createArgument().setValue(this.getCommentFile());
        }
    }

    private void getTypeCommand(Commandline cmd) {
        String typenm = null;
        if (this.getTypeName() != null) {
            typenm = this.getTypeName();
            if (this.getVOB() != null) {
                typenm = typenm + "@" + this.getVOB();
            }
            cmd.createArgument().setValue(typenm);
        }
    }
}

