/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.clearcase;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.optional.clearcase.ClearCase;
import org.apache.tools.ant.types.Commandline;

public class CCRmtype
extends ClearCase {
    private String m_TypeKind = null;
    private String m_TypeName = null;
    private String m_VOB = null;
    private String m_Comment = null;
    private String m_Cfile = null;
    private boolean m_Rmall = false;
    private boolean m_Ignore = false;
    public static final String FLAG_IGNORE = "-ignore";
    public static final String FLAG_RMALL = "-rmall";
    public static final String FLAG_FORCE = "-force";
    public static final String FLAG_COMMENT = "-c";
    public static final String FLAG_COMMENTFILE = "-cfile";
    public static final String FLAG_NOCOMMENT = "-nc";

    public void execute() throws BuildException {
        Commandline commandLine = new Commandline();
        Project aProj = this.getProject();
        int result = 0;
        if (this.getTypeKind() == null) {
            throw new BuildException("Required attribute TypeKind not specified");
        }
        if (this.getTypeName() == null) {
            throw new BuildException("Required attribute TypeName not specified");
        }
        commandLine.setExecutable(this.getClearToolCommand());
        commandLine.createArgument().setValue("rmtype");
        this.checkOptions(commandLine);
        result = this.run(commandLine);
        if (result != 0) {
            String msg = "Failed executing: " + commandLine.toString();
            throw new BuildException(msg, this.location);
        }
    }

    private void checkOptions(Commandline cmd) {
        if (this.getIgnore()) {
            cmd.createArgument().setValue(FLAG_IGNORE);
        }
        if (this.getRmAll()) {
            cmd.createArgument().setValue(FLAG_RMALL);
            cmd.createArgument().setValue(FLAG_FORCE);
        }
        if (this.getComment() != null) {
            this.getCommentCommand(cmd);
        } else if (this.getCommentFile() != null) {
            this.getCommentFileCommand(cmd);
        } else {
            cmd.createArgument().setValue(FLAG_NOCOMMENT);
        }
        cmd.createArgument().setValue(this.getTypeSpecifier());
    }

    public void setIgnore(boolean ignore) {
        this.m_Ignore = ignore;
    }

    public boolean getIgnore() {
        return this.m_Ignore;
    }

    public void setRmAll(boolean rmall) {
        this.m_Rmall = rmall;
    }

    public boolean getRmAll() {
        return this.m_Rmall;
    }

    public void setComment(String comment) {
        this.m_Comment = comment;
    }

    public String getComment() {
        return this.m_Comment;
    }

    public void setCommentFile(String cfile) {
        this.m_Cfile = cfile;
    }

    public String getCommentFile() {
        return this.m_Cfile;
    }

    public void setTypeKind(String tk) {
        this.m_TypeKind = tk;
    }

    public String getTypeKind() {
        return this.m_TypeKind;
    }

    public void setTypeName(String tn) {
        this.m_TypeName = tn;
    }

    public String getTypeName() {
        return this.m_TypeName;
    }

    public void setVOB(String vob) {
        this.m_VOB = vob;
    }

    public String getVOB() {
        return this.m_VOB;
    }

    private String getTypeSpecifier() {
        String tkind = this.getTypeKind();
        String tname = this.getTypeName();
        String typeSpec = null;
        typeSpec = tkind + ":" + tname;
        if (this.getVOB() != null) {
            typeSpec = typeSpec + "@" + this.getVOB();
        }
        return typeSpec;
    }

    private void getCommentCommand(Commandline cmd) {
        if (this.getComment() != null) {
            cmd.createArgument().setValue(FLAG_COMMENT);
            cmd.createArgument().setValue(this.getComment());
        }
    }

    private void getCommentFileCommand(Commandline cmd) {
        if (this.getCommentFile() != null) {
            cmd.createArgument().setValue(FLAG_COMMENTFILE);
            cmd.createArgument().setValue(this.getCommentFile());
        }
    }
}

