/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.dotnet;

import java.io.File;
import org.apache.tools.ant.taskdefs.optional.dotnet.DotnetCompile;
import org.apache.tools.ant.taskdefs.optional.dotnet.DotnetResource;
import org.apache.tools.ant.taskdefs.optional.dotnet.NetCommand;

public class CSharp
extends DotnetCompile {
    String definitions;
    private File docFile;
    private int fileAlign = 0;
    private boolean fullpaths = false;
    private boolean incremental;
    protected boolean unsafe;
    private boolean noconfig = false;

    public void clear() {
        super.clear();
        this.docFile = null;
        this.fileAlign = 0;
        this.fullpaths = true;
        this.incremental = false;
        this.unsafe = false;
        this.noconfig = false;
        this.definitions = null;
    }

    public void setDocFile(File f) {
        this.docFile = f;
    }

    protected String getDocFileParameter() {
        if (this.docFile != null) {
            return "/doc:" + this.docFile.toString();
        }
        return null;
    }

    public void setFileAlign(int fileAlign) {
        this.fileAlign = fileAlign;
    }

    protected String getFileAlignParameter() {
        if (this.fileAlign != 0) {
            return "/filealign:" + this.fileAlign;
        }
        return null;
    }

    public void setFullPaths(boolean enabled) {
        this.fullpaths = enabled;
    }

    protected String getFullPathsParameter() {
        return this.fullpaths ? "/fullpaths" : null;
    }

    public void setIncremental(boolean incremental) {
        this.incremental = incremental;
    }

    public boolean getIncremental() {
        return this.incremental;
    }

    protected String getIncrementalParameter() {
        return "/incremental" + (this.incremental ? "+" : "-");
    }

    public void setOutputFile(File params) {
        this.setDestFile(params);
    }

    public void setUnsafe(boolean unsafe) {
        this.unsafe = unsafe;
    }

    public boolean getUnsafe() {
        return this.unsafe;
    }

    protected String getUnsafeParameter() {
        return this.unsafe ? "/unsafe" : null;
    }

    public void setNoConfig(boolean enabled) {
        this.noconfig = enabled;
    }

    protected String getNoConfigParameter() {
        return this.noconfig ? "/noconfig" : null;
    }

    public void setDefinitions(String params) {
        this.definitions = params;
    }

    protected String getDefinitionsParameter() {
        String predecessors = super.getDefinitionsParameter();
        if (this.notEmpty(this.definitions)) {
            if (predecessors == null) {
                predecessors = "/define:";
            }
            return predecessors + this.definitions;
        }
        return predecessors;
    }

    public void addCompilerSpecificOptions(NetCommand command) {
        command.addArgument(this.getIncludeDefaultReferencesParameter());
        command.addArgument(this.getWarnLevelParameter());
        command.addArgument(this.getDocFileParameter());
        command.addArgument(this.getFullPathsParameter());
        command.addArgument(this.getFileAlignParameter());
        command.addArgument(this.getIncrementalParameter());
        command.addArgument(this.getNoConfigParameter());
        command.addArgument(this.getUnsafeParameter());
    }

    public String getReferenceDelimiter() {
        return ";";
    }

    public String getCompilerExeName() {
        return "csc";
    }

    public String getFileExtension() {
        return "cs";
    }

    protected String createResourceParameter(DotnetResource resource) {
        return resource.getCSharpStyleParameter();
    }
}

