/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.dotnet;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.optional.dotnet.DotnetBaseMatchingTask;
import org.apache.tools.ant.taskdefs.optional.dotnet.DotnetDefine;
import org.apache.tools.ant.taskdefs.optional.dotnet.DotnetResource;
import org.apache.tools.ant.taskdefs.optional.dotnet.NetCommand;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;

public abstract class DotnetCompile
extends DotnetBaseMatchingTask {
    private String references;
    private boolean includeDefaultReferences;
    private File win32icon;
    private File win32res;
    private boolean failOnError;
    private Path referenceFiles;
    private boolean optimize;
    protected Vector definitionList = new Vector();
    protected Vector resources = new Vector();
    protected static final String[] DEFAULT_REFERENCE_LIST_DOTNET_10 = new String[]{"Accessibility.dll", "cscompmgd.dll", "CustomMarshalers.dll", "Mscorcfg.dll", "System.Configuration.Install.dll", "System.Data.dll", "System.Design.dll", "System.DirectoryServices.dll", "System.EnterpriseServices.dll", "System.dll", "System.Drawing.Design.dll", "System.Drawing.dll", "System.Management.dll", "System.Messaging.dll", "System.Runtime.Remoting.dll", "System.Runtime.Serialization.Formatters.Soap.dll", "System.Security.dll", "System.ServiceProcess.dll", "System.Web.dll", "System.Web.RegularExpressions.dll", "System.Web.Services.dll", "System.Windows.Forms.dll", "System.XML.dll"};
    protected static final String REFERENCE_OPTION = "/reference:";
    protected boolean debug;
    private int warnLevel;
    protected String mainClass;
    protected String extraOptions;
    protected String targetType;
    protected boolean utf8output = false;
    protected String additionalModules;
    protected Vector referenceFilesets = new Vector();

    public DotnetCompile() {
        this.clear();
        this.setIncludes(this.getFilePattern());
    }

    public void clear() {
        this.targetType = null;
        this.win32icon = null;
        this.srcDir = null;
        this.mainClass = null;
        this.warnLevel = 3;
        this.optimize = false;
        this.debug = true;
        this.references = null;
        this.failOnError = true;
        this.additionalModules = null;
        this.includeDefaultReferences = true;
        this.extraOptions = null;
    }

    public void setReferences(String s) {
        this.references = s;
    }

    protected String getReferencesParameter() {
        if (this.notEmpty(this.references)) {
            return REFERENCE_OPTION + this.references;
        }
        return null;
    }

    public void setReferenceFiles(Path path) {
        if (this.referenceFiles == null) {
            this.referenceFiles = new Path(this.getProject());
        }
        this.referenceFiles.append(path);
    }

    public void addReference(FileSet reference) {
        this.referenceFilesets.add(reference);
    }

    protected String getReferenceFilesParameter() {
        if (this.references == null) {
            return null;
        }
        String refpath = this.references.toString();
        if (refpath.length() == 0) {
            return null;
        }
        StringBuffer s = new StringBuffer(REFERENCE_OPTION);
        s.append(refpath);
        return new String(s);
    }

    protected String getDefaultReferenceParameter() {
        if (this.includeDefaultReferences) {
            StringBuffer s = new StringBuffer(REFERENCE_OPTION);
            s.append(this.getDefaultReferenceList());
            return new String(s);
        }
        return null;
    }

    public void setIncludeDefaultReferences(boolean f) {
        this.includeDefaultReferences = f;
    }

    public boolean getIncludeDefaultReferences() {
        return this.includeDefaultReferences;
    }

    protected String getIncludeDefaultReferencesParameter() {
        return "/nostdlib" + (this.includeDefaultReferences ? "-" : "+");
    }

    public void setOptimize(boolean f) {
        this.optimize = f;
    }

    public boolean getOptimize() {
        return this.optimize;
    }

    protected String getOptimizeParameter() {
        return "/optimize" + (this.optimize ? "+" : "-");
    }

    public void setDebug(boolean f) {
        this.debug = f;
    }

    public boolean getDebug() {
        return this.debug;
    }

    protected String getDebugParameter() {
        return "/debug" + (this.debug ? "+" : "-");
    }

    public void setWarnLevel(int warnLevel) {
        this.warnLevel = warnLevel;
    }

    public int getWarnLevel() {
        return this.warnLevel;
    }

    protected String getWarnLevelParameter() {
        return "/warn:" + this.warnLevel;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    protected String getMainClassParameter() {
        if (this.mainClass != null && this.mainClass.length() != 0) {
            return "/main:" + this.mainClass;
        }
        return null;
    }

    public void setExtraOptions(String extraOptions) {
        this.extraOptions = extraOptions;
    }

    public String getExtraOptions() {
        return this.extraOptions;
    }

    protected String getExtraOptionsParameter() {
        if (this.extraOptions != null && this.extraOptions.length() != 0) {
            return this.extraOptions;
        }
        return null;
    }

    public void setDestDir(File dirName) {
        this.log("DestDir currently unused", 1);
    }

    public void setTargetType(TargetTypes targetType) {
        this.targetType = targetType.getValue();
    }

    public void setTargetType(String ttype) throws BuildException {
        if (!((ttype = ttype.toLowerCase()).equals("exe") || ttype.equals("library") || ttype.equals("module") || ttype.equals("winexe"))) {
            throw new BuildException("targetType " + ttype + " is not one of 'exe', 'module', 'winexe' or 'library'");
        }
        this.targetType = ttype;
    }

    public String getTargetType() {
        return this.targetType;
    }

    protected String getTargetTypeParameter() {
        if (this.notEmpty(this.targetType)) {
            return "/target:" + this.targetType;
        }
        return null;
    }

    public void setWin32Icon(File fileName) {
        this.win32icon = fileName;
    }

    protected String getWin32IconParameter() {
        if (this.win32icon != null) {
            return "/win32icon:" + this.win32icon.toString();
        }
        return null;
    }

    public void setWin32Res(File fileName) {
        this.win32res = fileName;
    }

    public File getWin32Res() {
        return this.win32res;
    }

    protected String getWin32ResParameter() {
        if (this.win32res != null) {
            return "/win32res:" + this.win32res.toString();
        }
        return null;
    }

    public void setUtf8Output(boolean enabled) {
        this.utf8output = enabled;
    }

    protected String getUtf8OutputParameter() {
        return this.utf8output ? "/utf8output" : null;
    }

    public void addDefine(DotnetDefine define) {
        this.definitionList.addElement(define);
    }

    protected String getDefinitionsParameter() throws BuildException {
        StringBuffer defines = new StringBuffer();
        Enumeration defEnum = this.definitionList.elements();
        while (defEnum.hasMoreElements()) {
            DotnetDefine define = (DotnetDefine)defEnum.nextElement();
            if (!define.isSet((Task)this)) continue;
            defines.append(define.getValue((Task)this));
            defines.append(this.getDefinitionsDelimiter());
        }
        if (defines.length() == 0) {
            return null;
        }
        return "/D:" + defines;
    }

    public void setAdditionalModules(String params) {
        this.additionalModules = params;
    }

    protected String getAdditionalModulesParameter() {
        if (this.notEmpty(this.additionalModules)) {
            return "/addmodule:" + this.additionalModules;
        }
        return null;
    }

    protected String getDestFileParameter() {
        if (this.outputFile != null) {
            return "/out:" + this.outputFile.toString();
        }
        return null;
    }

    public void setFailOnError(boolean b) {
        this.failOnError = b;
    }

    public boolean getFailOnError() {
        return this.failOnError;
    }

    public void addResource(DotnetResource resource) {
        this.resources.add(resource);
    }

    protected boolean notEmpty(String s) {
        return s != null && s.length() != 0;
    }

    protected void validate() throws BuildException {
        if (this.outputFile != null && this.outputFile.isDirectory()) {
            throw new BuildException("destFile cannot be a directory");
        }
    }

    public String getDefaultReferenceList() {
        StringBuffer referenceList = new StringBuffer();
        int index = 0;
        while (index < DEFAULT_REFERENCE_LIST_DOTNET_10.length) {
            referenceList.append(DEFAULT_REFERENCE_LIST_DOTNET_10[index]);
            referenceList.append(this.getReferenceDelimiter());
            ++index;
        }
        return referenceList.toString();
    }

    public String getFilePattern() {
        return "**/*." + this.getFileExtension();
    }

    public void execute() throws BuildException {
        this.validate();
        NetCommand command = this.createNetCommand();
        this.fillInSharedParameters(command);
        this.addResources(command);
        this.addCompilerSpecificOptions(command);
        int referencesOutOfDate = this.addReferenceFilesets(command, this.getOutputFileTimestamp());
        boolean forceBuild = referencesOutOfDate > 0;
        this.addFilesAndExecute(command, forceBuild);
    }

    public abstract String getReferenceDelimiter();

    public abstract String getCompilerExeName();

    public abstract String getFileExtension();

    protected void fillInSharedParameters(NetCommand command) {
        command.setFailOnError(this.getFailOnError());
        command.addArgument("/nologo");
        command.addArgument(this.getAdditionalModulesParameter());
        command.addArgument(this.getDebugParameter());
        command.addArgument(this.getDefaultReferenceParameter());
        command.addArgument(this.getDefinitionsParameter());
        command.addArgument(this.getExtraOptionsParameter());
        command.addArgument(this.getMainClassParameter());
        command.addArgument(this.getOptimizeParameter());
        command.addArgument(this.getDestFileParameter());
        command.addArgument(this.getReferencesParameter());
        command.addArgument(this.getTargetTypeParameter());
        command.addArgument(this.getUtf8OutputParameter());
        command.addArgument(this.getWin32IconParameter());
        command.addArgument(this.getWin32ResParameter());
    }

    protected void addResources(NetCommand command) {
        Enumeration e = this.resources.elements();
        while (e.hasMoreElements()) {
            DotnetResource resource = (DotnetResource)e.nextElement();
            command.addArgument(this.createResourceParameter(resource));
        }
    }

    protected abstract String createResourceParameter(DotnetResource var1);

    protected int addReferenceFilesets(NetCommand command, long outputTimestamp) {
        int filesOutOfDate = 0;
        Hashtable filesToBuild = new Hashtable();
        int i = 0;
        while (i < this.referenceFilesets.size()) {
            FileSet fs = (FileSet)this.referenceFilesets.elementAt(i);
            filesOutOfDate += command.scanOneFileset(fs.getDirectoryScanner(this.getProject()), filesToBuild, outputTimestamp);
            ++i;
        }
        if (filesToBuild.size() == 0) {
            return 0;
        }
        StringBuffer referenceList = new StringBuffer(REFERENCE_OPTION);
        Enumeration files = filesToBuild.elements();
        while (files.hasMoreElements()) {
            File file = (File)files.nextElement();
            if (DotnetCompile.isFileManagedBinary(file)) {
                referenceList.append(file.toString());
                referenceList.append(this.getReferenceDelimiter());
                continue;
            }
            this.log("ignoring " + file + " as it is not a managed executable", 3);
        }
        command.addArgument(referenceList.toString());
        return filesOutOfDate;
    }

    protected NetCommand createNetCommand() {
        NetCommand command = new NetCommand((Task)this, this.getTaskName(), this.getCompilerExeName());
        return command;
    }

    protected abstract void addCompilerSpecificOptions(NetCommand var1);

    public String getDefinitionsDelimiter() {
        return ";";
    }

    protected static boolean isFileManagedBinary(File file) {
        String filename = file.toString().toLowerCase();
        return filename.endsWith(".exe") || filename.endsWith(".dll") || filename.endsWith(".netmodule");
    }

    public static class TargetTypes
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"exe", "library", "module", "winexe"};
        }
    }
}

