/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.dotnet;

import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.optional.dotnet.DotnetBaseMatchingTask;
import org.apache.tools.ant.taskdefs.optional.dotnet.NetCommand;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;

public class Ilasm
extends DotnetBaseMatchingTask {
    protected static final String exe_name = "ilasm";
    protected static final String file_ext = "il";
    protected static final String file_pattern = "**/*.il";
    protected static final String exe_title = "ilasm";
    protected String targetType;
    protected boolean verbose;
    protected boolean listing;
    protected File resourceFile;
    protected boolean failOnError;
    protected boolean debug;
    private File keyfile;
    protected String extraOptions;
    protected Vector referenceFilesets = new Vector();

    public Ilasm() {
        this.Clear();
        this.setIncludes(file_pattern);
    }

    public void Clear() {
        this.targetType = null;
        this.srcDir = null;
        this.listing = false;
        this.verbose = false;
        this.debug = true;
        this.outputFile = null;
        this.failOnError = true;
        this.resourceFile = null;
        this.extraOptions = null;
    }

    public void setTargetType(String targetType) throws BuildException {
        this.targetType = targetType.toLowerCase();
        if (!targetType.equals("exe") && !targetType.equals("library")) {
            throw new BuildException("targetType " + targetType + " is not a valid type");
        }
    }

    public String getTargetType() {
        return this.targetType;
    }

    protected String getTargetTypeParameter() {
        if (!this.notEmpty(this.targetType)) {
            return null;
        }
        if (this.targetType.equals("exe")) {
            return "/exe";
        }
        if (this.targetType.equals("library")) {
            return "/dll";
        }
        return null;
    }

    public void setOwner(String s) {
        this.log("This option is not supported by ILASM as of Beta-2, and will be ignored", 1);
    }

    protected boolean notEmpty(String s) {
        return s != null && s.length() != 0;
    }

    public void setVerbose(boolean b) {
        this.verbose = b;
    }

    protected String getVerboseParameter() {
        return this.verbose ? null : "/quiet";
    }

    public void setListing(boolean b) {
        this.listing = b;
    }

    protected String getListingParameter() {
        return this.listing ? "/listing" : "/nolisting";
    }

    public void setOutputFile(File params) {
        this.outputFile = params;
    }

    protected String getOutputFileParameter() {
        if (this.outputFile == null) {
            return null;
        }
        return "/output=" + this.outputFile.toString();
    }

    public void setResourceFile(File fileName) {
        this.resourceFile = fileName;
    }

    protected String getResourceFileParameter() {
        if (this.resourceFile != null) {
            return "/resource=" + this.resourceFile.toString();
        }
        return null;
    }

    public void setFailOnError(boolean b) {
        this.failOnError = b;
    }

    public boolean getFailOnError() {
        return this.failOnError;
    }

    public void setDebug(boolean f) {
        this.debug = f;
    }

    public boolean getDebug() {
        return this.debug;
    }

    protected String getDebugParameter() {
        return this.debug ? "/debug" : null;
    }

    public void setKeyfile(File keyfile) {
        this.keyfile = keyfile;
    }

    protected String getKeyfileParameter() {
        if (this.keyfile != null) {
            return "/keyfile:" + this.keyfile.toString();
        }
        return null;
    }

    public void setExtraOptions(String extraOptions) {
        this.extraOptions = extraOptions;
    }

    public String getExtraOptions() {
        return this.extraOptions;
    }

    protected String getExtraOptionsParameter() {
        if (this.extraOptions != null && this.extraOptions.length() != 0) {
            return this.extraOptions;
        }
        return null;
    }

    public void setTargetType(TargetTypes targetType) {
        this.targetType = targetType.getValue();
    }

    public void execute() throws BuildException {
        if (this.srcDir == null) {
            this.srcDir = this.getProject().resolveFile(".");
        }
        NetCommand command = this.buildIlasmCommand();
        this.addFilesAndExecute(command, false);
    }

    private NetCommand buildIlasmCommand() {
        NetCommand command = new NetCommand((Task)this, "ilasm", "ilasm");
        command.setFailOnError(this.getFailOnError());
        command.addArgument(this.getDebugParameter());
        command.addArgument(this.getTargetTypeParameter());
        command.addArgument(this.getListingParameter());
        command.addArgument(this.getOutputFileParameter());
        command.addArgument(this.getResourceFileParameter());
        command.addArgument(this.getVerboseParameter());
        command.addArgument(this.getKeyfileParameter());
        command.addArgument(this.getExtraOptionsParameter());
        return command;
    }

    public void addReference(FileSet reference) {
        this.referenceFilesets.add(reference);
    }

    protected static boolean isFileManagedBinary(File file) {
        String filename = file.toString().toLowerCase();
        return filename.endsWith(".exe") || filename.endsWith(".dll") || filename.endsWith(".netmodule");
    }

    public static class TargetTypes
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"exe", "library"};
        }
    }
}

