/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.extension;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.optional.extension.Extension;
import org.apache.tools.ant.taskdefs.optional.extension.ExtensionAdapter;
import org.apache.tools.ant.taskdefs.optional.extension.ExtensionSet;
import org.apache.tools.ant.taskdefs.optional.extension.ExtraAttribute;

public final class JarLibManifestTask
extends Task {
    private static final String MANIFEST_VERSION = "1.0";
    private static final String CREATED_BY = "Created-By";
    private File m_destfile;
    private Extension m_extension;
    private final ArrayList m_dependencies = new ArrayList();
    private final ArrayList m_optionals = new ArrayList();
    private final ArrayList m_extraAttributes = new ArrayList();

    public void setDestfile(File destfile) {
        this.m_destfile = destfile;
    }

    public void addConfiguredExtension(ExtensionAdapter extensionAdapter) throws BuildException {
        if (null != this.m_extension) {
            String message = "Can not have multiple extensions defined in one library.";
            throw new BuildException("Can not have multiple extensions defined in one library.");
        }
        this.m_extension = extensionAdapter.toExtension();
    }

    public void addConfiguredDepends(ExtensionSet extensionSet) {
        this.m_dependencies.add(extensionSet);
    }

    public void addConfiguredOptions(ExtensionSet extensionSet) {
        this.m_optionals.add(extensionSet);
    }

    public void addConfiguredAttribute(ExtraAttribute attribute) {
        this.m_extraAttributes.add(attribute);
    }

    public void execute() throws BuildException {
        this.validate();
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.put(Attributes.Name.MANIFEST_VERSION, MANIFEST_VERSION);
        String createdBy = "Apache Ant " + this.getProject().getProperty("ant.version");
        attributes.putValue(CREATED_BY, createdBy);
        this.appendExtraAttributes(attributes);
        if (null != this.m_extension) {
            Extension.addExtension(this.m_extension, attributes);
        }
        ArrayList depends = this.toExtensions(this.m_dependencies);
        this.appendExtensionList(attributes, Extension.EXTENSION_LIST, "lib", depends.size());
        this.appendLibraryList(attributes, "lib", depends);
        ArrayList option = this.toExtensions(this.m_optionals);
        this.appendExtensionList(attributes, Extension.OPTIONAL_EXTENSION_LIST, "opt", option.size());
        this.appendLibraryList(attributes, "opt", option);
        try {
            String message = "Generating manifest " + this.m_destfile.getAbsoluteFile();
            this.log(message, 2);
            this.writeManifest(manifest);
        }
        catch (IOException ioe) {
            throw new BuildException(ioe.getMessage(), (Throwable)ioe);
        }
    }

    private void validate() throws BuildException {
        if (null == this.m_destfile) {
            String message = "Destfile attribute not specified.";
            throw new BuildException("Destfile attribute not specified.");
        }
        if (this.m_destfile.exists() && !this.m_destfile.isFile()) {
            String message = this.m_destfile + " is not a file.";
            throw new BuildException(message);
        }
    }

    private void appendExtraAttributes(Attributes attributes) {
        Iterator iterator = ((AbstractList)this.m_extraAttributes).iterator();
        while (iterator.hasNext()) {
            ExtraAttribute attribute = (ExtraAttribute)iterator.next();
            attributes.putValue(attribute.getName(), attribute.getValue());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeManifest(Manifest manifest) throws IOException {
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(this.m_destfile);
            manifest.write(output);
            output.flush();
            Object var4_3 = null;
            if (null == output) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (null == output) throw throwable;
            try {
                output.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            output.close();
            return;
        }
        catch (IOException e) {}
    }

    private void appendLibraryList(Attributes attributes, String listPrefix, ArrayList extensions) throws BuildException {
        int size = extensions.size();
        int i = 0;
        while (i < size) {
            Extension extension = (Extension)extensions.get(i);
            String prefix = listPrefix + i + "-";
            Extension.addExtension(extension, prefix, attributes);
            ++i;
        }
    }

    private void appendExtensionList(Attributes attributes, Attributes.Name extensionKey, String listPrefix, int size) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < size) {
            sb.append(listPrefix + i);
            sb.append(' ');
            ++i;
        }
        attributes.put(extensionKey, sb.toString());
    }

    private ArrayList toExtensions(ArrayList extensionSets) throws BuildException {
        ArrayList<Extension> results = new ArrayList<Extension>();
        int size = extensionSets.size();
        int i = 0;
        while (i < size) {
            ExtensionSet set = (ExtensionSet)((Object)extensionSets.get(i));
            Extension[] extensions = set.toExtensions(this.getProject());
            int j = 0;
            while (j < extensions.length) {
                results.add(extensions[j]);
                ++j;
            }
            ++i;
        }
        return results;
    }
}

