/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.metamata;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.JavaEnvUtils;

public abstract class AbstractMetamataTask
extends Task {
    protected Path classPath = null;
    protected Path sourcePath = null;
    protected File metamataHome = null;
    protected CommandlineJava cmdl = new CommandlineJava();
    protected Vector fileSets = new Vector();
    protected File optionsFile = null;
    protected Hashtable includedFiles = null;

    public AbstractMetamataTask() {
    }

    protected AbstractMetamataTask(String className) {
        this.cmdl.setVm(JavaEnvUtils.getJreExecutable((String)"java"));
        this.cmdl.setClassname(className);
    }

    public void setHome(File value) {
        this.metamataHome = value;
    }

    public void setMetamatahome(File value) {
        this.setHome(value);
    }

    public Path createClasspath() {
        if (this.classPath == null) {
            this.classPath = new Path(this.getProject());
        }
        return this.classPath;
    }

    public Path createSourcepath() {
        if (this.sourcePath == null) {
            this.sourcePath = new Path(this.getProject());
        }
        return this.sourcePath;
    }

    public Commandline.Argument createJvmarg() {
        return this.cmdl.createVmArgument();
    }

    public void setMaxmemory(String max) {
        this.cmdl.setMaxmemory(max);
    }

    public void addFileSet(FileSet fs) {
        this.fileSets.addElement(fs);
    }

    public void execute() throws BuildException {
        try {
            this.setUp();
            ExecuteStreamHandler handler = this.createStreamHandler();
            this.execute0(handler);
            Object var3_2 = null;
            this.cleanUp();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.cleanUp();
            throw throwable;
        }
    }

    protected void setUp() throws BuildException {
        this.checkOptions();
        File jar = this.getMetamataJar(this.metamataHome);
        Path classPath = this.cmdl.createClasspath(this.getProject());
        classPath.createPathElement().setLocation(jar);
        Commandline.Argument vmArgs = this.cmdl.createVmArgument();
        vmArgs.setValue("-Dmetamata.home=" + this.metamataHome.getAbsolutePath());
        this.includedFiles = this.scanSources(new Hashtable());
        this.log(this.includedFiles.size() + " files added for audit", 3);
        Vector options = this.getOptions();
        this.optionsFile = this.createTmpFile();
        this.generateOptionsFile(this.optionsFile, options);
        Commandline.Argument args = this.cmdl.createArgument();
        args.setLine("-arguments " + this.optionsFile.getAbsolutePath());
    }

    protected abstract ExecuteStreamHandler createStreamHandler();

    protected void execute0(ExecuteStreamHandler handler) throws BuildException {
        Execute process = new Execute(handler);
        this.log(this.cmdl.describeCommand(), 3);
        process.setCommandline(this.cmdl.getCommandline());
        try {
            if (process.execute() != 0) {
                throw new BuildException("Metamata task failed.");
            }
        }
        catch (IOException e) {
            throw new BuildException("Failed to launch Metamata task", (Throwable)e);
        }
    }

    protected void cleanUp() {
        if (this.optionsFile != null) {
            this.optionsFile.delete();
            this.optionsFile = null;
        }
    }

    protected final File getMetamataJar(File home) {
        return new File(home, "lib/metamata.jar");
    }

    protected void checkOptions() throws BuildException {
        if (this.metamataHome == null || !this.metamataHome.exists()) {
            throw new BuildException("'home' must point to Metamata home directory.");
        }
        File jar = this.getMetamataJar(this.metamataHome);
        if (!jar.exists()) {
            throw new BuildException(jar + " does not exist. Check your metamata installation.");
        }
    }

    protected abstract Vector getOptions();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void generateOptionsFile(File tofile, Vector options) throws BuildException {
        FileWriter fw = null;
        try {
            try {
                fw = new FileWriter(tofile);
                PrintWriter pw = new PrintWriter(fw);
                int size = options.size();
                int i = 0;
                while (true) {
                    if (i >= size) {
                        pw.flush();
                        break;
                    }
                    pw.println(options.elementAt(i));
                    ++i;
                }
            }
            catch (IOException e) {
                throw new BuildException("Error while writing options file " + tofile, (Throwable)e);
            }
            Object var8_8 = null;
            if (fw == null) return;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (fw == null) throw throwable;
            try {
                fw.close();
                throw throwable;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ignored) {}
        fw.close();
        return;
    }

    protected Hashtable getFileMapping() {
        return this.includedFiles;
    }

    protected static final void addAllVector(Vector dest, Enumeration files) {
        while (files.hasMoreElements()) {
            dest.addElement(files.nextElement());
        }
    }

    protected final File createTmpFile() {
        return FileUtils.newFileUtils().createTempFile("metamata", ".tmp", this.getProject().getBaseDir());
    }

    protected Hashtable scanSources(Hashtable map) {
        Hashtable<String, String> files = new Hashtable<String, String>();
        int i = 0;
        while (i < this.fileSets.size()) {
            FileSet fs = (FileSet)this.fileSets.elementAt(i);
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            ds.scan();
            String[] f = ds.getIncludedFiles();
            this.log(i + ") Adding " + f.length + " files from directory " + ds.getBasedir(), 3);
            int j = 0;
            while (j < f.length) {
                String pathname = f[j];
                if (pathname.endsWith(".java")) {
                    File file = new File(ds.getBasedir(), pathname);
                    String classname = pathname.substring(0, pathname.length() - ".java".length());
                    classname = classname.replace(File.separatorChar, '.');
                    files.put(file.getAbsolutePath(), classname);
                }
                ++j;
            }
            ++i;
        }
        return files;
    }

    protected Hashtable scanSources(Hashtable mapping, String[] entries) {
        Vector<File> javaFiles = new Vector<File>(512);
        int i = 0;
        while (i < entries.length) {
            File f = new File(entries[i]);
            if (f.isDirectory()) {
                DirectoryScanner ds = new DirectoryScanner();
                ds.setBasedir(f);
                ds.setIncludes(new String[]{"**/*.java"});
                ds.scan();
                String[] included = ds.getIncludedFiles();
                int j = 0;
                while (j < included.length) {
                    javaFiles.addElement(new File(f, included[j]));
                    ++j;
                }
            } else if (entries[i].endsWith(".java")) {
                javaFiles.addElement(f);
            }
            ++i;
        }
        int count = javaFiles.size();
        int i2 = 0;
        while (i2 < count) {
            File file = (File)javaFiles.elementAt(i2);
            String pathname = Path.translateFile((String)file.getAbsolutePath());
            String classname = pathname.substring(0, pathname.length() - ".java".length());
            classname = classname.replace(File.separatorChar, '.');
            mapping.put(pathname, classname);
            ++i2;
        }
        return mapping;
    }
}

