/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.source.impl;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.excalibur.source.ModifiableSource;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.excalibur.source.impl.URLSource;
import sun.net.ftp.FtpClient;

public class FTPSource
extends URLSource
implements ModifiableSource {
    public boolean canCancel(OutputStream stream) {
        FTPSourceOutputStream fsos;
        if (stream instanceof FTPSourceOutputStream && (fsos = (FTPSourceOutputStream)stream).getSource() == this) {
            return fsos.canCancel();
        }
        throw new IllegalArgumentException("The stream is not associated to this source");
    }

    public void cancel(OutputStream stream) throws IOException {
        FTPSourceOutputStream fsos;
        if (stream instanceof FTPSourceOutputStream && (fsos = (FTPSourceOutputStream)stream).getSource() == this) {
            try {
                fsos.cancel();
            }
            catch (Exception e) {
                throw new SourceException("Exception during cancel.", e);
            }
            return;
        }
        throw new IllegalArgumentException("The stream is not associated to this source");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void delete() throws SourceException {
        EnhancedFtpClient ftpClient = null;
        try {
            try {
                ftpClient = this.getFtpClient();
                String relativePath = this.m_url.getPath().substring(1);
                ftpClient.delete(relativePath);
            }
            catch (IOException e) {
                if (e instanceof FileNotFoundException) {
                    throw new SourceNotFoundException(e.getMessage());
                }
                String message = "Failure during delete";
                throw new SourceException("Failure during delete", e);
            }
            Object var5_4 = null;
            if (ftpClient == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (ftpClient == null) throw throwable;
            try {
                ftpClient.closeServer();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        ftpClient.closeServer();
        return;
    }

    public OutputStream getOutputStream() throws IOException {
        return new FTPSourceOutputStream(this);
    }

    private final EnhancedFtpClient getFtpClient() throws IOException {
        EnhancedFtpClient ftpClient = new EnhancedFtpClient(this.m_url.getHost());
        ftpClient.login(this.getUser(), this.getPassword());
        return ftpClient;
    }

    private final String getUser() {
        int index;
        String userInfo = this.m_url.getUserInfo();
        if (userInfo != null && (index = userInfo.indexOf(58)) != -1) {
            return userInfo.substring(0, index);
        }
        return null;
    }

    private final String getPassword() {
        int index;
        String userInfo = this.m_url.getUserInfo();
        if (userInfo != null && (index = userInfo.indexOf(58)) != -1 && userInfo.length() > index + 1) {
            return userInfo.substring(index + 1);
        }
        return null;
    }

    private static class FTPSourceOutputStream
    extends ByteArrayOutputStream {
        private final FTPSource m_source;
        private boolean m_isClosed = false;

        FTPSourceOutputStream(FTPSource source) {
            super(8192);
            this.m_source = source;
        }

        public void close() throws IOException {
            if (!this.m_isClosed) {
                IOException e22;
                EnhancedFtpClient ftpClient;
                block14: {
                    ftpClient = null;
                    OutputStream out = null;
                    try {
                        ftpClient = this.m_source.getFtpClient();
                        String parentPath = null;
                        String fileName = null;
                        String relativePath = this.m_source.m_url.getPath().substring(1);
                        int index = relativePath.lastIndexOf(47);
                        if (index != -1) {
                            parentPath = relativePath.substring(0, index);
                            fileName = relativePath.substring(index + 1);
                            ftpClient.mkdirs(parentPath);
                        } else {
                            fileName = relativePath;
                        }
                        out = ftpClient.put(fileName);
                        byte[] bytes = this.toByteArray();
                        out.write(bytes);
                        Object var9_8 = null;
                        if (out == null) break block14;
                    }
                    catch (Throwable throwable) {
                        IOException e22;
                        Object var9_9 = null;
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (IOException e22) {
                                // empty catch block
                            }
                        }
                        if (ftpClient != null) {
                            try {
                                ftpClient.closeServer();
                            }
                            catch (IOException e22) {
                                // empty catch block
                            }
                        }
                        this.m_isClosed = true;
                        throw throwable;
                    }
                    try {
                        out.close();
                    }
                    catch (IOException e22) {
                        // empty catch block
                    }
                }
                if (ftpClient != null) {
                    try {
                        ftpClient.closeServer();
                    }
                    catch (IOException e22) {
                        // empty catch block
                    }
                }
                this.m_isClosed = true;
                {
                }
            }
        }

        boolean canCancel() {
            return !this.m_isClosed;
        }

        void cancel() throws Exception {
            if (this.m_isClosed) {
                String message = "Cannot cancel: outputstrem is already closed";
                throw new IllegalStateException("Cannot cancel: outputstrem is already closed");
            }
            this.m_isClosed = true;
        }

        FTPSource getSource() {
            return this.m_source;
        }
    }

    private static class EnhancedFtpClient
    extends FtpClient {
        private EnhancedFtpClient(String host) throws IOException {
            super(host);
        }

        void delete(String path) throws IOException {
            this.issueCommand("DELE " + path);
        }

        void mkdir(String directoryName) throws IOException {
            this.issueCommand("MKD " + directoryName);
        }

        void mkdirs(String directoryPath) throws IOException {
            try {
                this.cd(directoryPath);
            }
            catch (FileNotFoundException e) {
                String directoryName = null;
                int index = directoryPath.lastIndexOf(47);
                if (index != -1) {
                    String parentDirectoryPath = directoryPath.substring(0, index);
                    directoryName = directoryPath.substring(index + 1);
                    this.mkdirs(parentDirectoryPath);
                } else {
                    directoryName = directoryPath;
                }
                this.mkdir(directoryName);
                this.cd(directoryName);
            }
        }
    }
}

