/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.logic;

import java.io.File;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Ant;
import org.apache.tools.ant.taskdefs.CallTarget;
import org.apache.tools.ant.taskdefs.Property;
import org.apache.tools.ant.types.FileSet;

public class ForEach
extends Task {
    private String list = null;
    private String param = null;
    private String delimiter = ",";
    private String target = null;
    private boolean inheritAll = false;
    private boolean inheritRefs = false;
    private Vector filesets = new Vector();
    private Vector params = new Vector();
    private Vector references = new Vector();

    public void execute() throws BuildException {
        String[] stringArray;
        String string;
        if (this.list == null && this.filesets.size() == 0) {
            throw new BuildException("You must have a list or fileset to iterate through");
        }
        if (this.param == null) {
            throw new BuildException("You must supply a property name to set on each iteration");
        }
        if (this.target == null) {
            throw new BuildException("You must supply an action to perform");
        }
        if (this.list != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.list, this.delimiter);
            String[] stringArray2 = new String[stringTokenizer.countTokens()];
            boolean bl = false;
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                stringArray = this.createCallTarget();
                Property property = stringArray.createParam();
                property.setName(this.param);
                property.setValue(string);
                stringArray.execute();
            }
        }
        int n = this.filesets.size();
        int n2 = 0;
        while (n2 < n) {
            CallTarget callTarget;
            FileSet fileSet = (FileSet)this.filesets.elementAt(n2);
            string = fileSet.getDirectoryScanner(this.getProject());
            stringArray = string.getIncludedFiles();
            int n3 = 0;
            while (n3 < stringArray.length) {
                callTarget = this.createCallTarget();
                Property property = callTarget.createParam();
                property.setName(this.param);
                property.setLocation(new File(fileSet.getDir(this.getProject()), stringArray[n3]));
                callTarget.execute();
                ++n3;
            }
            callTarget = string.getIncludedDirectories();
            int n4 = 0;
            while (n4 < ((CallTarget)callTarget).length) {
                CallTarget callTarget2 = this.createCallTarget();
                Property property = callTarget2.createParam();
                property.setName(this.param);
                property.setLocation(new File(fileSet.getDir(this.getProject()), (String)callTarget[n4]));
                callTarget2.execute();
                ++n4;
            }
            ++n2;
        }
    }

    public void setList(String string) {
        this.list = string;
    }

    public void setDelimiter(String string) {
        this.delimiter = string;
    }

    public void setParam(String string) {
        this.param = string;
    }

    public void setTarget(String string) {
        this.target = string;
    }

    public void setInheritall(boolean bl) {
        this.inheritAll = bl;
    }

    public void setInheritrefs(boolean bl) {
        this.inheritRefs = bl;
    }

    public void addParam(Property property) {
        this.params.addElement(property);
    }

    public void addReference(Ant.Reference reference) {
        this.references.addElement(reference);
    }

    public void addFileset(FileSet fileSet) {
        this.filesets.addElement(fileSet);
    }

    private CallTarget createCallTarget() {
        CallTarget callTarget = (CallTarget)this.getProject().createTask("antcall");
        callTarget.setOwningTarget(this.getOwningTarget());
        callTarget.init();
        callTarget.setTarget(this.target);
        callTarget.setInheritAll(this.inheritAll);
        callTarget.setInheritRefs(this.inheritRefs);
        Enumeration enumeration = this.params.elements();
        while (enumeration.hasMoreElements()) {
            Property property = (Property)enumeration.nextElement();
            Property property2 = callTarget.createParam();
            property2.setName(property.getName());
            if (property.getValue() != null) {
                property2.setValue(property.getValue());
            }
            if (property.getFile() != null) {
                property2.setFile(property.getFile());
            }
            if (property.getResource() != null) {
                property2.setResource(property.getResource());
            }
            if (property.getPrefix() != null) {
                property2.setPrefix(property.getPrefix());
            }
            if (property.getRefid() != null) {
                property2.setRefid(property.getRefid());
            }
            if (property.getEnvironment() != null) {
                property2.setEnvironment(property.getEnvironment());
            }
            if (property.getClasspath() == null) continue;
            property2.setClasspath(property.getClasspath());
        }
        enumeration = this.references.elements();
        while (enumeration.hasMoreElements()) {
            callTarget.addReference((Ant.Reference)enumeration.nextElement());
        }
        return callTarget;
    }
}

