/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.Processor;
import org.apache.cocoon.components.CocoonComponentManager;
import org.apache.cocoon.components.pipeline.ProcessingPipeline;
import org.apache.cocoon.components.sax.XMLDeserializer;
import org.apache.cocoon.components.sax.XMLSerializer;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.ModifiableSource;
import org.apache.cocoon.environment.wrapper.EnvironmentWrapper;
import org.apache.cocoon.xml.AbstractXMLConsumer;
import org.apache.cocoon.xml.ContentHandlerWrapper;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public final class SitemapSource
extends AbstractXMLConsumer
implements ModifiableSource {
    private long lastModificationDate;
    private String systemId;
    private String uri;
    private ComponentManager manager;
    private Processor processor;
    private Processor pipelineProcessor;
    private EnvironmentWrapper environment;
    private String prefix;
    private ProcessingPipeline processingPipeline;
    private Source redirectSource;
    private SAXException exception;
    private boolean needsRefresh;
    private Object processKey;

    public SitemapSource(ComponentManager manager, String uri, Logger logger) throws IOException, ProcessingException {
        Environment env = CocoonComponentManager.getCurrentEnvironment();
        if (env == null) {
            throw new MalformedURLException("The cocoon protocol can not be used outside an environment.");
        }
        this.manager = manager;
        this.enableLogging(logger);
        boolean rawMode = false;
        int position = uri.indexOf(58) + 1;
        if (position != 0 && uri.startsWith("raw:", position)) {
            position += 4;
            rawMode = true;
        }
        if (uri.startsWith("//", position)) {
            position += 2;
            try {
                this.processor = (Processor)this.manager.lookup(Processor.ROLE);
            }
            catch (ComponentException e) {
                throw new ProcessingException("Cannot get Processor instance", (Throwable)e);
            }
            this.prefix = "";
        } else if (uri.startsWith("/", position)) {
            ++position;
            this.prefix = null;
            this.processor = CocoonComponentManager.getCurrentProcessor();
        } else {
            throw new ProcessingException("Malformed cocoon URI.");
        }
        String queryString = null;
        int queryStringPos = uri.indexOf(63, position);
        if (queryStringPos != -1) {
            queryString = uri.substring(queryStringPos + 1);
            uri = uri.substring(position, queryStringPos);
        } else if (position > 0) {
            uri = uri.substring(position);
        }
        String requestURI = this.prefix == null ? env.getURIPrefix() + uri : uri;
        this.systemId = queryString == null ? "cocoon://" + requestURI : "cocoon://" + requestURI + "?" + queryString;
        this.environment = new EnvironmentWrapper(env, requestURI, queryString, logger, manager, rawMode);
        this.uri = uri;
        this.refresh();
    }

    public long getLastModified() {
        if (this.needsRefresh) {
            this.refresh();
        }
        return this.lastModificationDate;
    }

    public long getContentLength() {
        return -1L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getInputStream() throws ProcessingException, IOException {
        ByteArrayInputStream byteArrayInputStream;
        if (this.needsRefresh) {
            this.refresh();
        }
        if (this.exception != null) {
            throw new ProcessingException((Exception)this.exception);
        }
        if (this.redirectSource != null) {
            try {
                return this.redirectSource.getInputStream();
            }
            catch (SourceException se) {
                throw SourceUtil.handle((SourceException)se);
            }
        }
        try {
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                this.environment.setOutputStream((OutputStream)os);
                try {
                    CocoonComponentManager.enterEnvironment((Environment)this.environment, (ComponentManager)this.manager, (Processor)this.pipelineProcessor);
                    this.processingPipeline.process((Environment)this.environment);
                    Object var3_4 = null;
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    CocoonComponentManager.leaveEnvironment();
                    throw throwable;
                }
                CocoonComponentManager.leaveEnvironment();
                byteArrayInputStream = new ByteArrayInputStream(os.toByteArray());
                Object var5_9 = null;
            }
            catch (ProcessingException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ProcessingException("Exception during processing of " + this.systemId, (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var5_10 = null;
            this.environment.setOutputStream(null);
            this.reset();
            throw throwable;
        }
        this.environment.setOutputStream(null);
        this.reset();
        return byteArrayInputStream;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void refresh() {
        this.reset();
        try {
            this.processKey = CocoonComponentManager.startProcessing((Environment)this.environment);
            this.environment.setURI(this.prefix, this.uri);
            this.processingPipeline = this.processor.buildPipeline((Environment)this.environment);
            this.pipelineProcessor = CocoonComponentManager.getLastProcessor((Environment)this.environment);
            this.environment.changeToLastContext();
            String redirectURL = this.environment.getRedirectURL();
            if (redirectURL != null) {
                if (redirectURL.indexOf(":") == -1) {
                    redirectURL = "cocoon:/" + redirectURL;
                }
                this.redirectSource = this.environment.resolveURI(redirectURL);
                this.lastModificationDate = this.redirectSource.getLastModified();
            }
        }
        catch (SAXException e) {
            this.reset();
            this.exception = e;
        }
        catch (Exception e) {
            this.reset();
            this.exception = new SAXException("Could not get sitemap source " + this.systemId, e);
        }
        this.needsRefresh = false;
    }

    public InputSource getInputSource() throws ProcessingException, IOException {
        InputSource newObject = new InputSource(this.getInputStream());
        newObject.setSystemId(this.systemId);
        return newObject;
    }

    public void toSAX(ContentHandler contentHandler) throws SAXException {
        if (this.needsRefresh) {
            this.refresh();
        }
        if (this.exception != null) {
            throw this.exception;
        }
        try {
            try {
                Object consumer = contentHandler instanceof XMLConsumer ? (XMLConsumer)contentHandler : (contentHandler instanceof LexicalHandler ? new ContentHandlerWrapper(contentHandler, (LexicalHandler)((Object)contentHandler)) : new ContentHandlerWrapper(contentHandler));
                if (this.redirectSource != null) {
                    SourceUtil.parse((ComponentManager)this.manager, (Source)this.redirectSource, (ContentHandler)consumer);
                } else {
                    Object fragment;
                    XMLSerializer xmls = (XMLSerializer)this.manager.lookup(XMLSerializer.ROLE);
                    try {
                        CocoonComponentManager.enterEnvironment((Environment)this.environment, (ComponentManager)this.manager, (Processor)this.pipelineProcessor);
                        this.processingPipeline.process((Environment)this.environment, (XMLConsumer)xmls);
                        fragment = xmls.getSAXFragment();
                        Object var6_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_8 = null;
                        this.manager.release((Component)xmls);
                        CocoonComponentManager.leaveEnvironment();
                        throw throwable;
                    }
                    this.manager.release((Component)xmls);
                    CocoonComponentManager.leaveEnvironment();
                    XMLDeserializer xmld = (XMLDeserializer)this.manager.lookup(XMLDeserializer.ROLE);
                    try {
                        xmld.setConsumer(consumer);
                        xmld.deserialize(fragment);
                        Object var8_11 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_12 = null;
                        this.manager.release((Component)xmld);
                        throw throwable;
                    }
                    this.manager.release((Component)xmld);
                    {
                    }
                }
                Object var10_14 = null;
                this.reset();
            }
            catch (SAXException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SAXException("Exception during processing of " + this.systemId, e);
            }
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            this.reset();
            throw throwable;
        }
    }

    private void reset() {
        if (this.processingPipeline != null) {
            this.processingPipeline.release();
        }
        if (this.processKey != null) {
            CocoonComponentManager.endProcessing((Environment)this.environment, (Object)this.processKey);
            this.processKey = null;
        }
        this.processingPipeline = null;
        this.lastModificationDate = 0L;
        this.environment.release(this.redirectSource);
        this.environment.reset();
        this.redirectSource = null;
        this.exception = null;
        this.needsRefresh = true;
        this.pipelineProcessor = null;
    }

    public void recycle() {
        this.reset();
    }
}

