/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.language.markup.xsp.XSPModuleHelper;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.AbstractSAXTransformer;
import org.apache.cocoon.transformation.helpers.VariableConfiguration;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class LinkRewriterTransformer
extends AbstractSAXTransformer
implements Initializable,
Configurable {
    private static String NAMESPACE = "";
    private Set linkAttrs;
    private Set inSchemes;
    private Set outSchemes;
    private Configuration origConf;
    private Configuration conf;
    private XSPModuleHelper modHelper;
    private String badLinkStr;

    public void configure(Configuration conf) throws ConfigurationException {
        if (conf == null) {
            throw new NullPointerException("No static configuration passed to LinkRewriter");
        }
        this.origConf = conf;
    }

    public void initialize() throws Exception {
        this.namespaceURI = NAMESPACE;
        this.modHelper = new XSPModuleHelper();
        this.modHelper.setup(this.manager);
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, parameters);
        this.badLinkStr = parameters.getParameter("bad-link-str", this.origConf.getChild("bad-link-str").getValue(null));
        this.linkAttrs = this.split(parameters.getParameter("link-attrs", this.origConf.getChild("link-attrs").getValue("href")), " ");
        this.inSchemes = this.split(parameters.getParameter("schemes", this.origConf.getChild("schemes").getValue("")), " ");
        this.outSchemes = this.split(parameters.getParameter("exclude-schemes", this.origConf.getChild("exclude-schemes").getValue("http https ftp news mailto")), " ");
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("bad-link-str = " + this.badLinkStr);
            this.getLogger().debug("link-attrs = " + this.linkAttrs);
            this.getLogger().debug("schemes = " + this.inSchemes);
            this.getLogger().debug("exclude-schemes = " + this.outSchemes);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Will ignore the following schemes: " + this.outSchemes);
        }
        VariableConfiguration varConf = new VariableConfiguration(this.origConf);
        varConf.addVariable("src", src);
        varConf.addVariables(parameters);
        try {
            this.conf = varConf.getConfiguration();
        }
        catch (ConfigurationException ce) {
            throw new ProcessingException("Couldn't create dynamic config ", (Throwable)ce);
        }
    }

    public void recycle() {
        super.recycle();
        this.resolver = null;
        this.linkAttrs = null;
        this.inSchemes = null;
        this.outSchemes = null;
        this.conf = null;
    }

    private Set split(String str, String delim) {
        if (str == null) {
            return null;
        }
        HashSet<String> schemes = new HashSet<String>();
        StringTokenizer st = new StringTokenizer(str, delim);
        while (st.hasMoreTokens()) {
            String pfx = st.nextToken();
            schemes.add(pfx);
        }
        return schemes;
    }

    public void startTransformingElement(String uri, String name, String raw, Attributes attr) throws ProcessingException, IOException, SAXException {
        Attributes newAttrs = null;
        boolean matched = false;
        Iterator iter = this.linkAttrs.iterator();
        while (iter.hasNext()) {
            String oldAttr;
            int i;
            int attrIdx = attr.getIndex((String)iter.next());
            if (attrIdx == -1 || (i = (oldAttr = attr.getValue(attrIdx)).indexOf(":")) == -1) continue;
            String scheme = oldAttr.substring(0, i);
            String addr = oldAttr.substring(i + 1);
            if (this.outSchemes.contains(scheme)) {
                if (!this.getLogger().isDebugEnabled()) continue;
                this.getLogger().debug("Ignoring link '" + scheme + ":" + addr + "'");
                continue;
            }
            if (this.inSchemes.contains(scheme)) {
                matched = true;
                newAttrs = this.getLinkAttr(attr, attrIdx, scheme, addr);
                if (!this.getLogger().isDebugEnabled()) continue;
                this.getLogger().debug("Converted link '" + oldAttr + "' to '" + newAttrs.getValue(attrIdx) + "'");
                continue;
            }
            if (this.inSchemes.size() != 0) continue;
            matched = true;
            newAttrs = this.getLinkAttr(attr, attrIdx, scheme, addr);
            this.getLogger().debug("Converted link '" + oldAttr + "' to '" + newAttrs.getValue(attrIdx) + "'");
        }
        if (matched) {
            super.startTransformingElement(uri, name, raw, newAttrs);
        } else {
            super.startTransformingElement(uri, name, raw, attr);
        }
    }

    private Attributes getLinkAttr(Attributes oldAttrs, int linkIndex, String scheme, String addr) {
        AttributesImpl newAttrs = new AttributesImpl(oldAttrs);
        try {
            String modValue = (String)this.modHelper.getAttribute(this.objectModel, this.getConf(scheme), scheme, addr, (Object)(this.badLinkStr != null ? this.badLinkStr : scheme + ":" + addr));
            newAttrs.setValue(linkIndex, modValue);
        }
        catch (CascadingRuntimeException e) {
            if (e.getCause() instanceof ConfigurationException) {
                throw e;
            }
            this.getLogger().error("Error rewriting link '" + scheme + ":" + addr + "': " + e.getMessage());
        }
        return newAttrs;
    }

    private Configuration getConf(String scheme) {
        Configuration[] schemeConfs = this.conf.getChildren("input-module");
        int i = 0;
        while (i < schemeConfs.length) {
            if (scheme.equals(schemeConfs[i].getAttribute("name", null))) {
                return schemeConfs[i];
            }
            ++i;
        }
        return null;
    }
}

