/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskAdapter;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.util.LazyHashtable;
import org.apache.tools.ant.util.WeakishReference;

public class ComponentHelper {
    private Hashtable dataClassDefinitions;
    private Hashtable taskClassDefinitions;
    private Hashtable createdTasks = new Hashtable();
    protected ComponentHelper next;
    protected Project project;
    static /* synthetic */ Class class$org$apache$tools$ant$Task;
    static /* synthetic */ Class class$org$apache$tools$ant$Project;

    public static ComponentHelper getComponentHelper(Project project) {
        ComponentHelper ph = (ComponentHelper)project.getReference("ant.ComponentHelper");
        if (ph != null) {
            return ph;
        }
        ph = new ComponentHelper();
        ph.setProject(project);
        project.addReference("ant.ComponentHelper", ph);
        return ph;
    }

    protected ComponentHelper() {
    }

    public void setNext(ComponentHelper next) {
        this.next = next;
    }

    public ComponentHelper getNext() {
        return this.next;
    }

    public void setProject(Project project) {
        this.project = project;
        this.dataClassDefinitions = new AntTaskTable(project, false);
        this.taskClassDefinitions = new AntTaskTable(project, true);
    }

    public Object createComponent(UnknownElement ue, String ns, String taskName) throws BuildException {
        Object component = null;
        if (this.project.getDataTypeDefinitions().get(taskName) != null && (component = this.createDataType(taskName)) != null) {
            return component;
        }
        component = this.createTask(taskName);
        return component;
    }

    public void initDefaultDefinitions() throws BuildException {
        String defs = "/org/apache/tools/ant/taskdefs/defaults.properties";
        try {
            Properties props = new Properties();
            InputStream in = this.getClass().getResourceAsStream(defs);
            if (in == null) {
                throw new BuildException("Can't load default task list");
            }
            props.load(in);
            in.close();
            ((AntTaskTable)this.taskClassDefinitions).addDefinitions(props);
        }
        catch (IOException ioe) {
            throw new BuildException("Can't load default task list");
        }
        String dataDefs = "/org/apache/tools/ant/types/defaults.properties";
        try {
            Properties props = new Properties();
            InputStream in = this.getClass().getResourceAsStream(dataDefs);
            if (in == null) {
                throw new BuildException("Can't load default datatype list");
            }
            props.load(in);
            in.close();
            ((AntTaskTable)this.dataClassDefinitions).addDefinitions(props);
        }
        catch (IOException ioe) {
            throw new BuildException("Can't load default datatype list");
        }
    }

    public void addTaskDefinition(String taskName, Class taskClass) throws BuildException {
        Class old = (Class)this.taskClassDefinitions.get(taskName);
        if (null != old) {
            if (old.equals(taskClass)) {
                return;
            }
            int logLevel = 1;
            if (old.getName().equals(taskClass.getName())) {
                ClassLoader oldLoader = old.getClassLoader();
                ClassLoader newLoader = taskClass.getClassLoader();
                if (oldLoader != null && newLoader != null && oldLoader instanceof AntClassLoader && newLoader instanceof AntClassLoader && ((AntClassLoader)oldLoader).getClasspath().equals(((AntClassLoader)newLoader).getClasspath())) {
                    logLevel = 3;
                }
            }
            this.project.log("Trying to override old definition of task " + taskName, logLevel);
            this.invalidateCreatedTasks(taskName);
        }
        String msg = " +User task: " + taskName + "     " + taskClass.getName();
        this.project.log(msg, 4);
        this.checkTaskClass(taskClass);
        this.taskClassDefinitions.put(taskName, taskClass);
    }

    public void checkTaskClass(Class taskClass) throws BuildException {
        if (!Modifier.isPublic(taskClass.getModifiers())) {
            String message = taskClass + " is not public";
            this.project.log(message, 0);
            throw new BuildException(message);
        }
        if (Modifier.isAbstract(taskClass.getModifiers())) {
            String message = taskClass + " is abstract";
            this.project.log(message, 0);
            throw new BuildException(message);
        }
        try {
            taskClass.getConstructor(null);
        }
        catch (NoSuchMethodException e) {
            String message = "No public no-arg constructor in " + taskClass;
            this.project.log(message, 0);
            throw new BuildException(message);
        }
        if (!(class$org$apache$tools$ant$Task == null ? (class$org$apache$tools$ant$Task = ComponentHelper.class$("org.apache.tools.ant.Task")) : class$org$apache$tools$ant$Task).isAssignableFrom(taskClass)) {
            TaskAdapter.checkTaskClass(taskClass, this.project);
        }
    }

    public Hashtable getTaskDefinitions() {
        return this.taskClassDefinitions;
    }

    public void addDataTypeDefinition(String typeName, Class typeClass) {
        Hashtable hashtable = this.dataClassDefinitions;
        synchronized (hashtable) {
            Class old = (Class)this.dataClassDefinitions.get(typeName);
            if (null != old) {
                if (old.equals(typeClass)) {
                    return;
                }
                this.project.log("Trying to override old definition of datatype " + typeName, 1);
            }
            this.dataClassDefinitions.put(typeName, typeClass);
        }
        String msg = " +User datatype: " + typeName + "     " + typeClass.getName();
        this.project.log(msg, 4);
    }

    public Hashtable getDataTypeDefinitions() {
        return this.dataClassDefinitions;
    }

    public Task createTask(String taskType) throws BuildException {
        Task task = this.createNewTask(taskType);
        if (task != null) {
            this.addCreatedTask(taskType, task);
        }
        return task;
    }

    private Task createNewTask(String taskType) throws BuildException {
        Class c = (Class)this.taskClassDefinitions.get(taskType);
        if (c == null) {
            return null;
        }
        try {
            Object o = c.newInstance();
            if (this.project != null) {
                this.project.setProjectReference(o);
            }
            Task task = null;
            if (o instanceof Task) {
                task = (Task)o;
            } else {
                TaskAdapter taskA = new TaskAdapter();
                taskA.setProxy(o);
                if (this.project != null) {
                    this.project.setProjectReference(taskA);
                }
                task = taskA;
            }
            task.setProject(this.project);
            task.setTaskType(taskType);
            task.setTaskName(taskType);
            String msg = "   +Task: " + taskType;
            this.project.log(msg, 4);
            return task;
        }
        catch (Throwable t) {
            System.out.println("task CL=" + c.getClassLoader());
            String msg = "Could not create task of type: " + taskType + " due to " + t;
            throw new BuildException(msg, t);
        }
    }

    private void addCreatedTask(String type, Task task) {
        Hashtable hashtable = this.createdTasks;
        synchronized (hashtable) {
            Vector<WeakishReference> v = (Vector<WeakishReference>)this.createdTasks.get(type);
            if (v == null) {
                v = new Vector<WeakishReference>();
                this.createdTasks.put(type, v);
            }
            v.addElement(WeakishReference.createReference(task));
        }
    }

    private void invalidateCreatedTasks(String type) {
        Hashtable hashtable = this.createdTasks;
        synchronized (hashtable) {
            Vector v = (Vector)this.createdTasks.get(type);
            if (v != null) {
                Enumeration enumeration = v.elements();
                while (enumeration.hasMoreElements()) {
                    WeakishReference ref = (WeakishReference)enumeration.nextElement();
                    Task t = (Task)ref.get();
                    if (t == null) continue;
                    t.markInvalid();
                }
                v.removeAllElements();
                this.createdTasks.remove(type);
            }
        }
    }

    public Object createDataType(String typeName) throws BuildException {
        Class c = (Class)this.dataClassDefinitions.get(typeName);
        if (c == null) {
            return null;
        }
        try {
            Constructor ctor = null;
            boolean noArg = false;
            try {
                ctor = c.getConstructor(new Class[0]);
                noArg = true;
            }
            catch (NoSuchMethodException nse) {
                ctor = c.getConstructor(class$org$apache$tools$ant$Project == null ? (class$org$apache$tools$ant$Project = ComponentHelper.class$("org.apache.tools.ant.Project")) : class$org$apache$tools$ant$Project);
                noArg = false;
            }
            Object o = null;
            o = noArg ? ctor.newInstance(new Object[0]) : ctor.newInstance(this.project);
            if (this.project != null) {
                this.project.setProjectReference(o);
            }
            String msg = "   +DataType: " + typeName;
            this.project.log(msg, 4);
            return o;
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            String msg = "Could not create datatype of type: " + typeName + " due to " + t;
            throw new BuildException(msg, t);
        }
        catch (Throwable t) {
            String msg = "Could not create datatype of type: " + typeName + " due to " + t;
            throw new BuildException(msg, t);
        }
    }

    public String getElementName(Object element) {
        Hashtable elements = this.taskClassDefinitions;
        Class<?> elementClass = element.getClass();
        String typeName = "task";
        if (!elements.contains(elementClass)) {
            elements = this.dataClassDefinitions;
            typeName = "data type";
            if (!elements.contains(elementClass)) {
                elements = null;
            }
        }
        if (elements != null) {
            Enumeration e = elements.keys();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                Class clazz = (Class)elements.get(name);
                if (!elementClass.equals(clazz)) continue;
                return "The <" + name + "> " + typeName;
            }
        }
        return "Class " + elementClass.getName();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class AntTaskTable
    extends LazyHashtable {
        Project project;
        Properties props;
        boolean tasks = false;

        public AntTaskTable(Project p, boolean tasks) {
            this.project = p;
            this.tasks = tasks;
        }

        public void addDefinitions(Properties props) {
            this.props = props;
        }

        protected void initAll() {
            if (this.initAllDone) {
                return;
            }
            this.project.log("InitAll", 4);
            if (this.props == null) {
                return;
            }
            Enumeration<?> enumeration = this.props.propertyNames();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                Class taskClass = this.getTask(key);
                if (taskClass == null) continue;
                if (this.tasks) {
                    this.project.addTaskDefinition(key, taskClass);
                    continue;
                }
                this.project.addDataTypeDefinition(key, taskClass);
            }
            this.initAllDone = true;
        }

        protected Class getTask(String key) {
            if (this.props == null) {
                return null;
            }
            String value = this.props.getProperty(key);
            if (value == null) {
                return null;
            }
            try {
                Class<?> taskClass = null;
                if (this.project.getCoreLoader() != null && !"only".equals(this.project.getProperty("build.sysclasspath"))) {
                    try {
                        this.project.log("Loading with the core loader " + value, 4);
                        taskClass = this.project.getCoreLoader().loadClass(value);
                        if (taskClass != null) {
                            return taskClass;
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                taskClass = Class.forName(value);
                return taskClass;
            }
            catch (NoClassDefFoundError ncdfe) {
                this.project.log("Could not load a dependent class (" + ncdfe.getMessage() + ") for task " + key, 4);
            }
            catch (ClassNotFoundException cnfe) {
                this.project.log("Could not load class (" + value + ") for task " + key, 4);
            }
            return null;
        }

        public Object get(Object key) {
            Object orig = super.get(key);
            if (orig != null) {
                return orig;
            }
            if (!(key instanceof String)) {
                return null;
            }
            this.project.log("Get task " + key, 4);
            Class taskClass = this.getTask((String)key);
            if (taskClass != null) {
                super.put(key, taskClass);
            }
            return taskClass;
        }

        public boolean containsKey(Object key) {
            return this.get(key) != null;
        }
    }
}

