/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Stack;
import java.util.Vector;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.ComponentHelper;
import org.apache.tools.ant.PathTokenizer;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.PropertyHelper;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskAdapter;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.input.DefaultInputHandler;
import org.apache.tools.ant.input.InputHandler;
import org.apache.tools.ant.types.Description;
import org.apache.tools.ant.types.FilterSet;
import org.apache.tools.ant.types.FilterSetCollection;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.JavaEnvUtils;

public class Project {
    public static final int MSG_ERR = 0;
    public static final int MSG_WARN = 1;
    public static final int MSG_INFO = 2;
    public static final int MSG_VERBOSE = 3;
    public static final int MSG_DEBUG = 4;
    private static final String VISITING = "VISITING";
    private static final String VISITED = "VISITED";
    private static final String ANTCLASSLOADER_JDK12 = "org.apache.tools.ant.loader.AntClassLoader2";
    public static final String JAVA_1_0 = "1.0";
    public static final String JAVA_1_1 = "1.1";
    public static final String JAVA_1_2 = "1.2";
    public static final String JAVA_1_3 = "1.3";
    public static final String JAVA_1_4 = "1.4";
    public static final String TOKEN_START = "@";
    public static final String TOKEN_END = "@";
    private String name;
    private String description;
    private Hashtable references = new AntRefTable(this);
    private String defaultTarget;
    private Hashtable targets = new Hashtable();
    private FilterSet globalFilterSet = new FilterSet();
    private FilterSetCollection globalFilters = new FilterSetCollection(this.globalFilterSet);
    private File baseDir;
    private Vector listeners = new Vector();
    private ClassLoader coreLoader = null;
    private Hashtable threadTasks = new Hashtable();
    private Hashtable threadGroupTasks = new Hashtable();
    private InputHandler inputHandler = null;
    private InputStream defaultInputStream = null;
    private FileUtils fileUtils = FileUtils.newFileUtils();
    private boolean loggingMessage = false;
    static /* synthetic */ Class class$org$apache$tools$ant$Task;
    static /* synthetic */ Class class$org$apache$tools$ant$Project;

    public void setInputHandler(InputHandler handler) {
        this.inputHandler = handler;
    }

    public void setDefaultInputStream(InputStream defaultInputStream) {
        this.defaultInputStream = defaultInputStream;
    }

    public InputStream getDefaultInputStream() {
        return this.defaultInputStream;
    }

    public InputHandler getInputHandler() {
        return this.inputHandler;
    }

    public Project() {
        this.inputHandler = new DefaultInputHandler();
    }

    public void init() throws BuildException {
        this.setJavaVersionProperty();
        ComponentHelper.getComponentHelper(this).initDefaultDefinitions();
        this.setSystemProperties();
    }

    private AntClassLoader createClassLoader() {
        AntClassLoader loader = null;
        if (!JavaEnvUtils.isJavaVersion(JAVA_1_1)) {
            try {
                Class<?> loaderClass = Class.forName(ANTCLASSLOADER_JDK12);
                loader = (AntClassLoader)loaderClass.newInstance();
            }
            catch (Exception e) {
                this.log("Unable to create Class Loader: " + e.getMessage(), 4);
            }
        }
        if (loader == null) {
            loader = new AntClassLoader();
        }
        loader.setProject(this);
        return loader;
    }

    public AntClassLoader createClassLoader(Path path) {
        AntClassLoader loader = this.createClassLoader();
        loader.setClassPath(path);
        return loader;
    }

    public void setCoreLoader(ClassLoader coreLoader) {
        this.coreLoader = coreLoader;
    }

    public ClassLoader getCoreLoader() {
        return this.coreLoader;
    }

    public void addBuildListener(BuildListener listener) {
        this.listeners.addElement(listener);
    }

    public void removeBuildListener(BuildListener listener) {
        this.listeners.removeElement(listener);
    }

    public Vector getBuildListeners() {
        return (Vector)this.listeners.clone();
    }

    public void log(String message) {
        this.log(message, 2);
    }

    public void log(String message, int msgLevel) {
        this.fireMessageLogged(this, message, msgLevel);
    }

    public void log(Task task, String message, int msgLevel) {
        this.fireMessageLogged(task, message, msgLevel);
    }

    public void log(Target target, String message, int msgLevel) {
        this.fireMessageLogged(target, message, msgLevel);
    }

    public FilterSet getGlobalFilterSet() {
        return this.globalFilterSet;
    }

    public synchronized void setProperty(String name, String value) {
        PropertyHelper.getPropertyHelper(this).setProperty(null, name, value, true);
    }

    public synchronized void setNewProperty(String name, String value) {
        PropertyHelper.getPropertyHelper(this).setNewProperty(null, name, value);
    }

    public synchronized void setUserProperty(String name, String value) {
        PropertyHelper.getPropertyHelper(this).setUserProperty(null, name, value);
    }

    public synchronized void setInheritedProperty(String name, String value) {
        PropertyHelper ph = PropertyHelper.getPropertyHelper(this);
        ph.setInheritedProperty(null, name, value);
    }

    private void setPropertyInternal(String name, String value) {
        PropertyHelper ph = PropertyHelper.getPropertyHelper(this);
        ph.setProperty(null, name, value, false);
    }

    public String getProperty(String name) {
        PropertyHelper ph = PropertyHelper.getPropertyHelper(this);
        return (String)ph.getProperty(null, name);
    }

    public String replaceProperties(String value) throws BuildException {
        PropertyHelper ph = PropertyHelper.getPropertyHelper(this);
        return ph.replaceProperties(null, value, null);
    }

    public String getUserProperty(String name) {
        PropertyHelper ph = PropertyHelper.getPropertyHelper(this);
        return (String)ph.getUserProperty(null, name);
    }

    public Hashtable getProperties() {
        PropertyHelper ph = PropertyHelper.getPropertyHelper(this);
        return ph.getProperties();
    }

    public Hashtable getUserProperties() {
        PropertyHelper ph = PropertyHelper.getPropertyHelper(this);
        return ph.getUserProperties();
    }

    public void copyUserProperties(Project other) {
        PropertyHelper ph = PropertyHelper.getPropertyHelper(this);
        ph.copyUserProperties(other);
    }

    public void copyInheritedProperties(Project other) {
        PropertyHelper ph = PropertyHelper.getPropertyHelper(this);
        ph.copyInheritedProperties(other);
    }

    public void setDefaultTarget(String defaultTarget) {
        this.defaultTarget = defaultTarget;
    }

    public String getDefaultTarget() {
        return this.defaultTarget;
    }

    public void setDefault(String defaultTarget) {
        this.defaultTarget = defaultTarget;
    }

    public void setName(String name) {
        this.setUserProperty("ant.project.name", name);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = Description.getDescription(this);
        }
        return this.description;
    }

    public void addFilter(String token, String value) {
        if (token == null) {
            return;
        }
        this.globalFilterSet.addFilter(new FilterSet.Filter(token, value));
    }

    public Hashtable getFilters() {
        return this.globalFilterSet.getFilterHash();
    }

    public void setBasedir(String baseD) throws BuildException {
        this.setBaseDir(new File(baseD));
    }

    public void setBaseDir(File baseDir) throws BuildException {
        if (!(baseDir = this.fileUtils.normalize(baseDir.getAbsolutePath())).exists()) {
            throw new BuildException("Basedir " + baseDir.getAbsolutePath() + " does not exist");
        }
        if (!baseDir.isDirectory()) {
            throw new BuildException("Basedir " + baseDir.getAbsolutePath() + " is not a directory");
        }
        this.baseDir = baseDir;
        this.setPropertyInternal("basedir", this.baseDir.getPath());
        String msg = "Project base dir set to: " + this.baseDir;
        this.log(msg, 3);
    }

    public File getBaseDir() {
        if (this.baseDir == null) {
            try {
                this.setBasedir(".");
            }
            catch (BuildException ex) {
                ex.printStackTrace();
            }
        }
        return this.baseDir;
    }

    public static String getJavaVersion() {
        return JavaEnvUtils.getJavaVersion();
    }

    public void setJavaVersionProperty() throws BuildException {
        String javaVersion = JavaEnvUtils.getJavaVersion();
        this.setPropertyInternal("ant.java.version", javaVersion);
        if (JavaEnvUtils.isJavaVersion(JAVA_1_0)) {
            throw new BuildException("Ant cannot work on Java 1.0");
        }
        this.log("Detected Java version: " + javaVersion + " in: " + System.getProperty("java.home"), 3);
        this.log("Detected OS: " + System.getProperty("os.name"), 3);
    }

    public void setSystemProperties() {
        Properties systemP = System.getProperties();
        Enumeration e = ((Hashtable)systemP).keys();
        while (e.hasMoreElements()) {
            Object name = e.nextElement();
            String value = ((Hashtable)systemP).get(name).toString();
            this.setPropertyInternal(name.toString(), value);
        }
    }

    public void addTaskDefinition(String taskName, Class taskClass) throws BuildException {
        ComponentHelper.getComponentHelper(this).addTaskDefinition(taskName, taskClass);
    }

    public void checkTaskClass(Class taskClass) throws BuildException {
        ComponentHelper.getComponentHelper(this).checkTaskClass(taskClass);
        if (!Modifier.isPublic(taskClass.getModifiers())) {
            String message = taskClass + " is not public";
            this.log(message, 0);
            throw new BuildException(message);
        }
        if (Modifier.isAbstract(taskClass.getModifiers())) {
            String message = taskClass + " is abstract";
            this.log(message, 0);
            throw new BuildException(message);
        }
        try {
            taskClass.getConstructor(null);
        }
        catch (NoSuchMethodException e) {
            String message = "No public no-arg constructor in " + taskClass;
            this.log(message, 0);
            throw new BuildException(message);
        }
        if (!(class$org$apache$tools$ant$Task == null ? (class$org$apache$tools$ant$Task = Project.class$("org.apache.tools.ant.Task")) : class$org$apache$tools$ant$Task).isAssignableFrom(taskClass)) {
            TaskAdapter.checkTaskClass(taskClass, this);
        }
    }

    public Hashtable getTaskDefinitions() {
        return ComponentHelper.getComponentHelper(this).getTaskDefinitions();
    }

    public void addDataTypeDefinition(String typeName, Class typeClass) {
        ComponentHelper.getComponentHelper(this).addDataTypeDefinition(typeName, typeClass);
    }

    public Hashtable getDataTypeDefinitions() {
        return ComponentHelper.getComponentHelper(this).getDataTypeDefinitions();
    }

    public void addTarget(Target target) throws BuildException {
        String name = target.getName();
        if (this.targets.get(name) != null) {
            throw new BuildException("Duplicate target: `" + name + "'");
        }
        this.addOrReplaceTarget(name, target);
    }

    public void addTarget(String targetName, Target target) throws BuildException {
        if (this.targets.get(targetName) != null) {
            throw new BuildException("Duplicate target: `" + targetName + "'");
        }
        this.addOrReplaceTarget(targetName, target);
    }

    public void addOrReplaceTarget(Target target) {
        this.addOrReplaceTarget(target.getName(), target);
    }

    public void addOrReplaceTarget(String targetName, Target target) {
        String msg = " +Target: " + targetName;
        this.log(msg, 4);
        target.setProject(this);
        this.targets.put(targetName, target);
    }

    public Hashtable getTargets() {
        return this.targets;
    }

    public Task createTask(String taskType) throws BuildException {
        return ComponentHelper.getComponentHelper(this).createTask(taskType);
    }

    public Object createDataType(String typeName) throws BuildException {
        return ComponentHelper.getComponentHelper(this).createDataType(typeName);
    }

    public void executeTargets(Vector targetNames) throws BuildException {
        int i = 0;
        while (i < targetNames.size()) {
            this.executeTarget((String)targetNames.elementAt(i));
            ++i;
        }
    }

    public void demuxOutput(String line, boolean isError) {
        Task task = this.getThreadTask(Thread.currentThread());
        if (task == null) {
            this.fireMessageLogged(this, line, isError ? 0 : 2);
        } else if (isError) {
            task.handleErrorOutput(line);
        } else {
            task.handleOutput(line);
        }
    }

    public int defaultInput(byte[] buffer, int offset, int length) throws IOException {
        if (this.defaultInputStream != null) {
            return this.defaultInputStream.read(buffer, offset, length);
        }
        throw new EOFException("No input provided for project");
    }

    public int demuxInput(byte[] buffer, int offset, int length) throws IOException {
        Task task = this.getThreadTask(Thread.currentThread());
        if (task == null) {
            return this.defaultInput(buffer, offset, length);
        }
        return task.handleInput(buffer, offset, length);
    }

    public void demuxFlush(String line, boolean isError) {
        Task task = this.getThreadTask(Thread.currentThread());
        if (task == null) {
            this.fireMessageLogged(this, line, isError ? 0 : 2);
        } else if (isError) {
            task.handleErrorFlush(line);
        } else {
            task.handleFlush(line);
        }
    }

    public void executeTarget(String targetName) throws BuildException {
        Target curtarget;
        if (targetName == null) {
            String msg = "No target specified";
            throw new BuildException(msg);
        }
        Vector sortedTargets = this.topoSort(targetName, this.targets);
        int curidx = 0;
        do {
            curtarget = (Target)sortedTargets.elementAt(curidx++);
            curtarget.performTasks();
        } while (!curtarget.getName().equals(targetName));
    }

    public File resolveFile(String fileName, File rootDir) {
        return this.fileUtils.resolveFile(rootDir, fileName);
    }

    public File resolveFile(String fileName) {
        return this.fileUtils.resolveFile(this.baseDir, fileName);
    }

    public static String translatePath(String toProcess) {
        if (toProcess == null || toProcess.length() == 0) {
            return "";
        }
        StringBuffer path = new StringBuffer(toProcess.length() + 50);
        PathTokenizer tokenizer = new PathTokenizer(toProcess);
        while (tokenizer.hasMoreTokens()) {
            String pathComponent = tokenizer.nextToken();
            pathComponent = pathComponent.replace('/', File.separatorChar);
            pathComponent = pathComponent.replace('\\', File.separatorChar);
            if (path.length() != 0) {
                path.append(File.pathSeparatorChar);
            }
            path.append(pathComponent);
        }
        return path.toString();
    }

    public void copyFile(String sourceFile, String destFile) throws IOException {
        this.fileUtils.copyFile(sourceFile, destFile);
    }

    public void copyFile(String sourceFile, String destFile, boolean filtering) throws IOException {
        this.fileUtils.copyFile(sourceFile, destFile, filtering ? this.globalFilters : null);
    }

    public void copyFile(String sourceFile, String destFile, boolean filtering, boolean overwrite) throws IOException {
        this.fileUtils.copyFile(sourceFile, destFile, filtering ? this.globalFilters : null, overwrite);
    }

    public void copyFile(String sourceFile, String destFile, boolean filtering, boolean overwrite, boolean preserveLastModified) throws IOException {
        this.fileUtils.copyFile(sourceFile, destFile, filtering ? this.globalFilters : null, overwrite, preserveLastModified);
    }

    public void copyFile(File sourceFile, File destFile) throws IOException {
        this.fileUtils.copyFile(sourceFile, destFile);
    }

    public void copyFile(File sourceFile, File destFile, boolean filtering) throws IOException {
        this.fileUtils.copyFile(sourceFile, destFile, filtering ? this.globalFilters : null);
    }

    public void copyFile(File sourceFile, File destFile, boolean filtering, boolean overwrite) throws IOException {
        this.fileUtils.copyFile(sourceFile, destFile, filtering ? this.globalFilters : null, overwrite);
    }

    public void copyFile(File sourceFile, File destFile, boolean filtering, boolean overwrite, boolean preserveLastModified) throws IOException {
        this.fileUtils.copyFile(sourceFile, destFile, filtering ? this.globalFilters : null, overwrite, preserveLastModified);
    }

    public void setFileLastModified(File file, long time) throws BuildException {
        if (JavaEnvUtils.isJavaVersion(JAVA_1_1)) {
            this.log("Cannot change the modification time of " + file + " in JDK 1.1", 1);
            return;
        }
        this.fileUtils.setFileLastModified(file, time);
        this.log("Setting modification time for " + file, 3);
    }

    public static boolean toBoolean(String s) {
        return s.equalsIgnoreCase("on") || s.equalsIgnoreCase("true") || s.equalsIgnoreCase("yes");
    }

    public final Vector topoSort(String root, Hashtable targets) throws BuildException {
        Vector ret = new Vector();
        Hashtable state = new Hashtable();
        Stack visiting = new Stack();
        this.tsort(root, targets, state, visiting, ret);
        this.log("Build sequence for target `" + root + "' is " + ret, 3);
        Enumeration en = targets.keys();
        while (en.hasMoreElements()) {
            String curTarget = (String)en.nextElement();
            String st = (String)state.get(curTarget);
            if (st == null) {
                this.tsort(curTarget, targets, state, visiting, ret);
                continue;
            }
            if (st != VISITING) continue;
            throw new RuntimeException("Unexpected node in visiting state: " + curTarget);
        }
        this.log("Complete build sequence is " + ret, 3);
        return ret;
    }

    private final void tsort(String root, Hashtable targets, Hashtable state, Stack visiting, Vector ret) throws BuildException {
        state.put(root, VISITING);
        visiting.push(root);
        Target target = (Target)targets.get(root);
        if (target == null) {
            StringBuffer sb = new StringBuffer("Target `");
            sb.append(root);
            sb.append("' does not exist in this project. ");
            visiting.pop();
            if (!visiting.empty()) {
                String parent = (String)visiting.peek();
                sb.append("It is used from target `");
                sb.append(parent);
                sb.append("'.");
            }
            throw new BuildException(new String(sb));
        }
        Enumeration en = target.getDependencies();
        while (en.hasMoreElements()) {
            String cur = (String)en.nextElement();
            String m = (String)state.get(cur);
            if (m == null) {
                this.tsort(cur, targets, state, visiting, ret);
                continue;
            }
            if (m != VISITING) continue;
            throw Project.makeCircularException(cur, visiting);
        }
        String p = (String)visiting.pop();
        if (root != p) {
            throw new RuntimeException("Unexpected internal error: expected to pop " + root + " but got " + p);
        }
        state.put(root, VISITED);
        ret.addElement(target);
    }

    private static BuildException makeCircularException(String end, Stack stk) {
        String c;
        StringBuffer sb = new StringBuffer("Circular dependency: ");
        sb.append(end);
        do {
            c = (String)stk.pop();
            sb.append(" <- ");
            sb.append(c);
        } while (!c.equals(end));
        return new BuildException(new String(sb));
    }

    public void addReference(String name, Object value) {
        Hashtable hashtable = this.references;
        synchronized (hashtable) {
            Object old = ((AntRefTable)this.references).getReal(name);
            if (old == value) {
                return;
            }
            if (old != null && !(old instanceof UnknownElement)) {
                this.log("Overriding previous definition of reference to " + name, 1);
            }
            String valueAsString = "";
            try {
                valueAsString = value.toString();
            }
            catch (Throwable t) {
                this.log("Caught exception (" + t.getClass().getName() + ")" + " while expanding " + name + ": " + t.getMessage(), 1);
            }
            this.log("Adding reference: " + name + " -> " + valueAsString, 4);
            this.references.put(name, value);
        }
    }

    public Hashtable getReferences() {
        return this.references;
    }

    public Object getReference(String key) {
        return this.references.get(key);
    }

    public String getElementName(Object element) {
        return ComponentHelper.getComponentHelper(this).getElementName(element);
    }

    public void fireBuildStarted() {
        BuildEvent event = new BuildEvent(this);
        Vector listeners = this.getBuildListeners();
        int size = listeners.size();
        int i = 0;
        while (i < size) {
            BuildListener listener = (BuildListener)listeners.elementAt(i);
            listener.buildStarted(event);
            ++i;
        }
    }

    public void fireBuildFinished(Throwable exception) {
        BuildEvent event = new BuildEvent(this);
        event.setException(exception);
        Vector listeners = this.getBuildListeners();
        int size = listeners.size();
        int i = 0;
        while (i < size) {
            BuildListener listener = (BuildListener)listeners.elementAt(i);
            listener.buildFinished(event);
            ++i;
        }
    }

    protected void fireTargetStarted(Target target) {
        BuildEvent event = new BuildEvent(target);
        Vector listeners = this.getBuildListeners();
        int size = listeners.size();
        int i = 0;
        while (i < size) {
            BuildListener listener = (BuildListener)listeners.elementAt(i);
            listener.targetStarted(event);
            ++i;
        }
    }

    protected void fireTargetFinished(Target target, Throwable exception) {
        BuildEvent event = new BuildEvent(target);
        event.setException(exception);
        Vector listeners = this.getBuildListeners();
        int size = listeners.size();
        int i = 0;
        while (i < size) {
            BuildListener listener = (BuildListener)listeners.elementAt(i);
            listener.targetFinished(event);
            ++i;
        }
    }

    protected void fireTaskStarted(Task task) {
        this.registerThreadTask(Thread.currentThread(), task);
        BuildEvent event = new BuildEvent(task);
        Vector listeners = this.getBuildListeners();
        int size = listeners.size();
        int i = 0;
        while (i < size) {
            BuildListener listener = (BuildListener)listeners.elementAt(i);
            listener.taskStarted(event);
            ++i;
        }
    }

    protected void fireTaskFinished(Task task, Throwable exception) {
        this.registerThreadTask(Thread.currentThread(), null);
        System.out.flush();
        System.err.flush();
        BuildEvent event = new BuildEvent(task);
        event.setException(exception);
        Vector listeners = this.getBuildListeners();
        int size = listeners.size();
        int i = 0;
        while (i < size) {
            BuildListener listener = (BuildListener)listeners.elementAt(i);
            listener.taskFinished(event);
            ++i;
        }
    }

    private void fireMessageLoggedEvent(BuildEvent event, String message, int priority) {
        event.setMessage(message, priority);
        Vector listeners = this.getBuildListeners();
        Project project = this;
        synchronized (project) {
            if (this.loggingMessage) {
                throw new BuildException("Listener attempted to access " + (priority == 0 ? "System.err" : "System.out") + " - infinite loop terminated");
            }
            this.loggingMessage = true;
            int size = listeners.size();
            int i = 0;
            while (i < size) {
                BuildListener listener = (BuildListener)listeners.elementAt(i);
                listener.messageLogged(event);
                ++i;
            }
            this.loggingMessage = false;
        }
    }

    protected void fireMessageLogged(Project project, String message, int priority) {
        BuildEvent event = new BuildEvent(project);
        this.fireMessageLoggedEvent(event, message, priority);
    }

    protected void fireMessageLogged(Target target, String message, int priority) {
        BuildEvent event = new BuildEvent(target);
        this.fireMessageLoggedEvent(event, message, priority);
    }

    protected void fireMessageLogged(Task task, String message, int priority) {
        BuildEvent event = new BuildEvent(task);
        this.fireMessageLoggedEvent(event, message, priority);
    }

    public synchronized void registerThreadTask(Thread thread, Task task) {
        if (task != null) {
            this.threadTasks.put(thread, task);
            this.threadGroupTasks.put(thread.getThreadGroup(), task);
        } else {
            this.threadTasks.remove(thread);
            this.threadGroupTasks.remove(thread.getThreadGroup());
        }
    }

    public Task getThreadTask(Thread thread) {
        Task task = (Task)this.threadTasks.get(thread);
        if (task == null) {
            ThreadGroup group = thread.getThreadGroup();
            while (task == null && group != null) {
                task = (Task)this.threadGroupTasks.get(group);
                group = group.getParent();
            }
        }
        return task;
    }

    public final void setProjectReference(Object obj) {
        if (obj instanceof ProjectComponent) {
            ((ProjectComponent)obj).setProject(this);
            return;
        }
        try {
            Method method = obj.getClass().getMethod("setProject", class$org$apache$tools$ant$Project == null ? (class$org$apache$tools$ant$Project = Project.class$("org.apache.tools.ant.Project")) : class$org$apache$tools$ant$Project);
            if (method != null) {
                method.invoke(obj, this);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class AntRefTable
    extends Hashtable {
        Project project;

        public AntRefTable(Project project) {
            this.project = project;
        }

        public Object getReal(Object key) {
            return super.get(key);
        }

        public Object get(Object key) {
            Object o = super.get(key);
            if (o instanceof UnknownElement) {
                ((UnknownElement)o).maybeConfigure();
                o = ((UnknownElement)o).getTask();
            }
            return o;
        }
    }
}

