/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.IntrospectionHelper;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.PropertyHelper;
import org.apache.tools.ant.TaskAdapter;
import org.apache.tools.ant.helper.ProjectHelper2;
import org.apache.tools.ant.util.LoaderUtils;
import org.xml.sax.AttributeList;

public class ProjectHelper {
    public static final String HELPER_PROPERTY = "org.apache.tools.ant.ProjectHelper";
    public static final String SERVICE_ID = "META-INF/services/org.apache.tools.ant.ProjectHelper";
    protected Vector importStack = new Vector();

    public static void configureProject(Project project, File buildFile) throws BuildException {
        ProjectHelper helper = ProjectHelper.getProjectHelper();
        project.addReference("ant.projectHelper", helper);
        helper.parse(project, buildFile);
    }

    public Vector getImportStack() {
        return this.importStack;
    }

    public void parse(Project project, Object source) throws BuildException {
        throw new BuildException("ProjectHelper.parse() must be implemented in a helper plugin " + this.getClass().getName());
    }

    public static ProjectHelper getProjectHelper() throws BuildException {
        ProjectHelper helper;
        block14: {
            helper = null;
            String helperClass = System.getProperty(HELPER_PROPERTY);
            try {
                if (helperClass != null) {
                    helper = ProjectHelper.newHelper(helperClass);
                }
            }
            catch (SecurityException e) {
                System.out.println("Unable to load ProjectHelper class \"" + helperClass + " specified in system property " + HELPER_PROPERTY);
            }
            if (helper == null) {
                try {
                    InputStreamReader isr;
                    ClassLoader classLoader = LoaderUtils.getContextClassLoader();
                    InputStream is = null;
                    if (classLoader != null) {
                        is = classLoader.getResourceAsStream(SERVICE_ID);
                    }
                    if (is == null) {
                        is = ClassLoader.getSystemResourceAsStream(SERVICE_ID);
                    }
                    if (is == null) break block14;
                    try {
                        isr = new InputStreamReader(is, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        isr = new InputStreamReader(is);
                    }
                    BufferedReader rd = new BufferedReader(isr);
                    String helperClassName = rd.readLine();
                    rd.close();
                    if (helperClassName != null && !"".equals(helperClassName)) {
                        helper = ProjectHelper.newHelper(helperClassName);
                    }
                }
                catch (Exception ex) {
                    System.out.println("Unable to load ProjectHelper from service \"META-INF/services/org.apache.tools.ant.ProjectHelper");
                }
            }
        }
        if (helper != null) {
            return helper;
        }
        try {
            return new ProjectHelper2();
        }
        catch (Throwable e) {
            String message = "Unable to load default ProjectHelper due to " + e.getClass().getName() + ": " + e.getMessage();
            throw new BuildException(message, e);
        }
    }

    private static ProjectHelper newHelper(String helperClass) throws BuildException {
        ClassLoader classLoader = LoaderUtils.getContextClassLoader();
        try {
            Class<?> clazz = null;
            if (classLoader != null) {
                try {
                    clazz = classLoader.loadClass(helperClass);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (clazz == null) {
                clazz = Class.forName(helperClass);
            }
            return (ProjectHelper)clazz.newInstance();
        }
        catch (Exception e) {
            throw new BuildException(e);
        }
    }

    public static ClassLoader getContextClassLoader() {
        if (!LoaderUtils.isContextLoaderAvailable()) {
            return null;
        }
        return LoaderUtils.getContextClassLoader();
    }

    public static void configure(Object target, AttributeList attrs, Project project) throws BuildException {
        if (target instanceof TaskAdapter) {
            target = ((TaskAdapter)target).getProxy();
        }
        IntrospectionHelper ih = IntrospectionHelper.getHelper(target.getClass());
        project.addBuildListener(ih);
        int i = 0;
        while (i < attrs.getLength()) {
            block4: {
                String value = ProjectHelper.replaceProperties(project, attrs.getValue(i), project.getProperties());
                try {
                    ih.setAttribute(project, target, attrs.getName(i).toLowerCase(Locale.US), value);
                }
                catch (BuildException be) {
                    if (attrs.getName(i).equals("id")) break block4;
                    throw be;
                }
            }
            ++i;
        }
    }

    public static void addText(Project project, Object target, char[] buf, int start, int count) throws BuildException {
        ProjectHelper.addText(project, target, new String(buf, start, count));
    }

    public static void addText(Project project, Object target, String text) throws BuildException {
        if (text == null) {
            return;
        }
        if (target instanceof TaskAdapter) {
            target = ((TaskAdapter)target).getProxy();
        }
        IntrospectionHelper.getHelper(target.getClass()).addText(project, target, text);
    }

    public static void storeChild(Project project, Object parent, Object child, String tag) {
        IntrospectionHelper ih = IntrospectionHelper.getHelper(parent.getClass());
        ih.storeElement(project, parent, child, tag);
    }

    public static String replaceProperties(Project project, String value) throws BuildException {
        return project.replaceProperties(value);
    }

    public static String replaceProperties(Project project, String value, Hashtable keys) throws BuildException {
        PropertyHelper ph = PropertyHelper.getPropertyHelper(project);
        return ph.replaceProperties(null, value, keys);
    }

    public static void parsePropertyString(String value, Vector fragments, Vector propertyRefs) throws BuildException {
        PropertyHelper.parsePropertyStringDefault(value, fragments, propertyRefs);
    }
}

