/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;

public class PropertyHelper {
    protected Project project;
    protected PropertyHelper next;
    protected Hashtable properties = new Hashtable();
    protected Hashtable userProperties = new Hashtable();
    protected Hashtable inheritedProperties = new Hashtable();

    protected PropertyHelper() {
    }

    public void setProject(Project p) {
        this.project = p;
    }

    public void setNext(PropertyHelper next) {
        this.next = next;
    }

    public PropertyHelper getNext() {
        return this.next;
    }

    public static PropertyHelper getPropertyHelper(Project project) {
        PropertyHelper ph = (PropertyHelper)project.getReference("ant.PropertyHelper");
        if (ph != null) {
            return ph;
        }
        ph = new PropertyHelper();
        ph.setProject(project);
        project.addReference("ant.PropertyHelper", ph);
        return ph;
    }

    public boolean setPropertyHook(String ns, String name, Object value, boolean inherited, boolean user, boolean isNew) {
        boolean subst;
        return this.getNext() != null && (subst = this.getNext().setPropertyHook(ns, name, value, inherited, user, isNew));
    }

    public Object getPropertyHook(String ns, String name, boolean user) {
        Object o;
        if (this.getNext() != null && (o = this.getNext().getPropertyHook(ns, name, user)) != null) {
            return o;
        }
        if (name.startsWith("toString:")) {
            Object v = this.project.getReference(name = name.substring("toString:".length()));
            if (v == null) {
                return null;
            }
            return v.toString();
        }
        return null;
    }

    public void parsePropertyString(String value, Vector fragments, Vector propertyRefs) throws BuildException {
        PropertyHelper.parsePropertyStringDefault(value, fragments, propertyRefs);
    }

    public String replaceProperties(String ns, String value, Hashtable keys) throws BuildException {
        if (value == null) {
            return null;
        }
        Vector fragments = new Vector();
        Vector propertyRefs = new Vector();
        this.parsePropertyString(value, fragments, propertyRefs);
        StringBuffer sb = new StringBuffer();
        Enumeration i = fragments.elements();
        Enumeration j = propertyRefs.elements();
        while (i.hasMoreElements()) {
            String fragment = (String)i.nextElement();
            if (fragment == null) {
                String propertyName = (String)j.nextElement();
                Object replacement = null;
                if (keys != null) {
                    replacement = keys.get(propertyName);
                }
                if (replacement == null) {
                    replacement = this.getProperty(ns, propertyName);
                }
                if (replacement == null) {
                    this.project.log("Property ${" + propertyName + "} has not been set", 3);
                }
                fragment = replacement != null ? replacement.toString() : "${" + propertyName + "}";
            }
            sb.append(fragment);
        }
        return sb.toString();
    }

    public synchronized boolean setProperty(String ns, String name, Object value, boolean verbose) {
        if (null != this.userProperties.get(name)) {
            if (verbose) {
                this.project.log("Override ignored for user property " + name, 3);
            }
            return false;
        }
        boolean done = this.setPropertyHook(ns, name, value, false, false, false);
        if (done) {
            return true;
        }
        if (null != this.properties.get(name) && verbose) {
            this.project.log("Overriding previous definition of property " + name, 3);
        }
        if (verbose) {
            this.project.log("Setting project property: " + name + " -> " + value, 4);
        }
        this.properties.put(name, value);
        return true;
    }

    public synchronized void setNewProperty(String ns, String name, Object value) {
        if (null != this.properties.get(name)) {
            this.project.log("Override ignored for property " + name, 3);
            return;
        }
        boolean done = this.setPropertyHook(ns, name, value, false, true, false);
        if (done) {
            return;
        }
        this.project.log("Setting project property: " + name + " -> " + value, 4);
        if (name != null && value != null) {
            this.properties.put(name, value);
        }
    }

    public synchronized void setUserProperty(String ns, String name, Object value) {
        this.project.log("Setting ro project property: " + name + " -> " + value, 4);
        this.userProperties.put(name, value);
        boolean done = this.setPropertyHook(ns, name, value, false, false, true);
        if (done) {
            return;
        }
        this.properties.put(name, value);
    }

    public synchronized void setInheritedProperty(String ns, String name, Object value) {
        this.inheritedProperties.put(name, value);
        this.project.log("Setting ro project property: " + name + " -> " + value, 4);
        this.userProperties.put(name, value);
        boolean done = this.setPropertyHook(ns, name, value, true, false, false);
        if (done) {
            return;
        }
        this.properties.put(name, value);
    }

    public Object getProperty(String ns, String name) {
        if (name == null) {
            return null;
        }
        Object o = this.getPropertyHook(ns, name, false);
        if (o != null) {
            return o;
        }
        return this.properties.get(name);
    }

    public Object getUserProperty(String ns, String name) {
        if (name == null) {
            return null;
        }
        Object o = this.getPropertyHook(ns, name, true);
        if (o != null) {
            return o;
        }
        return this.userProperties.get(name);
    }

    public Hashtable getProperties() {
        Hashtable propertiesCopy = new Hashtable();
        Enumeration e = this.properties.keys();
        while (e.hasMoreElements()) {
            Object name = e.nextElement();
            Object value = this.properties.get(name);
            propertiesCopy.put(name, value);
        }
        return propertiesCopy;
    }

    public Hashtable getUserProperties() {
        Hashtable propertiesCopy = new Hashtable();
        Enumeration e = this.userProperties.keys();
        while (e.hasMoreElements()) {
            Object name = e.nextElement();
            Object value = this.properties.get(name);
            propertiesCopy.put(name, value);
        }
        return propertiesCopy;
    }

    public void copyInheritedProperties(Project other) {
        Enumeration e = this.inheritedProperties.keys();
        while (e.hasMoreElements()) {
            String arg = e.nextElement().toString();
            if (other.getUserProperty(arg) != null) continue;
            Object value = this.inheritedProperties.get(arg);
            other.setInheritedProperty(arg, value.toString());
        }
    }

    public void copyUserProperties(Project other) {
        Enumeration e = this.userProperties.keys();
        while (e.hasMoreElements()) {
            Object arg = e.nextElement();
            if (this.inheritedProperties.containsKey(arg)) continue;
            Object value = this.userProperties.get(arg);
            other.setUserProperty(arg.toString(), value.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    static void parsePropertyStringDefault(String value, Vector fragments, Vector propertyRefs) throws BuildException {
        int pos;
        int prev = 0;
        while ((pos = value.indexOf("$", prev)) >= 0) {
            void var4_4;
            if (var4_4 > 0) {
                fragments.addElement(value.substring(prev, (int)var4_4));
            }
            if (var4_4 == value.length() - 1) {
                fragments.addElement("$");
                prev = var4_4 + true;
                continue;
            }
            if (value.charAt((int)(var4_4 + true)) != '{') {
                if (value.charAt((int)(var4_4 + true)) == '$') {
                    fragments.addElement("$");
                    prev = var4_4 + 2;
                    continue;
                }
                fragments.addElement(value.substring((int)var4_4, (int)(var4_4 + 2)));
                prev = var4_4 + 2;
                continue;
            }
            int endName = value.indexOf(125, (int)var4_4);
            if (endName < 0) {
                throw new BuildException("Syntax error in property: " + value);
            }
            String propertyName = value.substring((int)(var4_4 + 2), endName);
            fragments.addElement(null);
            propertyRefs.addElement(propertyName);
            prev = endName + 1;
        }
        if (prev < value.length()) {
            fragments.addElement(value.substring(prev));
        }
    }
}

