/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.IntrospectionHelper;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskAdapter;
import org.xml.sax.AttributeList;
import org.xml.sax.helpers.AttributeListImpl;

public class RuntimeConfigurable
implements Serializable {
    private String elementTag = null;
    private Vector children = new Vector();
    private transient Object wrappedObject = null;
    private transient AttributeList attributes;
    private Vector attributeNames = new Vector();
    private Hashtable attributeMap = new Hashtable();
    private StringBuffer characters = new StringBuffer();
    private boolean proxyConfigured = false;

    public RuntimeConfigurable(Object proxy, String elementTag) {
        this.wrappedObject = proxy;
        this.elementTag = elementTag;
        this.proxyConfigured = false;
        if (proxy instanceof Task) {
            ((Task)proxy).setRuntimeConfigurableWrapper(this);
        }
    }

    void setProxy(Object proxy) {
        this.wrappedObject = proxy;
        this.proxyConfigured = false;
    }

    public Object getProxy() {
        return this.wrappedObject;
    }

    public void setAttributes(AttributeList attributes) {
        this.attributes = new AttributeListImpl(attributes);
        int i = 0;
        while (i < attributes.getLength()) {
            this.setAttribute(attributes.getName(i), attributes.getValue(i));
            ++i;
        }
    }

    public void setAttribute(String name, String value) {
        this.attributeNames.addElement(name);
        this.attributeMap.put(name, value);
    }

    public Hashtable getAttributeMap() {
        return this.attributeMap;
    }

    public AttributeList getAttributes() {
        return this.attributes;
    }

    public void addChild(RuntimeConfigurable child) {
        this.children.addElement(child);
    }

    RuntimeConfigurable getChild(int index) {
        return (RuntimeConfigurable)this.children.elementAt(index);
    }

    Enumeration getChildren() {
        return this.children.elements();
    }

    public void addText(String data) {
        this.characters.append(data);
    }

    public void addText(char[] buf, int start, int count) {
        this.addText(new String(buf, start, count));
    }

    public StringBuffer getText() {
        return this.characters;
    }

    public String getElementTag() {
        return this.elementTag;
    }

    public void maybeConfigure(Project p) throws BuildException {
        this.maybeConfigure(p, true);
    }

    public void maybeConfigure(Project p, boolean configureChildren) throws BuildException {
        String id = null;
        if (this.proxyConfigured) {
            return;
        }
        Object target = this.wrappedObject instanceof TaskAdapter ? ((TaskAdapter)this.wrappedObject).getProxy() : this.wrappedObject;
        IntrospectionHelper ih = IntrospectionHelper.getHelper(p, target.getClass());
        int i = 0;
        while (i < this.attributeNames.size()) {
            block8: {
                String name = (String)this.attributeNames.elementAt(i);
                String value = (String)this.attributeMap.get(name);
                value = p.replaceProperties(value);
                try {
                    ih.setAttribute(p, target, name.toLowerCase(Locale.US), value);
                }
                catch (BuildException be) {
                    if (name.equals("id")) break block8;
                    throw be;
                }
            }
            ++i;
        }
        id = (String)this.attributeMap.get("id");
        if (this.characters.length() != 0) {
            ProjectHelper.addText(p, this.wrappedObject, this.characters.substring(0));
        }
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            RuntimeConfigurable child = (RuntimeConfigurable)enumeration.nextElement();
            if (child.wrappedObject instanceof Task) {
                Task childTask = (Task)child.wrappedObject;
                childTask.setRuntimeConfigurableWrapper(child);
            }
            String tag = child.getElementTag().toLowerCase(Locale.US);
            if (!configureChildren || !ih.supportsNestedElement(tag)) continue;
            child.maybeConfigure(p);
            ProjectHelper.storeChild(p, target, child.wrappedObject, tag);
        }
        if (id != null) {
            p.addReference(id, this.wrappedObject);
        }
        this.proxyConfigured = true;
    }

    public void reconfigure(Project p) {
        this.proxyConfigured = false;
        this.maybeConfigure(p);
    }
}

