/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.filters;

import java.io.IOException;
import java.io.Reader;
import org.apache.tools.ant.filters.BaseParamFilterReader;
import org.apache.tools.ant.filters.ChainableReader;
import org.apache.tools.ant.types.Parameter;

public class EscapeUnicode
extends BaseParamFilterReader
implements ChainableReader {
    private StringBuffer unicodeBuf = new StringBuffer();

    public EscapeUnicode() {
    }

    public EscapeUnicode(Reader in) {
        super(in);
    }

    public final int read() throws IOException {
        if (!this.getInitialized()) {
            this.initialize();
            this.setInitialized(true);
        }
        int ch = -1;
        if (this.unicodeBuf.length() == 0) {
            char achar;
            ch = this.in.read();
            if (ch != -1 && (achar = (char)ch) >= '\u0080') {
                this.unicodeBuf = new StringBuffer("u0000");
                String s = Integer.toHexString(ch);
                int i = 0;
                while (i < s.length()) {
                    this.unicodeBuf.setCharAt(this.unicodeBuf.length() - s.length() + i, s.charAt(i));
                    ++i;
                }
                ch = 92;
            }
        } else {
            ch = this.unicodeBuf.charAt(0);
            this.unicodeBuf.deleteCharAt(0);
        }
        return ch;
    }

    public final Reader chain(Reader rdr) {
        EscapeUnicode newFilter = new EscapeUnicode(rdr);
        newFilter.setInitialized(true);
        return newFilter;
    }

    private final void initialize() {
        Parameter[] params = this.getParameters();
        if (params != null) {
            int i = 0;
            while (i < params.length) {
                ++i;
            }
        }
    }
}

