/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.helper;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Stack;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.helper.AntXMLContext;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.JAXPUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ProjectHelper2
extends ProjectHelper {
    private static AntHandler elementHandler = new ElementHandler();
    private static AntHandler targetHandler = new TargetHandler();
    private static AntHandler mainHandler = new MainHandler();
    private static AntHandler projectHandler = new ProjectHandler();
    private static FileUtils fu = FileUtils.newFileUtils();

    public void parse(Project project, Object source) throws BuildException {
        this.getImportStack().addElement(source);
        AntXMLContext context = null;
        context = (AntXMLContext)project.getReference("ant.parsing.context");
        if (context == null) {
            context = new AntXMLContext(project);
            project.addReference("ant.parsing.context", context);
            project.addReference("ant.targets", context.getTargets());
        }
        if (this.getImportStack().size() > 1) {
            context.setIgnoreProjectTag(true);
            this.parse(project, source, new RootHandler(context));
        } else {
            this.parse(project, source, new RootHandler(context));
            context.getImplicitTarget().execute();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parse(Project project, Object source, RootHandler handler) throws BuildException {
        AntXMLContext context = handler.context;
        File buildFile = null;
        if (!(source instanceof File)) throw new BuildException("Source " + source.getClass().getName() + " not supported by this plugin");
        buildFile = (File)source;
        FileInputStream inputStream = null;
        InputSource inputSource = null;
        buildFile = new File(buildFile.getAbsolutePath());
        context.setBuildFile(buildFile);
        try {
            try {
                XMLReader parser = JAXPUtils.getNamespaceXMLReader();
                String uri = fu.toURI(buildFile.getAbsolutePath());
                inputStream = new FileInputStream(buildFile);
                inputSource = new InputSource(inputStream);
                inputSource.setSystemId(uri);
                project.log("parsing buildfile " + buildFile + " with URI = " + uri, 3);
                RootHandler hb = handler;
                parser.setContentHandler(hb);
                parser.setEntityResolver(hb);
                parser.setErrorHandler(hb);
                parser.setDTDHandler(hb);
                parser.parse(inputSource);
            }
            catch (SAXParseException exc) {
                Location location = new Location(exc.getSystemId(), exc.getLineNumber(), exc.getColumnNumber());
                Exception t = exc.getException();
                if (!(t instanceof BuildException)) throw new BuildException(exc.getMessage(), t, location);
                BuildException be = (BuildException)t;
                if (be.getLocation() != Location.UNKNOWN_LOCATION) throw be;
                be.setLocation(location);
                throw be;
            }
            catch (SAXException exc) {
                Exception t = exc.getException();
                if (!(t instanceof BuildException)) throw new BuildException(exc.getMessage(), t);
                throw (BuildException)t;
            }
            catch (FileNotFoundException exc) {
                throw new BuildException(exc);
            }
            catch (UnsupportedEncodingException exc) {
                throw new BuildException("Encoding of project file is invalid.", exc);
            }
            catch (IOException exc) {
                throw new BuildException("Error reading project file: " + exc.getMessage(), exc);
            }
            Object var14_17 = null;
            if (inputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var14_18 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ioe) {}
        inputStream.close();
        return;
    }

    static /* synthetic */ AntHandler access$100() {
        return mainHandler;
    }

    public static class ElementHandler
    extends AntHandler {
        public void onStartElement(String uri, String tag, String qname, Attributes attrs, AntXMLContext context) throws SAXParseException {
            RuntimeConfigurable parentWrapper = context.currentWrapper();
            Object parent = null;
            if (parentWrapper != null) {
                parent = parentWrapper.getProxy();
            }
            UnknownElement task = new UnknownElement(tag);
            task.setNamespace(uri);
            task.setProject(context.getProject());
            task.setTaskName(qname);
            Location location = new Location(context.getLocator().getSystemId(), context.getLocator().getLineNumber(), context.getLocator().getColumnNumber());
            task.setLocation(location);
            task.setOwningTarget(context.getCurrentTarget());
            context.configureId(task, attrs);
            if (parent != null) {
                ((UnknownElement)parent).addChild(task);
            } else {
                context.getCurrentTarget().addTask(task);
            }
            RuntimeConfigurable wrapper = new RuntimeConfigurable(task, task.getTaskName());
            int i = 0;
            while (i < attrs.getLength()) {
                wrapper.setAttribute(attrs.getQName(i), attrs.getValue(i));
                ++i;
            }
            if (parentWrapper != null) {
                parentWrapper.addChild(wrapper);
            }
            context.pushWrapper(wrapper);
        }

        public void characters(char[] buf, int start, int count, AntXMLContext context) throws SAXParseException {
            RuntimeConfigurable wrapper = context.currentWrapper();
            wrapper.addText(buf, start, count);
        }

        public AntHandler onStartChild(String uri, String tag, String qname, Attributes attrs, AntXMLContext context) throws SAXParseException {
            return elementHandler;
        }

        public void onEndElement(String uri, String tag, AntXMLContext context) {
            context.popWrapper();
        }
    }

    public static class TargetHandler
    extends AntHandler {
        public void onStartElement(String uri, String tag, String qname, Attributes attrs, AntXMLContext context) throws SAXParseException {
            String name = null;
            String depends = "";
            Project project = context.getProject();
            Target target = new Target();
            context.addTarget(target);
            int i = 0;
            while (i < attrs.getLength()) {
                String key = attrs.getQName(i);
                String value = attrs.getValue(i);
                if (key.equals("name")) {
                    name = value;
                    if ("".equals(name)) {
                        throw new BuildException("name attribute must not be empty");
                    }
                } else if (key.equals("depends")) {
                    depends = value;
                } else if (key.equals("if")) {
                    target.setIf(value);
                } else if (key.equals("unless")) {
                    target.setUnless(value);
                } else if (key.equals("id")) {
                    if (value != null && !value.equals("")) {
                        context.getProject().addReference(value, target);
                    }
                } else if (key.equals("description")) {
                    target.setDescription(value);
                } else {
                    throw new SAXParseException("Unexpected attribute \"" + key + "\"", context.getLocator());
                }
                ++i;
            }
            if (name == null) {
                throw new SAXParseException("target element appears without a name attribute", context.getLocator());
            }
            Hashtable currentTargets = project.getTargets();
            if (currentTargets.containsKey(name)) {
                if (context.getCurrentProjectName() != null) {
                    String newName = context.getCurrentProjectName() + "." + name;
                    project.log("Already defined in main or a previous import, define " + name + " as " + newName, 3);
                    name = newName;
                } else {
                    project.log("Already defined in main or a previous import, ignore " + name, 3);
                    name = null;
                }
            }
            if (name != null) {
                target.setName(name);
                project.addOrReplaceTarget(name, target);
            }
            if (depends.length() > 0) {
                target.setDepends(depends);
            }
        }

        public AntHandler onStartChild(String uri, String name, String qname, Attributes attrs, AntXMLContext context) throws SAXParseException {
            return elementHandler;
        }

        public void onEndElement(String uri, String tag, AntXMLContext context) {
            context.setCurrentTarget(context.getImplicitTarget());
        }
    }

    public static class ProjectHandler
    extends AntHandler {
        public void onStartElement(String uri, String tag, String qname, Attributes attrs, AntXMLContext context) throws SAXParseException {
            Object id = null;
            String baseDir = null;
            Project project = context.getProject();
            int i = 0;
            while (i < attrs.getLength()) {
                String key = attrs.getQName(i);
                String value = attrs.getValue(i);
                if (key.equals("default")) {
                    if (value != null && !value.equals("") && !context.isIgnoringProjectTag()) {
                        project.setDefaultTarget(value);
                    }
                } else if (key.equals("name")) {
                    if (value != null) {
                        context.setCurrentProjectName(value);
                        if (!context.isIgnoringProjectTag()) {
                            project.setName(value);
                            project.addReference(value, project);
                        }
                    }
                } else if (key.equals("id")) {
                    if (value != null && !context.isIgnoringProjectTag()) {
                        project.addReference(value, project);
                    }
                } else if (key.equals("basedir")) {
                    if (!context.isIgnoringProjectTag()) {
                        baseDir = value;
                    }
                } else {
                    throw new SAXParseException("Unexpected attribute \"" + attrs.getQName(i) + "\"", context.getLocator());
                }
                ++i;
            }
            String antFileProp = "ant.file." + context.getCurrentProjectName();
            String dup = project.getProperty(antFileProp);
            if (dup != null) {
                File dupFile = new File(dup);
                if (context.isIgnoringProjectTag() && !dupFile.equals(context.getBuildFile())) {
                    project.log("Duplicated project name in import. Project " + context.getCurrentProjectName() + " defined first in " + dup + " and again in " + context.getBuildFile(), 1);
                }
            }
            if (context.getBuildFile() != null) {
                project.setUserProperty("ant.file." + context.getCurrentProjectName(), context.getBuildFile().toString());
            }
            if (context.isIgnoringProjectTag()) {
                return;
            }
            if (project.getProperty("basedir") != null) {
                project.setBasedir(project.getProperty("basedir"));
            } else if (baseDir == null) {
                project.setBasedir(context.getBuildFileParent().getAbsolutePath());
            } else if (new File(baseDir).isAbsolute()) {
                project.setBasedir(baseDir);
            } else {
                project.setBaseDir(project.resolveFile(baseDir, context.getBuildFileParent()));
            }
            project.addTarget("", context.getImplicitTarget());
            context.setCurrentTarget(context.getImplicitTarget());
        }

        public AntHandler onStartChild(String uri, String name, String qname, Attributes attrs, AntXMLContext context) throws SAXParseException {
            if (qname.equals("target")) {
                return targetHandler;
            }
            return elementHandler;
        }
    }

    public static class MainHandler
    extends AntHandler {
        public AntHandler onStartChild(String uri, String name, String qname, Attributes attrs, AntXMLContext context) throws SAXParseException {
            if (qname.equals("project")) {
                return projectHandler;
            }
            throw new SAXParseException("Unexpected element \"" + qname + "\" " + name, context.getLocator());
        }
    }

    public static class RootHandler
    extends DefaultHandler {
        private Stack antHandlers = new Stack();
        private AntHandler currentHandler = ProjectHelper2.access$100();
        private AntXMLContext context;

        public RootHandler(AntXMLContext context) {
            this.antHandlers.push(this.currentHandler);
            this.context = context;
        }

        public InputSource resolveEntity(String publicId, String systemId) {
            this.context.getProject().log("resolving systemId: " + systemId, 3);
            if (systemId.startsWith("file:")) {
                String path = fu.fromURI(systemId);
                File file = new File(path);
                if (!file.isAbsolute()) {
                    file = fu.resolveFile(this.context.getBuildFileParent(), path);
                }
                try {
                    InputSource inputSource = new InputSource(new FileInputStream(file));
                    inputSource.setSystemId(fu.toURI(file.getAbsolutePath()));
                    return inputSource;
                }
                catch (FileNotFoundException fne) {
                    this.context.getProject().log(file.getAbsolutePath() + " could not be found", 1);
                }
            }
            return null;
        }

        public void startElement(String uri, String tag, String qname, Attributes attrs) throws SAXParseException {
            AntHandler next = this.currentHandler.onStartChild(uri, tag, qname, attrs, this.context);
            this.antHandlers.push(this.currentHandler);
            this.currentHandler = next;
            this.currentHandler.onStartElement(uri, tag, qname, attrs, this.context);
        }

        public void setDocumentLocator(Locator locator) {
            this.context.setLocator(locator);
        }

        public void endElement(String uri, String name, String qName) throws SAXException {
            AntHandler prev;
            this.currentHandler.onEndElement(uri, name, this.context);
            this.currentHandler = prev = (AntHandler)this.antHandlers.pop();
            if (this.currentHandler != null) {
                this.currentHandler.onEndChild(uri, name, qName, this.context);
            }
        }

        public void characters(char[] buf, int start, int count) throws SAXParseException {
            this.currentHandler.characters(buf, start, count, this.context);
        }
    }

    public static class AntHandler {
        public void onStartElement(String uri, String tag, String qname, Attributes attrs, AntXMLContext context) throws SAXParseException {
        }

        public AntHandler onStartChild(String uri, String tag, String qname, Attributes attrs, AntXMLContext context) throws SAXParseException {
            throw new SAXParseException("Unexpected element \"" + qname + " \"", context.getLocator());
        }

        public void onEndChild(String uri, String tag, String qname, AntXMLContext context) throws SAXParseException {
        }

        public void onEndElement(String uri, String tag, AntXMLContext context) {
        }

        public void characters(char[] buf, int start, int count, AntXMLContext context) throws SAXParseException {
            String s = new String(buf, start, count).trim();
            if (s.length() > 0) {
                throw new SAXParseException("Unexpected text \"" + s + "\"", context.getLocator());
            }
        }

        protected void checkNamespace(String uri) {
        }
    }
}

