/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Property;
import org.apache.tools.ant.types.PropertySet;
import org.apache.tools.ant.util.FileUtils;

public class Ant
extends Task {
    private File dir = null;
    private String antFile = null;
    private String target = null;
    private String output = null;
    private boolean inheritAll = true;
    private boolean inheritRefs = false;
    private Vector properties = new Vector();
    private Vector references = new Vector();
    private Project newProject;
    private PrintStream out = null;
    private Vector propertySets = new Vector();
    static /* synthetic */ Class class$org$apache$tools$ant$Project;

    public void setInheritAll(boolean value) {
        this.inheritAll = value;
    }

    public void setInheritRefs(boolean value) {
        this.inheritRefs = value;
    }

    public void init() {
        this.newProject = new Project();
        this.newProject.setDefaultInputStream(this.getProject().getDefaultInputStream());
        this.newProject.setJavaVersionProperty();
        this.newProject.addTaskDefinition("property", (Class)this.getProject().getTaskDefinitions().get("property"));
    }

    private void reinit() {
        this.init();
        int count = this.properties.size();
        int i = 0;
        while (i < count) {
            Property p = (Property)this.properties.elementAt(i);
            Property newP = (Property)this.newProject.createTask("property");
            newP.setName(p.getName());
            if (p.getValue() != null) {
                newP.setValue(p.getValue());
            }
            if (p.getFile() != null) {
                newP.setFile(p.getFile());
            }
            if (p.getResource() != null) {
                newP.setResource(p.getResource());
            }
            if (p.getPrefix() != null) {
                newP.setPrefix(p.getPrefix());
            }
            if (p.getRefid() != null) {
                newP.setRefid(p.getRefid());
            }
            if (p.getEnvironment() != null) {
                newP.setEnvironment(p.getEnvironment());
            }
            if (p.getClasspath() != null) {
                newP.setClasspath(p.getClasspath());
            }
            this.properties.setElementAt(newP, i);
            ++i;
        }
    }

    private void initializeProject() {
        this.newProject.setInputHandler(this.getProject().getInputHandler());
        Vector listeners = this.getProject().getBuildListeners();
        int count = listeners.size();
        int i = 0;
        while (i < count) {
            this.newProject.addBuildListener((BuildListener)listeners.elementAt(i));
            ++i;
        }
        if (this.output != null) {
            File outfile = null;
            outfile = this.dir != null ? FileUtils.newFileUtils().resolveFile(this.dir, this.output) : this.getProject().resolveFile(this.output);
            try {
                this.out = new PrintStream(new FileOutputStream(outfile));
                DefaultLogger logger = new DefaultLogger();
                logger.setMessageOutputLevel(2);
                logger.setOutputPrintStream(this.out);
                logger.setErrorPrintStream(this.out);
                this.newProject.addBuildListener(logger);
            }
            catch (IOException ex) {
                this.log("Ant: Can't set output to " + this.output);
            }
        }
        Hashtable taskdefs = this.getProject().getTaskDefinitions();
        Enumeration et = taskdefs.keys();
        while (et.hasMoreElements()) {
            String taskName = (String)et.nextElement();
            if (taskName.equals("property")) continue;
            Class taskClass = (Class)taskdefs.get(taskName);
            this.newProject.addTaskDefinition(taskName, taskClass);
        }
        Hashtable typedefs = this.getProject().getDataTypeDefinitions();
        Enumeration<Object> e = typedefs.keys();
        while (e.hasMoreElements()) {
            String typeName = (String)e.nextElement();
            Class typeClass = (Class)typedefs.get(typeName);
            this.newProject.addDataTypeDefinition(typeName, typeClass);
        }
        this.getProject().copyUserProperties(this.newProject);
        if (!this.inheritAll) {
            this.newProject.setSystemProperties();
        } else {
            this.addAlmostAll(this.getProject().getProperties());
        }
        e = this.propertySets.elements();
        while (e.hasMoreElements()) {
            PropertySet ps = (PropertySet)e.nextElement();
            this.addAlmostAll(ps.getProperties());
        }
    }

    public void handleOutput(String line) {
        if (this.newProject != null) {
            this.newProject.demuxOutput(line, false);
        } else {
            super.handleOutput(line);
        }
    }

    public int handleInput(byte[] buffer, int offset, int length) throws IOException {
        if (this.newProject != null) {
            return this.newProject.demuxInput(buffer, offset, length);
        }
        return super.handleInput(buffer, offset, length);
    }

    public void handleFlush(String line) {
        if (this.newProject != null) {
            this.newProject.demuxFlush(line, false);
        } else {
            super.handleFlush(line);
        }
    }

    public void handleErrorOutput(String line) {
        if (this.newProject != null) {
            this.newProject.demuxOutput(line, true);
        } else {
            super.handleErrorOutput(line);
        }
    }

    public void handleErrorFlush(String line) {
        if (this.newProject != null) {
            this.newProject.demuxFlush(line, true);
        } else {
            super.handleErrorFlush(line);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void execute() throws BuildException {
        block19: {
            savedDir = this.dir;
            savedAntFile = this.antFile;
            savedTarget = this.target;
            try {
                if (this.newProject == null) {
                    this.reinit();
                }
                if (this.dir == null && this.inheritAll) {
                    this.dir = this.getProject().getBaseDir();
                }
                this.initializeProject();
                if (this.dir != null) {
                    this.newProject.setBaseDir(this.dir);
                    if (savedDir != null) {
                        this.newProject.setInheritedProperty("basedir", this.dir.getAbsolutePath());
                    }
                } else {
                    this.dir = this.getProject().getBaseDir();
                }
                this.overrideProperties();
                if (this.antFile == null) {
                    this.antFile = "build.xml";
                }
                file = FileUtils.newFileUtils().resolveFile(this.dir, this.antFile);
                this.antFile = file.getAbsolutePath();
                this.log("calling target " + (this.target != null ? this.target : "[default]") + " in build file " + this.antFile.toString(), 3);
                this.newProject.setUserProperty("ant.file", this.antFile);
                ProjectHelper.configureProject(this.newProject, new File(this.antFile));
                if (this.target == null) {
                    this.target = this.newProject.getDefaultTarget();
                }
                if (this.newProject.getBaseDir().equals(this.getProject().getBaseDir()) && this.newProject.getProperty("ant.file").equals(this.getProject().getProperty("ant.file")) && this.getOwningTarget() != null && (this.getOwningTarget().getName().equals("") || this.getOwningTarget().getName().equals(this.target))) {
                    throw new BuildException("ant task calling its own parent target");
                }
                this.addReferences();
                if (this.target != null) {
                    this.newProject.executeTarget(this.target);
                } else {
                    this.newProject.executeTarget("");
                }
                var6_5 = null;
                this.newProject = null;
                enum = this.properties.elements();
                ** while (enum.hasMoreElements())
            }
            catch (Throwable var5_11) {
                var6_6 = null;
                this.newProject = null;
                enum = this.properties.elements();
                ** while (enum.hasMoreElements())
            }
lbl-1000:
            // 1 sources

            {
                p = (Property)enum.nextElement();
                p.setProject(null);
                continue;
            }
lbl41:
            // 1 sources

            if (this.output != null && this.out != null) {
                try {
                    this.out.close();
                    break block19;
                }
                catch (Exception e) {
                    // empty catch block
                }
                {
                    break block19;
                }
            }
            break block19;
lbl-1000:
            // 1 sources

            {
                p = (Property)enum.nextElement();
                p.setProject(null);
                continue;
            }
lbl58:
            // 1 sources

            if (this.output != null && this.out != null) {
                try {
                    this.out.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.dir = savedDir;
            this.antFile = savedAntFile;
            this.target = savedTarget;
            throw var5_11;
        }
        this.dir = savedDir;
        this.antFile = savedAntFile;
        this.target = savedTarget;
    }

    private void overrideProperties() throws BuildException {
        Enumeration e = this.properties.elements();
        while (e.hasMoreElements()) {
            Property p = (Property)e.nextElement();
            p.setProject(this.newProject);
            p.execute();
        }
        this.getProject().copyInheritedProperties(this.newProject);
    }

    private void addReferences() throws BuildException {
        Enumeration<Object> e;
        Hashtable thisReferences = (Hashtable)this.getProject().getReferences().clone();
        Hashtable newReferences = this.newProject.getReferences();
        if (this.references.size() > 0) {
            e = this.references.elements();
            while (e.hasMoreElements()) {
                Reference ref = (Reference)e.nextElement();
                String refid = ref.getRefId();
                if (refid == null) {
                    throw new BuildException("the refid attribute is required for reference elements");
                }
                if (!thisReferences.containsKey(refid)) {
                    this.log("Parent project doesn't contain any reference '" + refid + "'", 1);
                    continue;
                }
                thisReferences.remove(refid);
                String toRefid = ref.getToRefid();
                if (toRefid == null) {
                    toRefid = refid;
                }
                this.copyReference(refid, toRefid);
            }
        }
        if (this.inheritRefs) {
            e = thisReferences.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (newReferences.containsKey(key)) continue;
                this.copyReference(key, key);
            }
        }
    }

    private void copyReference(String oldKey, String newKey) {
        Object orig = this.getProject().getReference(oldKey);
        if (orig == null) {
            this.log("No object referenced by " + oldKey + ". Can't copy to " + newKey, 1);
            return;
        }
        Class<?> c = orig.getClass();
        Object copy = orig;
        try {
            Method cloneM = c.getMethod("clone", new Class[0]);
            if (cloneM != null) {
                copy = cloneM.invoke(orig, new Object[0]);
                this.log("Adding clone of reference " + oldKey, 4);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (copy instanceof ProjectComponent) {
            ((ProjectComponent)copy).setProject(this.newProject);
        } else {
            try {
                Method setProjectM = c.getMethod("setProject", class$org$apache$tools$ant$Project == null ? (class$org$apache$tools$ant$Project = Ant.class$("org.apache.tools.ant.Project")) : class$org$apache$tools$ant$Project);
                if (setProjectM != null) {
                    setProjectM.invoke(copy, this.newProject);
                }
            }
            catch (NoSuchMethodException e) {
            }
            catch (Exception e2) {
                String msg = "Error setting new project instance for reference with id " + oldKey;
                throw new BuildException(msg, e2, this.getLocation());
            }
        }
        this.newProject.addReference(newKey, copy);
    }

    private void addAlmostAll(Hashtable props) {
        Enumeration e = props.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement().toString();
            if ("basedir".equals(key) || "ant.file".equals(key)) continue;
            String value = props.get(key).toString();
            if (this.newProject.getProperty(key) != null) continue;
            this.newProject.setNewProperty(key, value);
        }
    }

    public void setDir(File d) {
        this.dir = d;
    }

    public void setAntfile(String s) {
        this.antFile = s;
    }

    public void setTarget(String s) {
        if (s.equals("")) {
            throw new BuildException("target attribute must not be empty");
        }
        this.target = s;
    }

    public void setOutput(String s) {
        this.output = s;
    }

    public Property createProperty() {
        if (this.newProject == null) {
            this.reinit();
        }
        Property p = new Property(true, this.getProject());
        p.setProject(this.newProject);
        p.setTaskName("property");
        this.properties.addElement(p);
        return p;
    }

    public void addReference(Reference r) {
        this.references.addElement(r);
    }

    public void addPropertyset(PropertySet ps) {
        this.propertySets.addElement(ps);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Reference
    extends org.apache.tools.ant.types.Reference {
        private String targetid = null;

        public void setToRefid(String targetid) {
            this.targetid = targetid;
        }

        public String getToRefid() {
            return this.targetid;
        }
    }
}

