/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.util.FileUtils;

public class BuildNumber
extends Task {
    private static final String DEFAULT_PROPERTY_NAME = "build.number";
    private static final String DEFAULT_FILENAME = "build.number";
    private File m_file;

    public void setFile(File file) {
        this.m_file = file;
    }

    /*
     * Loose catch block
     */
    public void execute() throws BuildException {
        int buildNumber;
        File savedFile;
        block8: {
            savedFile = this.m_file;
            this.validate();
            Properties properties = this.loadProperties();
            buildNumber = this.getBuildNumber(properties);
            ((Hashtable)properties).put("build.number", String.valueOf(buildNumber + 1));
            FileOutputStream output = null;
            output = new FileOutputStream(this.m_file);
            String header = "Build Number for ANT. Do not edit!";
            properties.save(output, "Build Number for ANT. Do not edit!");
            Object var8_7 = null;
            if (null == output) break block8;
            try {
                output.close();
                break block8;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            {
                break block8;
                catch (IOException ioe) {
                    String message = "Error while writing " + this.m_file;
                    throw new BuildException(message, ioe);
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (null != output) {
                    try {
                        output.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                this.m_file = savedFile;
                throw throwable;
            }
        }
        this.m_file = savedFile;
        this.getProject().setNewProperty("build.number", String.valueOf(buildNumber));
    }

    private int getBuildNumber(Properties properties) throws BuildException {
        String buildNumber = properties.getProperty("build.number", "0").trim();
        try {
            return Integer.parseInt(buildNumber);
        }
        catch (NumberFormatException nfe) {
            String message = this.m_file + " contains a non integer build number: " + buildNumber;
            throw new BuildException(message, nfe);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties loadProperties() throws BuildException {
        FileInputStream input = null;
        try {
            try {
                Properties properties = new Properties();
                input = new FileInputStream(this.m_file);
                properties.load(input);
                Properties properties2 = properties;
                Object var5_5 = null;
                if (null == input) return properties2;
                try {
                    input.close();
                    return properties2;
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                return properties2;
            }
            catch (IOException ioe) {
                throw new BuildException(ioe);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (null == input) throw throwable;
            try {}
            catch (IOException ioe) {
                throw throwable;
            }
            input.close();
            throw throwable;
        }
    }

    private void validate() throws BuildException {
        if (null == this.m_file) {
            this.m_file = this.getProject().resolveFile("build.number");
        }
        if (!this.m_file.exists()) {
            try {
                FileUtils.newFileUtils().createNewFile(this.m_file);
            }
            catch (IOException ioe) {
                String message = this.m_file + " doesn't exist and new file can't be created.";
                throw new BuildException(message, ioe);
            }
        }
        if (!this.m_file.canRead()) {
            String message = "Unable to read from " + this.m_file + ".";
            throw new BuildException(message);
        }
        if (!this.m_file.canWrite()) {
            String message = "Unable to write to " + this.m_file + ".";
            throw new BuildException(message);
        }
    }
}

