/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.ClasspathUtils;

public abstract class Definer
extends Task {
    private String name;
    private String value;
    private File file;
    private String resource;
    private ClasspathUtils.Delegate cpDelegate;

    public void setReverseLoader(boolean reverseLoader) {
        this.cpDelegate.setReverseLoader(reverseLoader);
        this.log("The reverseloader attribute is DEPRECATED. It will be removed", 1);
    }

    public String getName() {
        return this.name;
    }

    public Path getClasspath() {
        return this.cpDelegate.getClasspath();
    }

    public File getFile() {
        return this.file;
    }

    public String getResource() {
        return this.resource;
    }

    public boolean isReverseLoader() {
        return this.cpDelegate.isReverseLoader();
    }

    public String getLoaderId() {
        return this.cpDelegate.getClassLoadId();
    }

    public String getClasspathId() {
        return this.cpDelegate.getClassLoadId();
    }

    public void setClasspath(Path classpath) {
        this.cpDelegate.setClasspath(classpath);
    }

    public Path createClasspath() {
        return this.cpDelegate.createClasspath();
    }

    public void setClasspathRef(Reference r) {
        this.cpDelegate.setClasspathref(r);
    }

    public void setLoaderRef(Reference r) {
        this.cpDelegate.setLoaderRef(r);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        ClassLoader al = this.createLoader();
        if (this.file == null && this.resource == null) {
            if (this.name != null && this.value != null) {
                this.addDefinition(al, this.name, this.value);
                return;
            }
            String msg = "name or classname attributes of " + this.getTaskName() + " element " + "are undefined";
            throw new BuildException(msg);
        }
        InputStream is = null;
        try {
            try {
                if (this.name != null || this.value != null) {
                    String msg = "You must not specify name or value together with file or resource.";
                    throw new BuildException(msg, this.getLocation());
                }
                if (this.file != null && this.resource != null) {
                    String msg = "You must not specify both, file and resource.";
                    throw new BuildException(msg, this.getLocation());
                }
                Properties props = new Properties();
                if (this.file != null) {
                    this.log("Loading definitions from file " + this.file, 3);
                    is = new FileInputStream(this.file);
                    if (is == null) {
                        this.log("Could not load definitions from file " + this.file + ". It doesn't exist.", 1);
                    }
                }
                if (this.resource != null) {
                    this.log("Loading definitions from resource " + this.resource, 3);
                    is = al.getResourceAsStream(this.resource);
                    if (is == null) {
                        this.log("Could not load definitions from resource " + this.resource + ". It could not be found.", 1);
                    }
                }
                if (is != null) {
                    props.load(is);
                    Enumeration keys = ((Hashtable)props).keys();
                    while (keys.hasMoreElements()) {
                        String n = (String)keys.nextElement();
                        String v = props.getProperty(n);
                        this.addDefinition(al, n, v);
                    }
                }
            }
            catch (IOException ex) {
                throw new BuildException(ex, this.getLocation());
            }
            Object var8_11 = null;
            if (is == null) return;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        is.close();
        return;
    }

    private void addDefinition(ClassLoader al, String name, String value) throws BuildException {
        try {
            Class<?> c = al.loadClass(value);
            AntClassLoader.initializeClass(c);
            this.addDefinition(name, c);
        }
        catch (ClassNotFoundException cnfe) {
            String msg = this.getTaskName() + " class " + value + " cannot be found";
            throw new BuildException(msg, cnfe, this.getLocation());
        }
        catch (NoClassDefFoundError ncdfe) {
            String msg = this.getTaskName() + "A class needed on loading by class " + value + " cannot be found: " + ncdfe.getMessage();
            throw new BuildException(msg, ncdfe, this.location);
        }
    }

    private ClassLoader createLoader() {
        ClassLoader al = this.cpDelegate.getClassLoader();
        ((AntClassLoader)al).addSystemPackageRoot("org.apache.tools.ant");
        return al;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setResource(String res) {
        this.resource = res;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getClassname() {
        return this.value;
    }

    public void setClassname(String v) {
        this.value = v;
    }

    protected abstract void addDefinition(String var1, Class var2);

    public void init() throws BuildException {
        this.cpDelegate = ClasspathUtils.getDelegate(this);
        super.init();
    }
}

