/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.ExecuteWatchdog;
import org.apache.tools.ant.taskdefs.Redirector;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.util.FileUtils;

public class ExecTask
extends Task {
    private String os;
    private File dir;
    protected boolean failOnError = false;
    protected boolean newEnvironment = false;
    private Long timeout = null;
    private Environment env = new Environment();
    protected Commandline cmdl = new Commandline();
    private String resultProperty;
    private boolean failIfExecFails = true;
    private String executable;
    private boolean resolveExecutable = false;
    private Redirector redirector = new Redirector(this);
    private boolean vmLauncher = true;

    public void setTimeout(Long value) {
        this.timeout = value;
    }

    public void setTimeout(Integer value) {
        if (value == null) {
            this.timeout = null;
        } else {
            this.setTimeout(new Long(value.intValue()));
        }
    }

    public void setExecutable(String value) {
        this.executable = value;
        this.cmdl.setExecutable(value);
    }

    public void setDir(File d) {
        this.dir = d;
    }

    public void setOs(String os) {
        this.os = os;
    }

    public void setCommand(Commandline cmdl) {
        this.log("The command attribute is deprecated. Please use the executable attribute and nested arg elements.", 1);
        this.cmdl = cmdl;
    }

    public void setOutput(File out) {
        this.redirector.setOutput(out);
    }

    public void setInput(File input) {
        this.redirector.setInput(input);
    }

    public void setInputString(String inputString) {
        this.redirector.setInputString(inputString);
    }

    public void setLogError(boolean logError) {
        this.redirector.setLogError(logError);
    }

    public void setError(File error) {
        this.redirector.setError(error);
    }

    public void setOutputproperty(String outputProp) {
        this.redirector.setOutputProperty(outputProp);
    }

    public void setErrorProperty(String errorProperty) {
        this.redirector.setErrorProperty(errorProperty);
    }

    public void setFailonerror(boolean fail) {
        this.failOnError = fail;
    }

    public void setNewenvironment(boolean newenv) {
        this.newEnvironment = newenv;
    }

    public void setResolveExecutable(boolean resolveExecutable) {
        this.resolveExecutable = resolveExecutable;
    }

    public void addEnv(Environment.Variable var) {
        this.env.addVariable(var);
    }

    public Commandline.Argument createArg() {
        return this.cmdl.createArgument();
    }

    public void setResultProperty(String resultProperty) {
        this.resultProperty = resultProperty;
    }

    protected void maybeSetResultPropertyValue(int result) {
        String res = Integer.toString(result);
        if (this.resultProperty != null) {
            this.getProject().setNewProperty(this.resultProperty, res);
        }
    }

    public void setFailIfExecutionFails(boolean flag) {
        this.failIfExecFails = flag;
    }

    public void setAppend(boolean append) {
        this.redirector.setAppend(append);
    }

    private String resolveExecutable() {
        FileUtils fileUtils;
        if (!this.resolveExecutable) {
            return this.executable;
        }
        File executableFile = this.getProject().resolveFile(this.executable);
        if (executableFile.exists()) {
            return executableFile.getAbsolutePath();
        }
        if (this.dir != null && (executableFile = (fileUtils = FileUtils.newFileUtils()).resolveFile(this.dir, this.executable)).exists()) {
            return executableFile.getAbsolutePath();
        }
        return this.executable;
    }

    public void execute() throws BuildException {
        File savedDir = this.dir;
        this.cmdl.setExecutable(this.resolveExecutable());
        this.checkConfiguration();
        if (this.isValidOs()) {
            try {
                this.runExec(this.prepareExec());
                Object var3_2 = null;
                this.dir = savedDir;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.dir = savedDir;
                throw throwable;
            }
        }
    }

    protected void checkConfiguration() throws BuildException {
        if (this.cmdl.getExecutable() == null) {
            throw new BuildException("no executable specified", this.getLocation());
        }
        if (this.dir != null && !this.dir.exists()) {
            throw new BuildException("The directory you specified does not exist");
        }
        if (this.dir != null && !this.dir.isDirectory()) {
            throw new BuildException("The directory you specified is not a directory");
        }
    }

    protected boolean isValidOs() {
        String myos = System.getProperty("os.name");
        this.log("Current OS is " + myos, 3);
        if (this.os != null && this.os.indexOf(myos) < 0) {
            this.log("This OS, " + myos + " was not found in the specified list of valid OSes: " + this.os, 3);
            return false;
        }
        return true;
    }

    public void setVMLauncher(boolean vmLauncher) {
        this.vmLauncher = vmLauncher;
    }

    protected Execute prepareExec() throws BuildException {
        if (this.dir == null) {
            this.dir = this.getProject().getBaseDir();
        }
        Execute exe = new Execute(this.createHandler(), this.createWatchdog());
        exe.setAntRun(this.getProject());
        exe.setWorkingDirectory(this.dir);
        exe.setVMLauncher(this.vmLauncher);
        String[] environment = this.env.getVariables();
        if (environment != null) {
            int i = 0;
            while (i < environment.length) {
                this.log("Setting environment variable: " + environment[i], 3);
                ++i;
            }
        }
        exe.setNewenvironment(this.newEnvironment);
        exe.setEnvironment(environment);
        return exe;
    }

    protected final void runExecute(Execute exe) throws IOException {
        int returnCode = -1;
        returnCode = exe.execute();
        if (exe.killedProcess()) {
            this.log("Timeout: killed the sub-process", 1);
        }
        this.maybeSetResultPropertyValue(returnCode);
        if (returnCode != 0) {
            if (this.failOnError) {
                throw new BuildException(this.getTaskType() + " returned: " + returnCode, this.getLocation());
            }
            this.log("Result: " + returnCode, 0);
        }
        this.redirector.complete();
    }

    protected void runExec(Execute exe) throws BuildException {
        this.log(this.cmdl.describeCommand(), 3);
        exe.setCommandline(this.cmdl.getCommandline());
        try {
            try {
                this.runExecute(exe);
            }
            catch (IOException e) {
                if (this.failIfExecFails) {
                    throw new BuildException("Execute failed: " + e.toString(), e, this.getLocation());
                }
                this.log("Execute failed: " + e.toString(), 0);
                Object var4_3 = null;
                this.logFlush();
            }
            Object var4_2 = null;
            this.logFlush();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.logFlush();
            throw throwable;
        }
    }

    protected ExecuteStreamHandler createHandler() throws BuildException {
        return this.redirector.createHandler();
    }

    protected ExecuteWatchdog createWatchdog() throws BuildException {
        if (this.timeout == null) {
            return null;
        }
        return new ExecuteWatchdog(this.timeout);
    }

    protected void logFlush() {
    }
}

