/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Task;

public class ImportTask
extends Task {
    String file;

    public void setFile(String file) {
        this.file = file;
    }

    public void execute() throws BuildException {
        if (this.file == null) {
            throw new BuildException("import requires file attribute");
        }
        ProjectHelper helper = (ProjectHelper)this.getProject().getReference("ant.projectHelper");
        Vector importStack = helper.getImportStack();
        if (importStack.size() == 0) {
            throw new BuildException("import requires support in ProjectHelper");
        }
        Object currentSource = importStack.elementAt(importStack.size() - 1);
        File buildFile = (File)currentSource;
        buildFile = new File(buildFile.getAbsolutePath());
        File buildFileParent = new File(buildFile.getParent());
        this.getProject().log("Importing file " + this.file + " from " + buildFile.getAbsolutePath(), 3);
        File importedFile = new File(this.file);
        if (!importedFile.isAbsolute()) {
            importedFile = new File(buildFileParent, this.file);
        }
        if (!importedFile.exists()) {
            throw new BuildException("Cannot find " + this.file + " imported from " + buildFile.getAbsolutePath());
        }
        if (importStack.contains(importedFile)) {
            this.getProject().log("\nSkipped already imported file to avoid loop:\n   " + importedFile + "\n", 1);
            return;
        }
        helper.parse(this.getProject(), importedFile);
    }

    private static String getPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return file.getAbsolutePath();
        }
    }
}

