/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FilterSet;
import org.apache.tools.ant.types.FilterSetCollection;

public class Move
extends Copy {
    public Move() {
        this.forceOverwrite = true;
    }

    protected void doFileOperations() {
        Enumeration e;
        if (this.completeDirMap.size() > 0) {
            e = this.completeDirMap.keys();
            while (e.hasMoreElements()) {
                File fromDir = (File)e.nextElement();
                File toDir = (File)this.completeDirMap.get(fromDir);
                try {
                    this.log("Attempting to rename dir: " + fromDir + " to " + toDir, this.verbosity);
                    this.renameFile(fromDir, toDir, this.filtering, this.forceOverwrite);
                }
                catch (IOException ioe) {
                    String msg = "Failed to rename dir " + fromDir + " to " + toDir + " due to " + ioe.getMessage();
                    throw new BuildException(msg, ioe, this.getLocation());
                }
            }
        }
        if (this.fileCopyMap.size() > 0) {
            this.log("Moving " + this.fileCopyMap.size() + " files to " + this.destDir.getAbsolutePath());
            e = this.fileCopyMap.keys();
            while (e.hasMoreElements()) {
                String msg;
                String toFile;
                String fromFile = (String)e.nextElement();
                if (fromFile.equals(toFile = (String)this.fileCopyMap.get(fromFile))) {
                    this.log("Skipping self-move of " + fromFile, this.verbosity);
                    continue;
                }
                boolean moved = false;
                File f = new File(fromFile);
                if (!f.exists()) continue;
                File d = new File(toFile);
                try {
                    this.log("Attempting to rename: " + fromFile + " to " + toFile, this.verbosity);
                    moved = this.renameFile(f, d, this.filtering, this.forceOverwrite);
                }
                catch (IOException ioe) {
                    msg = "Failed to rename " + fromFile + " to " + toFile + " due to " + ioe.getMessage();
                    throw new BuildException(msg, ioe, this.getLocation());
                }
                if (moved) continue;
                try {
                    this.log("Moving " + fromFile + " to " + toFile, this.verbosity);
                    FilterSetCollection executionFilters = new FilterSetCollection();
                    if (this.filtering) {
                        executionFilters.addFilterSet(this.getProject().getGlobalFilterSet());
                    }
                    Enumeration filterEnum = this.getFilterSets().elements();
                    while (filterEnum.hasMoreElements()) {
                        executionFilters.addFilterSet((FilterSet)filterEnum.nextElement());
                    }
                    this.getFileUtils().copyFile(f, d, executionFilters, this.getFilterChains(), this.forceOverwrite, this.getPreserveLastModified(), this.getEncoding(), this.getOutputEncoding(), this.getProject());
                    f = new File(fromFile);
                    if (f.delete()) continue;
                    throw new BuildException("Unable to delete file " + f.getAbsolutePath());
                }
                catch (IOException ioe) {
                    msg = "Failed to copy " + fromFile + " to " + toFile + " due to " + ioe.getMessage();
                    throw new BuildException(msg, ioe, this.getLocation());
                }
            }
        }
        if (this.includeEmpty) {
            e = this.dirCopyMap.keys();
            int count = 0;
            while (e.hasMoreElements()) {
                String fromDirName = (String)e.nextElement();
                String toDirName = (String)this.dirCopyMap.get(fromDirName);
                File fromDir = new File(fromDirName);
                File toDir = new File(toDirName);
                if (!toDir.exists()) {
                    if (!toDir.mkdirs()) {
                        this.log("Unable to create directory " + toDirName, 0);
                    } else {
                        ++count;
                    }
                }
                if (!this.okToDelete(fromDir)) continue;
                this.deleteDir(fromDir);
            }
            if (count > 0) {
                this.log("Moved " + count + " empty directories to " + this.destDir.getAbsolutePath());
            }
        }
    }

    protected boolean okToDelete(File d) {
        String[] list = d.list();
        if (list == null) {
            return false;
        }
        int i = 0;
        while (i < list.length) {
            String s = list[i];
            File f = new File(d, s);
            if (f.isDirectory()) {
                if (!this.okToDelete(f)) {
                    return false;
                }
            } else {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void deleteDir(File d) {
        String[] list = d.list();
        if (list == null) {
            return;
        }
        int i = 0;
        while (i < list.length) {
            String s = list[i];
            File f = new File(d, s);
            if (!f.isDirectory()) {
                throw new BuildException("UNEXPECTED ERROR - The file " + f.getAbsolutePath() + " should not exist!");
            }
            this.deleteDir(f);
            ++i;
        }
        this.log("Deleting directory " + d.getAbsolutePath(), this.verbosity);
        if (!d.delete()) {
            throw new BuildException("Unable to delete directory " + d.getAbsolutePath());
        }
    }

    protected boolean renameFile(File sourceFile, File destFile, boolean filtering, boolean overwrite) throws IOException, BuildException {
        boolean renamed = true;
        if (this.getFilterSets() != null && this.getFilterSets().size() > 0 || this.getFilterChains() != null && this.getFilterChains().size() > 0) {
            renamed = false;
        } else if (!filtering) {
            File parent;
            String parentPath = destFile.getParent();
            if (parentPath != null && !(parent = new File(parentPath)).exists()) {
                parent.mkdirs();
            }
            if (destFile.exists() && destFile.isFile() && !destFile.delete()) {
                throw new BuildException("Unable to remove existing file " + destFile);
            }
            renamed = sourceFile.renameTo(destFile);
        } else {
            renamed = false;
        }
        return renamed;
    }
}

