/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.util.StringUtils;

public class Parallel
extends Task
implements TaskContainer {
    private Vector nestedTasks = new Vector();
    private final Object semaphore = new Object();
    private int numThreads = 0;
    private int numThreadsPerProcessor = 0;
    private int pollInterval = 1000;
    static /* synthetic */ Class class$java$lang$Runtime;

    public void addTask(Task nestedTask) {
        this.nestedTasks.addElement(nestedTask);
    }

    public void setThreadsPerProcessor(int numThreadsPerProcessor) {
        this.numThreadsPerProcessor = numThreadsPerProcessor;
    }

    public void setThreadCount(int numThreads) {
        this.numThreads = numThreads;
    }

    public void setPollInterval(int pollInterval) {
        this.pollInterval = pollInterval;
    }

    public void execute() throws BuildException {
        this.updateThreadCounts();
        if (this.numThreads == 0) {
            this.numThreads = this.nestedTasks.size();
        }
        this.spinThreads();
    }

    private void updateThreadCounts() {
        int numProcessors;
        if (this.numThreadsPerProcessor != 0 && (numProcessors = this.getNumProcessors()) != 0) {
            this.numThreads = numProcessors * this.numThreadsPerProcessor;
        }
    }

    private void spinThreads() throws BuildException {
        Object taskRunnable;
        int numTasks = this.nestedTasks.size();
        Thread[] threads = new Thread[numTasks];
        TaskRunnable[] runnables = new TaskRunnable[numTasks];
        int threadNumber = 0;
        Enumeration e = this.nestedTasks.elements();
        while (e.hasMoreElements()) {
            Task nestedTask = (Task)e.nextElement();
            ThreadGroup group = new ThreadGroup("parallel");
            runnables[threadNumber] = taskRunnable = new TaskRunnable(threadNumber, nestedTask);
            threads[threadNumber] = new Thread(group, (Runnable)taskRunnable);
            ++threadNumber;
        }
        int maxRunning = this.numThreads;
        Thread[] running = new Thread[maxRunning];
        threadNumber = 0;
        block8: while (threadNumber < numTasks) {
            taskRunnable = this.semaphore;
            synchronized (taskRunnable) {
                int i = 0;
                while (i < maxRunning) {
                    if (running[i] == null || !running[i].isAlive()) {
                        running[i] = threads[threadNumber++];
                        running[i].start();
                        continue block8;
                    }
                    ++i;
                }
                try {
                    this.semaphore.wait(this.pollInterval);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
        }
        int i = 0;
        while (i < maxRunning) {
            try {
                if (running[i] != null) {
                    running[i].join();
                }
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            ++i;
        }
        StringBuffer exceptionMessage = new StringBuffer();
        int numExceptions = 0;
        Throwable firstException = null;
        Location firstLocation = Location.UNKNOWN_LOCATION;
        int i2 = 0;
        while (i2 < numTasks) {
            Throwable t = runnables[i2].getException();
            if (t != null) {
                ++numExceptions;
                if (firstException == null) {
                    firstException = t;
                }
                if (t instanceof BuildException && firstLocation == Location.UNKNOWN_LOCATION) {
                    firstLocation = ((BuildException)t).getLocation();
                }
                exceptionMessage.append(StringUtils.LINE_SEP);
                exceptionMessage.append(t.getMessage());
            }
            ++i2;
        }
        if (numExceptions == 1) {
            if (firstException instanceof BuildException) {
                throw (BuildException)firstException;
            }
            throw new BuildException(firstException);
        }
        if (numExceptions > 1) {
            throw new BuildException(exceptionMessage.toString(), firstLocation);
        }
    }

    private int getNumProcessors() {
        try {
            Class[] paramTypes = new Class[]{};
            Method availableProcessors = (class$java$lang$Runtime == null ? (class$java$lang$Runtime = Parallel.class$("java.lang.Runtime")) : class$java$lang$Runtime).getMethod("availableProcessors", paramTypes);
            Object[] args = new Object[]{};
            Integer ret = (Integer)availableProcessors.invoke((Object)Runtime.getRuntime(), args);
            return ret;
        }
        catch (Exception e) {
            return 0;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class TaskRunnable
    implements Runnable {
        private Throwable exception;
        private Task task;
        private int taskNumber;

        TaskRunnable(int taskNumber, Task task) {
            this.task = task;
            this.taskNumber = taskNumber;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    this.task.perform();
                }
                catch (Throwable t) {
                    this.exception = t;
                    Object var3_2 = null;
                    Object object2 = Parallel.this.semaphore;
                    synchronized (object2) {
                        Parallel.this.semaphore.notifyAll();
                        return;
                    }
                }
                Object var3_1 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                Object object = Parallel.this.semaphore;
                synchronized (object) {
                    Parallel.this.semaphore.notifyAll();
                    throw throwable;
                }
            }
            Object object = Parallel.this.semaphore;
            synchronized (object) {
                Parallel.this.semaphore.notifyAll();
                return;
            }
        }

        public Throwable getException() {
            return this.exception;
        }
    }
}

