/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class Property
extends Task {
    protected String name;
    protected String value;
    protected File file;
    protected String resource;
    protected Path classpath;
    protected String env;
    protected Reference ref;
    protected String prefix;
    private Project fallback;
    protected boolean userProperty;

    public Property() {
        this(false);
    }

    protected Property(boolean userProperty) {
        this(userProperty, null);
    }

    protected Property(boolean userProperty, Project fallback) {
        this.userProperty = userProperty;
        this.fallback = fallback;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setLocation(File location) {
        this.setValue(location.getAbsolutePath());
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
        if (!prefix.endsWith(".")) {
            this.prefix = this.prefix + ".";
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setRefid(Reference ref) {
        this.ref = ref;
    }

    public Reference getRefid() {
        return this.ref;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public String getResource() {
        return this.resource;
    }

    public void setEnvironment(String env) {
        this.env = env;
    }

    public String getEnvironment() {
        return this.env;
    }

    public void setClasspath(Path classpath) {
        if (this.classpath == null) {
            this.classpath = classpath;
        } else {
            this.classpath.append(classpath);
        }
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public Path getClasspath() {
        return this.classpath;
    }

    public void setUserProperty(boolean userProperty) {
        this.log("DEPRECATED: Ignoring request to set user property in Property task.", 1);
    }

    public String toString() {
        return this.value == null ? "" : this.value;
    }

    public void execute() throws BuildException {
        if (this.getProject() == null) {
            throw new IllegalStateException("project has not been set");
        }
        if (this.name != null) {
            if (this.value == null && this.ref == null) {
                throw new BuildException("You must specify value, location or refid with the name attribute", this.getLocation());
            }
        } else if (this.file == null && this.resource == null && this.env == null) {
            throw new BuildException("You must specify file, resource or environment when not using the name attribute", this.getLocation());
        }
        if (this.file == null && this.resource == null && this.prefix != null) {
            throw new BuildException("Prefix is only valid when loading from a file or resource", this.getLocation());
        }
        if (this.name != null && this.value != null) {
            this.addProperty(this.name, this.value);
        }
        if (this.file != null) {
            this.loadFile(this.file);
        }
        if (this.resource != null) {
            this.loadResource(this.resource);
        }
        if (this.env != null) {
            this.loadEnvironment(this.env);
        }
        if (this.name != null && this.ref != null) {
            try {
                this.addProperty(this.name, this.ref.getReferencedObject(this.getProject()).toString());
            }
            catch (BuildException be) {
                if (this.fallback != null) {
                    this.addProperty(this.name, this.ref.getReferencedObject(this.fallback).toString());
                }
                throw be;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadFile(File file) throws BuildException {
        Properties props = new Properties();
        this.log("Loading " + file.getAbsolutePath(), 3);
        try {
            block5: {
                if (!file.exists()) {
                    this.log("Unable to find property file: " + file.getAbsolutePath(), 3);
                    return;
                }
                FileInputStream fis = new FileInputStream(file);
                try {
                    props.load(fis);
                    Object var5_5 = null;
                    if (fis == null) break block5;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    if (fis == null) throw throwable;
                    fis.close();
                    throw throwable;
                }
                fis.close();
            }
            this.addProperties(props);
            return;
        }
        catch (IOException ex) {
            throw new BuildException(ex, this.getLocation());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadResource(String name) {
        Properties props = new Properties();
        this.log("Resource Loading " + name, 3);
        InputStream is = null;
        try {
            try {
                ClassLoader cL = null;
                cL = this.classpath != null ? this.getProject().createClassLoader(this.classpath) : this.getClass().getClassLoader();
                is = cL == null ? ClassLoader.getSystemResourceAsStream(name) : cL.getResourceAsStream(name);
                if (is != null) {
                    props.load(is);
                    this.addProperties(props);
                } else {
                    this.log("Unable to find resource " + name, 1);
                }
            }
            catch (IOException ex) {
                throw new BuildException(ex, this.getLocation());
            }
            Object var6_6 = null;
            if (is == null) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        is.close();
        return;
    }

    protected void loadEnvironment(String prefix) {
        Properties props = new Properties();
        if (!prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        this.log("Loading Environment " + prefix, 3);
        Vector osEnv = Execute.getProcEnvironment();
        Enumeration e = osEnv.elements();
        while (e.hasMoreElements()) {
            String entry = (String)e.nextElement();
            int pos = entry.indexOf(61);
            if (pos == -1) {
                this.log("Ignoring: " + entry, 1);
                continue;
            }
            ((Hashtable)props).put(prefix + entry.substring(0, pos), entry.substring(pos + 1));
        }
        this.addProperties(props);
    }

    protected void addProperties(Properties props) {
        this.resolveAllProperties(props);
        Enumeration e = ((Hashtable)props).keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = props.getProperty(name);
            String v = this.getProject().replaceProperties(value);
            if (this.prefix != null) {
                name = this.prefix + name;
            }
            this.addProperty(name, v);
        }
    }

    protected void addProperty(String n, String v) {
        if (this.userProperty) {
            if (this.getProject().getUserProperty(n) == null) {
                this.getProject().setInheritedProperty(n, v);
            } else {
                this.log("Override ignored for " + n, 3);
            }
        } else {
            this.getProject().setNewProperty(n, v);
        }
    }

    private void resolveAllProperties(Properties props) throws BuildException {
        Enumeration e = ((Hashtable)props).keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = props.getProperty(name);
            boolean resolved = false;
            while (!resolved) {
                Vector fragments = new Vector();
                Vector propertyRefs = new Vector();
                ProjectHelper.parsePropertyString(value, fragments, propertyRefs);
                resolved = true;
                if (propertyRefs.size() == 0) continue;
                StringBuffer sb = new StringBuffer();
                Enumeration i = fragments.elements();
                Enumeration j = propertyRefs.elements();
                while (i.hasMoreElements()) {
                    String fragment = (String)i.nextElement();
                    if (fragment == null) {
                        String propertyName = (String)j.nextElement();
                        if (propertyName.equals(name)) {
                            throw new BuildException("Property " + name + " was circularly " + "defined.");
                        }
                        fragment = this.getProject().getProperty(propertyName);
                        if (fragment == null) {
                            if (((Hashtable)props).containsKey(propertyName)) {
                                fragment = props.getProperty(propertyName);
                                resolved = false;
                            } else {
                                fragment = "${" + propertyName + "}";
                            }
                        }
                    }
                    sb.append(fragment);
                }
                value = sb.toString();
                ((Hashtable)props).put(name, value);
            }
        }
    }
}

