/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.util.Hashtable;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.condition.Condition;
import org.apache.tools.ant.taskdefs.condition.ConditionBase;
import org.apache.tools.ant.types.EnumeratedAttribute;

public class WaitFor
extends ConditionBase {
    private long maxWaitMillis = 180000L;
    private long maxWaitMultiplier = 1L;
    private long checkEveryMillis = 500L;
    private long checkEveryMultiplier = 1L;
    private String timeoutProperty;

    public void setMaxWait(long time) {
        this.maxWaitMillis = time;
    }

    public void setMaxWaitUnit(Unit unit) {
        this.maxWaitMultiplier = unit.getMultiplier();
    }

    public void setCheckEvery(long time) {
        this.checkEveryMillis = time;
    }

    public void setCheckEveryUnit(Unit unit) {
        this.checkEveryMultiplier = unit.getMultiplier();
    }

    public void setTimeoutProperty(String p) {
        this.timeoutProperty = p;
    }

    public void execute() throws BuildException {
        if (this.countConditions() > 1) {
            throw new BuildException("You must not nest more than one condition into <waitfor>");
        }
        if (this.countConditions() < 1) {
            throw new BuildException("You must nest a condition into <waitfor>");
        }
        Condition c = (Condition)this.getConditions().nextElement();
        long savedMaxWaitMillis = this.maxWaitMillis;
        long savedCheckEveryMillis = this.checkEveryMillis;
        try {
            this.maxWaitMillis *= this.maxWaitMultiplier;
            this.checkEveryMillis *= this.checkEveryMultiplier;
            long start = System.currentTimeMillis();
            long end = start + this.maxWaitMillis;
            while (System.currentTimeMillis() < end) {
                if (c.eval()) {
                    Object var12_7 = null;
                    this.maxWaitMillis = savedMaxWaitMillis;
                    this.checkEveryMillis = savedCheckEveryMillis;
                    return;
                }
                try {
                    Thread.sleep(this.checkEveryMillis);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if (this.timeoutProperty != null) {
                this.getProject().setNewProperty(this.timeoutProperty, "true");
            }
        }
        catch (Throwable throwable) {
            Object var12_9 = null;
            this.maxWaitMillis = savedMaxWaitMillis;
            this.checkEveryMillis = savedCheckEveryMillis;
            throw throwable;
        }
        Object var12_8 = null;
        this.maxWaitMillis = savedMaxWaitMillis;
        this.checkEveryMillis = savedCheckEveryMillis;
    }

    public static class Unit
    extends EnumeratedAttribute {
        private static final String MILLISECOND = "millisecond";
        private static final String SECOND = "second";
        private static final String MINUTE = "minute";
        private static final String HOUR = "hour";
        private static final String DAY = "day";
        private static final String WEEK = "week";
        private static final String[] units = new String[]{"millisecond", "second", "minute", "hour", "day", "week"};
        private Hashtable timeTable = new Hashtable();

        public Unit() {
            this.timeTable.put(MILLISECOND, new Long(1L));
            this.timeTable.put(SECOND, new Long(1000L));
            this.timeTable.put(MINUTE, new Long(60000L));
            this.timeTable.put(HOUR, new Long(3600000L));
            this.timeTable.put(DAY, new Long(86400000L));
            this.timeTable.put(WEEK, new Long(604800000L));
        }

        public long getMultiplier() {
            String key = this.getValue().toLowerCase();
            Long l = (Long)this.timeTable.get(key);
            return l;
        }

        public String[] getValues() {
            return units;
        }
    }
}

