/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlProperty
extends Task {
    private File src;
    private String prefix = "";
    private boolean keepRoot = true;
    private boolean validate = false;
    private boolean collapseAttributes = false;
    private boolean semanticAttributes = false;
    private boolean includeSemanticAttribute = false;
    private File rootDirectory = null;
    private FileUtils fileUtils = FileUtils.newFileUtils();
    private Hashtable addedAttributes = new Hashtable();
    private static final String ID = "id";
    private static final String REF_ID = "refid";
    private static final String LOCATION = "location";
    private static final String VALUE = "value";
    private static final String PATH = "path";
    private static final String PATHID = "pathid";
    private static final String[] ATTRIBUTES = new String[]{"id", "refid", "location", "value", "path", "pathid"};

    public void init() {
        super.init();
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws BuildException {
        BufferedInputStream configurationStream;
        block14: {
            if (this.getFile() == null) {
                String msg = "XmlProperty task requires a file attribute";
                throw new BuildException(msg);
            }
            configurationStream = null;
            this.log("Loading " + this.src.getAbsolutePath(), 3);
            if (this.src.exists()) {
                configurationStream = new BufferedInputStream(new FileInputStream(this.src));
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setValidating(this.validate);
                factory.setNamespaceAware(false);
                Element element = factory.newDocumentBuilder().parse(configurationStream).getDocumentElement();
                this.addedAttributes = new Hashtable();
                if (this.keepRoot) {
                    this.addNodeRecursively(element, this.prefix, null);
                } else {
                    NodeList topChildren = element.getChildNodes();
                    int numChildren = topChildren.getLength();
                    int i = 0;
                    while (i < numChildren) {
                        this.addNodeRecursively(topChildren.item(i), this.prefix, null);
                        ++i;
                    }
                }
                break block14;
            }
            this.log("Unable to find property file: " + this.src.getAbsolutePath(), 3);
        }
        Object var8_14 = null;
        if (configurationStream == null) return;
        try {
            configurationStream.close();
            return;
        }
        catch (Exception e) {}
        return;
        {
            catch (SAXException sxe) {
                void var3_8;
                SAXException sAXException = sxe;
                if (sxe.getException() == null) throw new BuildException((Throwable)var3_8);
                Exception exception = sxe.getException();
                throw new BuildException((Throwable)var3_8);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new BuildException(parserConfigurationException);
            }
            catch (IOException ioe) {
                throw new BuildException(ioe);
            }
        }
        catch (Throwable throwable) {
            Object var8_15 = null;
            if (configurationStream == null) throw throwable;
            try {
                configurationStream.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private void addNodeRecursively(Node node, String prefix, Object container) {
        String nodePrefix = prefix;
        if (node.getNodeType() != 3) {
            if (prefix.trim().length() > 0) {
                nodePrefix = nodePrefix + ".";
            }
            nodePrefix = nodePrefix + node.getNodeName();
        }
        Object nodeObject = this.processNode(node, nodePrefix, container);
        if (node.hasChildNodes()) {
            NodeList nodeChildren = node.getChildNodes();
            int numChildren = nodeChildren.getLength();
            int i = 0;
            while (i < numChildren) {
                this.addNodeRecursively(nodeChildren.item(i), nodePrefix, nodeObject);
                ++i;
            }
        }
    }

    void addNodeRecursively(Node node, String prefix) {
        this.addNodeRecursively(node, prefix, null);
    }

    public Object processNode(Node node, String prefix, Object container) {
        Object addedPath = null;
        String id = null;
        if (node.hasAttributes()) {
            NamedNodeMap nodeAttributes = node.getAttributes();
            Node idNode = nodeAttributes.getNamedItem(ID);
            id = this.semanticAttributes && idNode != null ? idNode.getNodeValue() : null;
            int i = 0;
            while (i < nodeAttributes.getLength()) {
                String attributeValue;
                Node attributeNode = nodeAttributes.item(i);
                if (!this.semanticAttributes) {
                    String attributeName = this.getAttributeName(attributeNode);
                    attributeValue = this.getAttributeValue(attributeNode);
                    this.addProperty(prefix + attributeName, attributeValue, null);
                } else {
                    Path containingPath;
                    String nodeName = attributeNode.getNodeName();
                    attributeValue = this.getAttributeValue(attributeNode);
                    Path path = containingPath = container != null && container instanceof Path ? (Path)container : null;
                    if (!nodeName.equals(ID)) {
                        if (containingPath != null && nodeName.equals(PATH)) {
                            containingPath.setPath(attributeValue);
                        } else if (container instanceof Path && nodeName.equals(REF_ID)) {
                            containingPath.setPath(attributeValue);
                        } else if (container instanceof Path && nodeName.equals(LOCATION)) {
                            containingPath.setLocation(this.resolveFile(attributeValue));
                        } else if (nodeName.equals(PATHID)) {
                            if (container != null) {
                                throw new BuildException("XmlProperty does not support nested paths");
                            }
                            addedPath = new Path(this.getProject());
                            this.getProject().addReference(attributeValue, addedPath);
                        } else {
                            String attributeName = this.getAttributeName(attributeNode);
                            this.addProperty(prefix + attributeName, attributeValue, id);
                        }
                    }
                }
                ++i;
            }
        }
        if (node.getNodeType() == 3) {
            String nodeText;
            if (this.semanticAttributes && id == null && container instanceof String) {
                id = (String)container;
            }
            if ((nodeText = this.getAttributeValue(node)).trim().length() != 0) {
                this.addProperty(prefix, nodeText, id);
            }
        }
        return addedPath != null ? addedPath : id;
    }

    private void addProperty(String name, String value, String id) {
        String msg = name + ":" + value;
        if (id != null) {
            msg = msg + "(id=" + id + ")";
        }
        this.log(msg, 4);
        if (this.addedAttributes.containsKey(name)) {
            value = (String)this.addedAttributes.get(name) + "," + value;
            this.getProject().setProperty(name, value);
        } else {
            this.getProject().setNewProperty(name, value);
        }
        this.addedAttributes.put(name, value);
        if (id != null) {
            this.getProject().addReference(id, value);
        }
    }

    private String getAttributeName(Node attributeNode) {
        String attributeName = attributeNode.getNodeName();
        if (this.semanticAttributes) {
            if (attributeName.equals(REF_ID)) {
                return "";
            }
            if (!XmlProperty.isSemanticAttribute(attributeName) || this.includeSemanticAttribute) {
                return "." + attributeName;
            }
            return "";
        }
        if (this.collapseAttributes) {
            return "." + attributeName;
        }
        return "(" + attributeName + ")";
    }

    private static boolean isSemanticAttribute(String attributeName) {
        int i = 0;
        while (i < ATTRIBUTES.length) {
            if (attributeName.equals(ATTRIBUTES[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String getAttributeValue(Node attributeNode) {
        String nodeValue = attributeNode.getNodeValue().trim();
        if (this.semanticAttributes) {
            Object ref;
            String attributeName = attributeNode.getNodeName();
            nodeValue = this.getProject().replaceProperties(nodeValue);
            if (attributeName.equals(LOCATION)) {
                File f = this.resolveFile(nodeValue);
                return f.getPath();
            }
            if (attributeName.equals(REF_ID) && (ref = this.getProject().getReference(nodeValue)) != null) {
                return ref.toString();
            }
        }
        return nodeValue;
    }

    public void setFile(File src) {
        this.src = src;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix.trim();
    }

    public void setKeeproot(boolean keepRoot) {
        this.keepRoot = keepRoot;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public void setCollapseAttributes(boolean collapseAttributes) {
        this.collapseAttributes = collapseAttributes;
    }

    public void setSemanticAttributes(boolean semanticAttributes) {
        this.semanticAttributes = semanticAttributes;
    }

    public void setRootDirectory(File rootDirectory) {
        this.rootDirectory = rootDirectory;
    }

    public void setIncludeSemanticAttribute(boolean includeSemanticAttribute) {
        this.includeSemanticAttribute = includeSemanticAttribute;
    }

    protected File getFile() {
        return this.src;
    }

    protected String getPrefix() {
        return this.prefix;
    }

    protected boolean getKeeproot() {
        return this.keepRoot;
    }

    protected boolean getValidate() {
        return this.validate;
    }

    protected boolean getCollapseAttributes() {
        return this.collapseAttributes;
    }

    protected boolean getSemanticAttributes() {
        return this.semanticAttributes;
    }

    protected File getRootDirectory() {
        return this.rootDirectory;
    }

    protected boolean getIncludeSementicAttribute() {
        return this.includeSemanticAttribute;
    }

    private File resolveFile(String fileName) {
        if (this.rootDirectory == null) {
            return this.getProject().resolveFile(fileName);
        }
        return this.fileUtils.resolveFile(this.rootDirectory, fileName);
    }
}

