/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.FileScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.selectors.AndSelector;
import org.apache.tools.ant.types.selectors.ContainsRegexpSelector;
import org.apache.tools.ant.types.selectors.ContainsSelector;
import org.apache.tools.ant.types.selectors.DateSelector;
import org.apache.tools.ant.types.selectors.DependSelector;
import org.apache.tools.ant.types.selectors.DepthSelector;
import org.apache.tools.ant.types.selectors.DifferentSelector;
import org.apache.tools.ant.types.selectors.ExtendSelector;
import org.apache.tools.ant.types.selectors.FileSelector;
import org.apache.tools.ant.types.selectors.FilenameSelector;
import org.apache.tools.ant.types.selectors.MajoritySelector;
import org.apache.tools.ant.types.selectors.NoneSelector;
import org.apache.tools.ant.types.selectors.NotSelector;
import org.apache.tools.ant.types.selectors.OrSelector;
import org.apache.tools.ant.types.selectors.PresentSelector;
import org.apache.tools.ant.types.selectors.SelectSelector;
import org.apache.tools.ant.types.selectors.SelectorContainer;
import org.apache.tools.ant.types.selectors.SelectorScanner;
import org.apache.tools.ant.types.selectors.SizeSelector;
import org.apache.tools.ant.types.selectors.TypeSelector;
import org.apache.tools.ant.util.FileUtils;

public abstract class AbstractFileSet
extends DataType
implements Cloneable,
SelectorContainer {
    private PatternSet defaultPatterns = new PatternSet();
    private Vector additionalPatterns = new Vector();
    private Vector selectors = new Vector();
    private File dir;
    private boolean useDefaultExcludes = true;
    private boolean isCaseSensitive = true;
    private boolean followSymlinks = true;

    public AbstractFileSet() {
    }

    protected AbstractFileSet(AbstractFileSet fileset) {
        this.dir = fileset.dir;
        this.defaultPatterns = fileset.defaultPatterns;
        this.additionalPatterns = fileset.additionalPatterns;
        this.selectors = fileset.selectors;
        this.useDefaultExcludes = fileset.useDefaultExcludes;
        this.isCaseSensitive = fileset.isCaseSensitive;
        this.followSymlinks = fileset.followSymlinks;
        this.setProject(fileset.getProject());
    }

    public void setRefid(Reference r) throws BuildException {
        if (this.dir != null || this.defaultPatterns.hasPatterns(this.getProject())) {
            throw this.tooManyAttributes();
        }
        if (!this.additionalPatterns.isEmpty()) {
            throw this.noChildrenAllowed();
        }
        if (!this.selectors.isEmpty()) {
            throw this.noChildrenAllowed();
        }
        super.setRefid(r);
    }

    public void setDir(File dir) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.dir = dir;
    }

    public File getDir(Project p) {
        if (this.isReference()) {
            return this.getRef(p).getDir(p);
        }
        return this.dir;
    }

    public PatternSet createPatternSet() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        PatternSet patterns = new PatternSet();
        this.additionalPatterns.addElement(patterns);
        return patterns;
    }

    public PatternSet.NameEntry createInclude() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        return this.defaultPatterns.createInclude();
    }

    public PatternSet.NameEntry createIncludesFile() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        return this.defaultPatterns.createIncludesFile();
    }

    public PatternSet.NameEntry createExclude() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        return this.defaultPatterns.createExclude();
    }

    public PatternSet.NameEntry createExcludesFile() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        return this.defaultPatterns.createExcludesFile();
    }

    public void setFile(File file) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        FileUtils fileUtils = FileUtils.newFileUtils();
        this.setDir(fileUtils.getParentFile(file));
        PatternSet.NameEntry include = this.createInclude();
        include.setName(file.getName());
    }

    public void setIncludes(String includes) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.defaultPatterns.setIncludes(includes);
    }

    public void setExcludes(String excludes) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.defaultPatterns.setExcludes(excludes);
    }

    public void setIncludesfile(File incl) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.defaultPatterns.setIncludesfile(incl);
    }

    public void setExcludesfile(File excl) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.defaultPatterns.setExcludesfile(excl);
    }

    public void setDefaultexcludes(boolean useDefaultExcludes) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.useDefaultExcludes = useDefaultExcludes;
    }

    public void setCaseSensitive(boolean isCaseSensitive) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.isCaseSensitive = isCaseSensitive;
    }

    public void setFollowSymlinks(boolean followSymlinks) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.followSymlinks = followSymlinks;
    }

    protected String getDataTypeName() {
        String classname;
        int dotIndex;
        Project project = this.getProject();
        if (project != null) {
            Hashtable typedefs = project.getDataTypeDefinitions();
            Enumeration e = typedefs.keys();
            while (e.hasMoreElements()) {
                String typeName = (String)e.nextElement();
                Class typeClass = (Class)typedefs.get(typeName);
                if (typeClass != this.getClass()) continue;
                return typeName;
            }
        }
        if ((dotIndex = (classname = this.getClass().getName()).lastIndexOf(".")) == -1) {
            return classname;
        }
        return classname.substring(dotIndex + 1);
    }

    public DirectoryScanner getDirectoryScanner(Project p) {
        if (this.isReference()) {
            return this.getRef(p).getDirectoryScanner(p);
        }
        if (this.dir == null) {
            throw new BuildException("No directory specified for " + this.getDataTypeName() + ".");
        }
        if (!this.dir.exists()) {
            throw new BuildException(this.dir.getAbsolutePath() + " not found.");
        }
        if (!this.dir.isDirectory()) {
            throw new BuildException(this.dir.getAbsolutePath() + " is not a directory.");
        }
        DirectoryScanner ds = new DirectoryScanner();
        this.setupDirectoryScanner(ds, p);
        ds.setFollowSymlinks(this.followSymlinks);
        ds.scan();
        return ds;
    }

    public void setupDirectoryScanner(FileScanner ds, Project p) {
        if (this.isReference()) {
            this.getRef(p).setupDirectoryScanner(ds, p);
            return;
        }
        if (ds == null) {
            throw new IllegalArgumentException("ds cannot be null");
        }
        ds.setBasedir(this.dir);
        int count = this.additionalPatterns.size();
        int i = 0;
        while (i < count) {
            Object o = this.additionalPatterns.elementAt(i);
            this.defaultPatterns.append((PatternSet)o, p);
            ++i;
        }
        p.log(this.getDataTypeName() + ": Setup scanner in dir " + this.dir + " with " + this.defaultPatterns, 4);
        ds.setIncludes(this.defaultPatterns.getIncludePatterns(p));
        ds.setExcludes(this.defaultPatterns.getExcludePatterns(p));
        if (ds instanceof SelectorScanner) {
            SelectorScanner ss = (SelectorScanner)((Object)ds);
            ss.setSelectors(this.getSelectors(p));
        }
        if (this.useDefaultExcludes) {
            ds.addDefaultExcludes();
        }
        ds.setCaseSensitive(this.isCaseSensitive);
    }

    protected AbstractFileSet getRef(Project p) {
        if (!this.isChecked()) {
            Stack<AbstractFileSet> stk = new Stack<AbstractFileSet>();
            stk.push(this);
            this.dieOnCircularReference(stk, p);
        }
        Object o = this.getRefid().getReferencedObject(p);
        if (!this.getClass().isAssignableFrom(o.getClass())) {
            String msg = this.getRefid().getRefId() + " doesn't denote a " + this.getDataTypeName();
            throw new BuildException(msg);
        }
        return (AbstractFileSet)o;
    }

    public boolean hasSelectors() {
        if (this.isReference() && this.getProject() != null) {
            return this.getRef(this.getProject()).hasSelectors();
        }
        return !this.selectors.isEmpty();
    }

    public boolean hasPatterns() {
        if (this.isReference() && this.getProject() != null) {
            return this.getRef(this.getProject()).hasPatterns();
        }
        if (this.defaultPatterns.hasPatterns(this.getProject())) {
            return true;
        }
        Enumeration enumeration = this.additionalPatterns.elements();
        while (enumeration.hasMoreElements()) {
            PatternSet ps = (PatternSet)enumeration.nextElement();
            if (!ps.hasPatterns(this.getProject())) continue;
            return true;
        }
        return false;
    }

    public int selectorCount() {
        if (this.isReference() && this.getProject() != null) {
            return this.getRef(this.getProject()).selectorCount();
        }
        return this.selectors.size();
    }

    public FileSelector[] getSelectors(Project p) {
        if (this.isReference()) {
            return this.getRef(p).getSelectors(p);
        }
        Object[] result = new FileSelector[this.selectors.size()];
        this.selectors.copyInto(result);
        return result;
    }

    public Enumeration selectorElements() {
        if (this.isReference() && this.getProject() != null) {
            return this.getRef(this.getProject()).selectorElements();
        }
        return this.selectors.elements();
    }

    public void appendSelector(FileSelector selector) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.selectors.addElement(selector);
    }

    public void addSelector(SelectSelector selector) {
        this.appendSelector(selector);
    }

    public void addAnd(AndSelector selector) {
        this.appendSelector(selector);
    }

    public void addOr(OrSelector selector) {
        this.appendSelector(selector);
    }

    public void addNot(NotSelector selector) {
        this.appendSelector(selector);
    }

    public void addNone(NoneSelector selector) {
        this.appendSelector(selector);
    }

    public void addMajority(MajoritySelector selector) {
        this.appendSelector(selector);
    }

    public void addDate(DateSelector selector) {
        this.appendSelector(selector);
    }

    public void addSize(SizeSelector selector) {
        this.appendSelector(selector);
    }

    public void addDifferent(DifferentSelector selector) {
        this.appendSelector(selector);
    }

    public void addFilename(FilenameSelector selector) {
        this.appendSelector(selector);
    }

    public void addType(TypeSelector selector) {
        this.appendSelector(selector);
    }

    public void addCustom(ExtendSelector selector) {
        this.appendSelector(selector);
    }

    public void addContains(ContainsSelector selector) {
        this.appendSelector(selector);
    }

    public void addPresent(PresentSelector selector) {
        this.appendSelector(selector);
    }

    public void addDepth(DepthSelector selector) {
        this.appendSelector(selector);
    }

    public void addDepend(DependSelector selector) {
        this.appendSelector(selector);
    }

    public void addContainsRegexp(ContainsRegexpSelector selector) {
        this.appendSelector(selector);
    }

    public String toString() {
        DirectoryScanner ds = this.getDirectoryScanner(this.getProject());
        String[] files = ds.getIncludedFiles();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < files.length) {
            if (i > 0) {
                sb.append(';');
            }
            sb.append(files[i]);
            ++i;
        }
        return sb.toString();
    }
}

