/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.util.Stack;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.types.Reference;

public abstract class DataType
extends ProjectComponent {
    protected String description;
    protected Reference ref;
    protected boolean checked = true;

    public void setDescription(String desc) {
        this.description = desc;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isReference() {
        return this.ref != null;
    }

    public void setRefid(Reference ref) {
        this.ref = ref;
        this.checked = false;
    }

    protected void dieOnCircularReference(Stack stack, Project project) throws BuildException {
        if (this.checked || !this.isReference()) {
            return;
        }
        Object o = this.ref.getReferencedObject(project);
        if (o instanceof DataType) {
            if (stack.contains(o)) {
                throw this.circularReference();
            }
            stack.push(o);
            ((DataType)o).dieOnCircularReference(stack, project);
            stack.pop();
        }
        this.checked = true;
    }

    protected Object getCheckedRef(Class requiredClass, String dataTypeName) {
        Object o;
        if (!this.checked) {
            Stack<DataType> stk = new Stack<DataType>();
            stk.push(this);
            this.dieOnCircularReference(stk, this.getProject());
        }
        if (!requiredClass.isAssignableFrom((o = this.ref.getReferencedObject(this.getProject())).getClass())) {
            String msg = this.ref.getRefId() + " doesn't denote a " + dataTypeName;
            throw new BuildException(msg);
        }
        return o;
    }

    protected BuildException tooManyAttributes() {
        return new BuildException("You must not specify more than one attribute when using refid");
    }

    protected BuildException noChildrenAllowed() {
        return new BuildException("You must not specify nested elements when using refid");
    }

    protected BuildException circularReference() {
        return new BuildException("This data type contains a circular reference.");
    }

    protected boolean isChecked() {
        return this.checked;
    }

    protected void setChecked(boolean checked) {
        this.checked = checked;
    }

    protected Reference getRefid() {
        return this.ref;
    }
}

