/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.util.FileUtils;

public class LoaderUtils {
    private static Method getContextClassLoader;
    private static Method setContextClassLoader;
    static /* synthetic */ Class class$java$lang$Thread;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$org$apache$tools$ant$util$LoaderUtils;

    public static void setContextClassLoader(ClassLoader loader) {
        if (setContextClassLoader == null) {
            return;
        }
        try {
            Thread currentThread = Thread.currentThread();
            setContextClassLoader.invoke((Object)currentThread, loader);
        }
        catch (IllegalAccessException e) {
            throw new BuildException("Unexpected IllegalAccessException", e);
        }
        catch (InvocationTargetException e) {
            throw new BuildException("Unexpected InvocationTargetException", e);
        }
    }

    public static ClassLoader getContextClassLoader() {
        if (getContextClassLoader == null) {
            return null;
        }
        try {
            Thread currentThread = Thread.currentThread();
            return (ClassLoader)getContextClassLoader.invoke((Object)currentThread, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new BuildException("Unexpected IllegalAccessException", e);
        }
        catch (InvocationTargetException e) {
            throw new BuildException("Unexpected InvocationTargetException", e);
        }
    }

    public static boolean isContextLoaderAvailable() {
        return getContextClassLoader != null && setContextClassLoader != null;
    }

    public static File getClassSource(Class c) {
        String classFile = c.getName().replace('.', '/') + ".class";
        return LoaderUtils.getResourceSource(c.getClassLoader(), classFile);
    }

    public static File getResourceSource(ClassLoader c, String resource) {
        URL url;
        FileUtils fileUtils = FileUtils.newFileUtils();
        if (c == null) {
            c = (class$org$apache$tools$ant$util$LoaderUtils == null ? (class$org$apache$tools$ant$util$LoaderUtils = LoaderUtils.class$("org.apache.tools.ant.util.LoaderUtils")) : class$org$apache$tools$ant$util$LoaderUtils).getClassLoader();
        }
        if ((url = c.getResource(resource)) != null) {
            String u = url.toString();
            if (u.startsWith("jar:file:")) {
                int pling = u.indexOf("!");
                String jarName = u.substring(4, pling);
                return new File(fileUtils.fromURI(jarName));
            }
            if (u.startsWith("file:")) {
                int tail = u.indexOf(resource);
                String dirName = u.substring(0, tail);
                return new File(fileUtils.fromURI(dirName));
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            getContextClassLoader = (class$java$lang$Thread == null ? (class$java$lang$Thread = LoaderUtils.class$("java.lang.Thread")) : class$java$lang$Thread).getMethod("getContextClassLoader", new Class[0]);
            Class[] setContextArgs = new Class[]{class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = LoaderUtils.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader};
            setContextClassLoader = (class$java$lang$Thread == null ? (class$java$lang$Thread = LoaderUtils.class$("java.lang.Thread")) : class$java$lang$Thread).getMethod("setContextClassLoader", setContextArgs);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

