/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.xml.xpath;

import java.util.HashMap;
import javax.xml.transform.TransformerException;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.excalibur.xml.xpath.EmptyNodeList;
import org.apache.excalibur.xml.xpath.PrefixResolver;
import org.apache.excalibur.xml.xpath.XPathProcessor;
import org.apache.xpath.XPathAPI;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XPathProcessorImpl
extends AbstractLogEnabled
implements XPathProcessor,
Configurable,
PrefixResolver,
Component,
ThreadSafe {
    private String m_baseURI;
    private final HashMap m_mappings = new HashMap();

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration namespaceMappings = configuration.getChild("namespace-mappings", true);
        this.m_baseURI = namespaceMappings.getAttribute("base-uri", null);
        Configuration[] namespaces = namespaceMappings.getChildren("namespace");
        int i = 0;
        while (i < namespaces.length) {
            String prefix = namespaces[i].getAttribute("prefix");
            String uri = namespaces[i].getAttribute("uri");
            this.m_mappings.put(prefix, uri);
            ++i;
        }
    }

    public Node selectSingleNode(Node contextNode, String str) {
        return this.selectSingleNode(contextNode, str, this);
    }

    public NodeList selectNodeList(Node contextNode, String str) {
        return this.selectNodeList(contextNode, str, this);
    }

    public boolean evaluateAsBoolean(Node contextNode, String str) {
        return this.evaluateAsBoolean(contextNode, str, this);
    }

    public Number evaluateAsNumber(Node contextNode, String str) {
        return this.evaluateAsNumber(contextNode, str, this);
    }

    public String evaluateAsString(Node contextNode, String str) {
        return this.evaluateAsString(contextNode, str, this);
    }

    public boolean evaluateAsBoolean(Node contextNode, String str, PrefixResolver resolver) {
        try {
            XObject result = XPathAPI.eval((Node)contextNode, (String)str, (org.apache.xml.utils.PrefixResolver)new XalanResolver(resolver));
            return result.bool();
        }
        catch (TransformerException te) {
            return false;
        }
    }

    public Number evaluateAsNumber(Node contextNode, String str, PrefixResolver resolver) {
        try {
            XObject result = XPathAPI.eval((Node)contextNode, (String)str, (org.apache.xml.utils.PrefixResolver)new XalanResolver(resolver));
            return new Double(result.num());
        }
        catch (TransformerException te) {
            return null;
        }
    }

    public String evaluateAsString(Node contextNode, String str, PrefixResolver resolver) {
        try {
            XObject result = XPathAPI.eval((Node)contextNode, (String)str, (org.apache.xml.utils.PrefixResolver)new XalanResolver(resolver));
            return result.str();
        }
        catch (TransformerException te) {
            return null;
        }
    }

    public Node selectSingleNode(Node contextNode, String str, PrefixResolver resolver) {
        try {
            XObject result = XPathAPI.eval((Node)contextNode, (String)str, (org.apache.xml.utils.PrefixResolver)new XalanResolver(resolver));
            return result.nodeset().nextNode();
        }
        catch (TransformerException te) {
            return null;
        }
    }

    public NodeList selectNodeList(Node contextNode, String str, PrefixResolver resolver) {
        try {
            XObject result = XPathAPI.eval((Node)contextNode, (String)str, (org.apache.xml.utils.PrefixResolver)new XalanResolver(resolver));
            return result.nodelist();
        }
        catch (TransformerException te) {
            return new EmptyNodeList();
        }
    }

    public String prefixToNamespace(String prefix) {
        return (String)this.m_mappings.get(prefix);
    }

    private final class XalanResolver
    implements org.apache.xml.utils.PrefixResolver {
        private final PrefixResolver resolver;

        public XalanResolver(PrefixResolver resolver) {
            this.resolver = resolver;
        }

        public String getNamespaceForPrefix(String prefix) {
            return this.resolver.prefixToNamespace(prefix);
        }

        public String getNamespaceForPrefix(String prefix, Node context) {
            return this.resolver.prefixToNamespace(prefix);
        }

        public String getBaseIdentifier() {
            return XPathProcessorImpl.this.m_baseURI;
        }

        public boolean handlesNullPrefixes() {
            return false;
        }
    }
}

