/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.xmlizer;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.excalibur.xml.sax.SAXParser;
import org.apache.excalibur.xmlizer.XMLizer;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class DefaultXMLizer
extends AbstractLogEnabled
implements XMLizer,
Serviceable,
Configurable,
ThreadSafe,
Component {
    private ServiceManager m_serviceManager;
    private Map m_mimeTypes = new HashMap();

    public void service(ServiceManager serviceManager) throws ServiceException {
        this.m_serviceManager = serviceManager;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration[] parsers = configuration.getChildren("parser");
        int i = 0;
        while (i < parsers.length) {
            Configuration parser = parsers[i];
            String mimeType = parser.getAttribute("mime-type");
            String role = parser.getAttribute("role");
            this.m_mimeTypes.put(mimeType, role);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("XMLizer: Registering parser '" + role + "' for mime-type '" + mimeType + "'.");
            }
            ++i;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("XMLizer: Default parser is '" + SAXParser.ROLE + "'.");
        }
    }

    public void toSAX(InputStream stream, String mimeType, String systemID, ContentHandler handler) throws SAXException, IOException {
        String parserRole;
        if (null == stream) {
            throw new NullPointerException("stream");
        }
        if (null == handler) {
            throw new NullPointerException("handler");
        }
        if (this.m_mimeTypes.containsKey(mimeType)) {
            parserRole = (String)this.m_mimeTypes.get(mimeType);
        } else {
            if (this.getLogger().isDebugEnabled()) {
                String message = "No mime-type for xmlizing " + systemID + ", guessing text/xml";
                this.getLogger().debug(message);
            }
            parserRole = SAXParser.ROLE;
        }
        try {
            SAXParser parser = (SAXParser)this.m_serviceManager.lookup(parserRole);
            InputSource inputSource = new InputSource(stream);
            inputSource.setSystemId(systemID);
            parser.parse(inputSource, handler, null);
            this.m_serviceManager.release((Object)parser);
        }
        catch (ServiceException e) {
            throw new SAXException("Cannot parse content of type " + mimeType, (Exception)((Object)e));
        }
    }
}

