/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.adapter.ant;

import org.apache.avalon.framework.logger.Logger;
import org.apache.tools.ant.Task;

public final class AntLogger
implements Logger {
    private final Task task;
    private int antMsgLevel = 0;

    public AntLogger(Task logImpl, int antMsgLevel) {
        this.task = logImpl;
        this.antMsgLevel = antMsgLevel;
    }

    public final void debug(String message) {
        if (this.isDebugEnabled()) {
            this.task.log(message);
        }
    }

    public final void debug(String message, Throwable throwable) {
        if (this.isDebugEnabled()) {
            this.task.log(String.valueOf(message) + ":" + throwable.getMessage());
        }
    }

    public final void error(String message) {
        if (this.isErrorEnabled()) {
            this.task.log(message);
        }
    }

    public final void error(String message, Throwable throwable) {
        if (this.isErrorEnabled()) {
            this.task.log(String.valueOf(message) + ":" + throwable.getMessage());
        }
    }

    public final void fatalError(String message) {
        if (this.isFatalErrorEnabled()) {
            this.task.log(message);
        }
    }

    public final void fatalError(String message, Throwable throwable) {
        if (this.isFatalErrorEnabled()) {
            this.task.log(String.valueOf(message) + ":" + throwable.getMessage());
        }
    }

    public final Logger getChildLogger(String name) {
        return this;
    }

    public final void info(String message) {
        if (this.isInfoEnabled()) {
            this.task.log(message);
        }
    }

    public final void info(String message, Throwable throwable) {
        if (this.isInfoEnabled()) {
            this.task.log(String.valueOf(message) + ":" + throwable.getMessage());
        }
    }

    public final boolean isDebugEnabled() {
        return this.antMsgLevel == 4;
    }

    public final boolean isErrorEnabled() {
        return this.antMsgLevel >= 0;
    }

    public final boolean isFatalErrorEnabled() {
        return this.antMsgLevel >= 0;
    }

    public final boolean isInfoEnabled() {
        return this.antMsgLevel >= 2;
    }

    public final boolean isWarnEnabled() {
        return this.antMsgLevel >= 1;
    }

    public final void warn(String message) {
        if (this.isWarnEnabled()) {
            this.task.log(message);
        }
    }

    public final void warn(String message, Throwable throwable) {
        if (this.isWarnEnabled()) {
            this.task.log(String.valueOf(message) + ":" + throwable.getMessage());
        }
    }
}

