/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.adapter.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import net.sourceforge.chaperon.adapter.ant.AntLogger;
import net.sourceforge.chaperon.adapter.avalon.GrammarFactory;
import net.sourceforge.chaperon.adapter.avalon.LexiconFactory;
import net.sourceforge.chaperon.adapter.sax.LexicalHandlerAdapter;
import net.sourceforge.chaperon.adapter.sax.LexicalProcessorAdapter;
import net.sourceforge.chaperon.adapter.sax.ParserHandlerAdapter;
import net.sourceforge.chaperon.build.LexicalAutomatonBuilder;
import net.sourceforge.chaperon.build.ParserAutomatonBuilder;
import net.sourceforge.chaperon.model.grammar.Grammar;
import net.sourceforge.chaperon.model.lexicon.Lexicon;
import net.sourceforge.chaperon.process.LexicalAutomaton;
import net.sourceforge.chaperon.process.LexicalProcessor;
import net.sourceforge.chaperon.process.ParserAutomaton;
import net.sourceforge.chaperon.process.ParserProcessor;
import net.sourceforge.chaperon.process.TextLocator;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.NamespacedSAXConfigurationHandler;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.types.XMLCatalog;
import org.apache.tools.ant.util.IdentityMapper;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class ParserTask
extends MatchingTask {
    private File srcDir = null;
    private File destDir = null;
    private File baseDir = null;
    private File cacheDir = null;
    private Mapper mapper = null;
    private XMLCatalog xmlCatalog = new XMLCatalog();
    private File lexiconFile = null;
    private File grammarFile = null;
    private String parserFactory = null;
    private SAXParserFactory parserFactoryImpl = null;
    private String transformerFactory = null;
    private SAXTransformerFactory transformerFactoryImpl = null;
    private String encoding = "ISO-8859-1";
    private boolean indent = false;
    private boolean flatten = false;
    private String inputtype = "text";
    private int msgLevel = 0;
    private AntLogger logger;
    private ParserHandlerAdapter parseradapter = null;
    private ParserAutomaton parserautomaton = null;
    private ParserProcessor parser = null;
    private LexicalHandlerAdapter lexicaladapter = null;
    private LexicalAutomaton lexicalautomaton = null;
    private LexicalProcessor lexer = null;

    public void addConfiguredXMLCatalog(XMLCatalog xmlCatalog) {
        this.xmlCatalog.addConfiguredXMLCatalog(xmlCatalog);
    }

    private void buildAutomata(File lexiconFile, File grammarFile) throws BuildException {
        block15: {
            if (this.cacheDir != null && !this.cacheDir.exists()) {
                throw new BuildException("Cache directory " + this.cacheDir + " doesn't exist");
            }
            try {
                ObjectOutputStream out;
                NamespacedSAXConfigurationHandler handler;
                XMLReader parser;
                SAXParserFactory factory;
                ObjectInputStream in;
                String filename = lexiconFile.getName();
                File cacheFile = null;
                if (this.cacheDir != null) {
                    cacheFile = new File(this.cacheDir, String.valueOf(filename) + ".obj");
                }
                if (cacheFile != null && cacheFile.exists() && cacheFile.lastModified() > lexiconFile.lastModified()) {
                    this.log("Reading lexicon from cache " + cacheFile, 4);
                    in = new ObjectInputStream(new FileInputStream(cacheFile));
                    this.lexicalautomaton = (LexicalAutomaton)in.readObject();
                    in.close();
                } else {
                    this.log("Building lexicon from " + lexiconFile, 2);
                    factory = this.getParserFactory();
                    factory.setNamespaceAware(true);
                    parser = factory.newSAXParser().getXMLReader();
                    parser.setEntityResolver((EntityResolver)this.xmlCatalog);
                    handler = new NamespacedSAXConfigurationHandler();
                    parser.setContentHandler((ContentHandler)handler);
                    try {
                        parser.parse(lexiconFile.toString());
                    }
                    catch (SAXParseException se) {
                        throw new BuildException("Couldn't parse file " + lexiconFile, (Throwable)se);
                    }
                    Configuration lexiconconfig = handler.getConfiguration();
                    Lexicon lexicon = LexiconFactory.createLexicon(lexiconconfig);
                    this.lexicalautomaton = new LexicalAutomatonBuilder(lexicon, this.logger).getLexicalAutomaton();
                    if (cacheFile != null) {
                        out = new ObjectOutputStream(new FileOutputStream(cacheFile));
                        out.writeObject(this.lexicalautomaton);
                        out.flush();
                        out.close();
                    }
                }
                if (grammarFile == null) break block15;
                filename = grammarFile.getName();
                cacheFile = null;
                if (this.cacheDir != null) {
                    cacheFile = new File(this.cacheDir, String.valueOf(filename) + ".obj");
                }
                if (cacheFile != null && cacheFile.exists() && cacheFile.lastModified() > grammarFile.lastModified()) {
                    this.log("Reading grammar from cache " + cacheFile, 4);
                    in = new ObjectInputStream(new FileInputStream(cacheFile));
                    this.parserautomaton = (ParserAutomaton)in.readObject();
                    in.close();
                    break block15;
                }
                this.log("Building grammar from " + grammarFile, 2);
                factory = this.getParserFactory();
                factory.setNamespaceAware(true);
                parser = factory.newSAXParser().getXMLReader();
                parser.setEntityResolver((EntityResolver)this.xmlCatalog);
                handler = new NamespacedSAXConfigurationHandler();
                parser.setContentHandler((ContentHandler)handler);
                try {
                    parser.parse(grammarFile.toString());
                }
                catch (SAXParseException se) {
                    throw new BuildException("Couldn't parse file " + lexiconFile, (Throwable)se);
                }
                Configuration grammarconfig = handler.getConfiguration();
                Grammar grammar = GrammarFactory.createGrammar(grammarconfig);
                this.parserautomaton = new ParserAutomatonBuilder(grammar, this.logger).getParserAutomaton();
                if (cacheFile != null) {
                    out = new ObjectOutputStream(new FileOutputStream(cacheFile));
                    out.writeObject(this.parserautomaton);
                    out.flush();
                    out.close();
                }
            }
            catch (Exception ex) {
                if (ex instanceof BuildException) {
                    throw (BuildException)ex;
                }
                throw new BuildException((Throwable)ex);
            }
        }
    }

    public Mapper createMapper() throws BuildException {
        if (this.mapper != null) {
            throw new BuildException("Cannot define more than one mapper", ((Task)this).location);
        }
        this.mapper = new Mapper(((ProjectComponent)this).project);
        return this.mapper;
    }

    private void ensureDirectoryFor(File targetFile) throws BuildException {
        File directory = new File(targetFile.getParent());
        if (!directory.exists() && !directory.mkdirs()) {
            throw new BuildException("Unable to create directory: " + directory.getAbsolutePath());
        }
    }

    public void execute() throws BuildException {
        if (this.baseDir == null) {
            this.baseDir = ((ProjectComponent)this).project.resolveFile(".");
        }
        if (this.lexiconFile == null) {
            throw new BuildException("No lexicon specified", ((Task)this).location);
        }
        if (!this.lexiconFile.exists()) {
            throw new BuildException("Lexicon doesn't exists", ((Task)this).location);
        }
        if (this.destDir == null) {
            throw new BuildException("No destdir specified!");
        }
        this.logger = new AntLogger((Task)this, this.msgLevel);
        this.buildAutomata(this.lexiconFile, this.grammarFile);
        DirectoryScanner scanner = this.getDirectoryScanner(this.srcDir);
        Object mapperImpl = this.mapper == null ? new IdentityMapper() : this.mapper.getImplementation();
        String[] list = scanner.getIncludedFiles();
        int i = 0;
        while (i < list.length) {
            String[] dest = mapperImpl.mapFileName(list[i]);
            if (dest != null) {
                int j = 0;
                while (j < dest.length) {
                    this.log("Transforming " + list[i] + " to " + dest[j], 4);
                    this.process(new File(this.srcDir, list[i]), new File(this.destDir, dest[j]));
                    ++j;
                }
            }
            ++i;
        }
    }

    private SAXParserFactory getParserFactory() throws BuildException {
        if (this.parserFactoryImpl == null) {
            try {
                this.parserFactoryImpl = this.parserFactory == null ? SAXParserFactory.newInstance() : (SAXParserFactory)Class.forName(this.parserFactory).newInstance();
            }
            catch (Exception e) {
                throw new BuildException("Could not load parser factory", (Throwable)e);
            }
        }
        return this.parserFactoryImpl;
    }

    private SAXTransformerFactory getTransformerFactory() throws BuildException {
        if (this.transformerFactoryImpl == null) {
            try {
                this.transformerFactoryImpl = this.transformerFactory == null ? (SAXTransformerFactory)TransformerFactory.newInstance() : (SAXTransformerFactory)Class.forName(this.transformerFactory).newInstance();
            }
            catch (Exception e) {
                throw new BuildException("Could not load transformer factory", (Throwable)e);
            }
        }
        return this.transformerFactoryImpl;
    }

    public void init() throws BuildException {
        super.init();
        this.xmlCatalog.setProject(((ProjectComponent)this).project);
    }

    private void process(File inFile, File outFile) throws BuildException {
        try {
            if (!inFile.exists()) {
                throw new BuildException("File " + inFile + " doesn't exists", ((Task)this).location);
            }
            if (inFile.lastModified() > outFile.lastModified()) {
                this.ensureDirectoryFor(outFile);
                this.log("Parsing file " + inFile + " to " + outFile, 2);
                if (this.parserautomaton != null && this.parseradapter == null) {
                    this.parseradapter = new ParserHandlerAdapter();
                    this.parseradapter.setFlatten(this.flatten);
                    if (this.inputtype.equalsIgnoreCase("xml")) {
                        this.parseradapter.setEmbedded(true);
                    }
                }
                if (this.parserautomaton == null && this.lexicaladapter == null) {
                    this.lexicaladapter = new LexicalHandlerAdapter();
                }
                if (this.parserautomaton != null && this.parser == null) {
                    this.parser = new ParserProcessor();
                    this.parser.setLogger(this.logger);
                    this.parser.setParserAutomaton(this.parserautomaton);
                    this.parser.setParserHandler(this.parseradapter);
                }
                if (this.lexer == null) {
                    this.lexer = new LexicalProcessor();
                    this.lexer.setLogger(this.logger);
                    this.lexer.setLexicalAutomaton(this.lexicalautomaton);
                    if (this.parserautomaton != null) {
                        this.lexer.setLexicalHandler(this.parser);
                    } else {
                        this.lexer.setLexicalHandler(this.lexicaladapter);
                    }
                }
                Properties format = new Properties();
                ((Hashtable)format).put("encoding", this.encoding);
                if (this.indent) {
                    ((Hashtable)format).put("indent", "yes");
                }
                ((Hashtable)format).put("method", "xml");
                SAXTransformerFactory factory = this.getTransformerFactory();
                TransformerHandler serializer = factory.newTransformerHandler();
                serializer.getTransformer().setOutputProperties(format);
                serializer.setResult(new StreamResult(outFile));
                if (this.parserautomaton != null) {
                    this.parseradapter.setContentHandler(serializer);
                } else {
                    this.lexicaladapter.setContentHandler(serializer);
                }
                if (!this.inputtype.equalsIgnoreCase("xml")) {
                    this.pushTextFile(inFile);
                } else {
                    this.pushXMLFile(inFile, serializer);
                }
            }
        }
        catch (Exception ex) {
            if (outFile != null) {
                outFile.delete();
            }
            if (ex instanceof BuildException) {
                throw (BuildException)ex;
            }
            throw new BuildException("Failed to process " + inFile, (Throwable)ex);
        }
    }

    private void pushTextFile(File inFile) throws Exception {
        try {
            String line;
            TextLocator locator = new TextLocator();
            locator.setURI(inFile.toURL().toString());
            locator.setLineNumber(1);
            locator.setColumnNumber(1);
            this.lexer.handleLocator(locator);
            this.lexer.handleStartDocument();
            LineNumberReader reader = new LineNumberReader(new InputStreamReader(new FileInputStream(inFile)));
            String newline = null;
            String separator = System.getProperty("line.separator");
            while ((line = newline == null ? reader.readLine() : newline) != null) {
                newline = reader.readLine();
                line = newline != null ? String.valueOf(line) + separator : line;
                locator.setLineNumber(reader.getLineNumber());
                locator.setColumnNumber(1);
                this.lexer.handleText(line);
                if (newline != null) continue;
            }
            reader.close();
            this.lexer.handleEndDocument();
        }
        catch (SAXParseException se) {
            throw new BuildException("Exception occurs during parsing file " + inFile + " at line " + se.getLineNumber() + " column " + se.getColumnNumber(), (Throwable)se);
        }
    }

    private void pushXMLFile(File inFile, ContentHandler serializer) throws Exception {
        SAXParserFactory parserfactory = this.getParserFactory();
        parserfactory.setNamespaceAware(true);
        XMLReader parser = parserfactory.newSAXParser().getXMLReader();
        parser.setEntityResolver((EntityResolver)this.xmlCatalog);
        LexicalProcessorAdapter handler = new LexicalProcessorAdapter();
        handler.setLexicalProcessor(this.lexer);
        handler.setContentHandler(serializer);
        parser.setContentHandler(handler);
        try {
            parser.parse(inFile.toString());
        }
        catch (SAXParseException se) {
            throw new BuildException("Exception occurs during parsing file " + inFile + " at line " + se.getLineNumber() + " column " + se.getColumnNumber(), (Throwable)se);
        }
    }

    public void setBasedir(File dir) {
        this.baseDir = dir;
    }

    public void setCachedir(File dir) {
        this.cacheDir = dir;
    }

    public void setDestdir(File dir) {
        this.destDir = dir;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setFlatten(boolean flatten) {
        this.flatten = flatten;
    }

    public void setGrammar(File grammarFile) {
        this.grammarFile = grammarFile;
    }

    public void setIndent(boolean indent) {
        this.indent = indent;
    }

    public void setInputtype(String inputtype) {
        this.inputtype = inputtype;
    }

    public void setLexicon(File lexiconFile) {
        this.lexiconFile = lexiconFile;
    }

    public void setMsglevel(String msgLevel) {
        if (msgLevel.equalsIgnoreCase("debug")) {
            this.msgLevel = 4;
        } else if (msgLevel.equalsIgnoreCase("verbose")) {
            this.msgLevel = 3;
        } else if (msgLevel.equalsIgnoreCase("info")) {
            this.msgLevel = 2;
        } else if (msgLevel.equalsIgnoreCase("warn")) {
            this.msgLevel = 1;
        } else if (msgLevel.equalsIgnoreCase("error")) {
            this.msgLevel = 0;
        }
    }

    public void setParser(String parserFactory) {
        this.parserFactory = parserFactory;
    }

    public void setSrcdir(File dir) {
        this.srcDir = dir;
    }

    public void setTransformer(String transformerFactory) {
        this.transformerFactory = transformerFactory;
    }
}

