/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.adapter.sax;

import net.sourceforge.chaperon.adapter.sax.LocatorAdapter;
import net.sourceforge.chaperon.process.LexicalProcessor;
import net.sourceforge.chaperon.process.Locator;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class LexicalProcessorAdapter
implements ContentHandler,
LexicalHandler {
    private static final String NS = "http://chaperon.sourceforge.net/schema/text/1.0";
    private static final String TEXT = "text";
    private LexicalProcessor processor = null;
    private ContentHandler contenthandler = null;
    private LexicalHandler lexicalhandler = null;
    private static final int STATE_OUTER = 0;
    private static final int STATE_TEXT = 1;
    private int state = 0;
    private org.xml.sax.Locator saxlocator = null;
    private Locator locator = null;
    private StringBuffer text = null;

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.state == 0) {
            this.contenthandler.characters(ch, start, length);
        } else if (this.state == 1) {
            try {
                this.processor.handleText(new String(ch, start, length));
            }
            catch (Exception e) {
                if (e instanceof SAXException) {
                    throw (SAXException)e;
                }
                throw new SAXException(e);
            }
        }
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this.state == 0) {
            this.lexicalhandler.comment(ch, start, length);
        }
    }

    public void endCDATA() throws SAXException {
        if (this.state == 0) {
            this.lexicalhandler.endCDATA();
        }
    }

    public void endDTD() throws SAXException {
        if (this.state == 0) {
            this.lexicalhandler.endDTD();
        }
    }

    public void endDocument() throws SAXException {
        if (this.state == 0) {
            this.contenthandler.endDocument();
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.state == 0) {
            this.contenthandler.endElement(namespaceURI, localName, qName);
        } else if (this.state == 1) {
            if (namespaceURI != null && namespaceURI.equals(NS) && localName.equals(TEXT)) {
                this.state = 0;
                try {
                    this.processor.handleEndDocument();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (e instanceof SAXException) {
                        throw (SAXException)e;
                    }
                    throw new SAXException(e);
                }
                if (this.saxlocator != null) {
                    this.contenthandler.setDocumentLocator(this.saxlocator);
                }
            } else {
                throw new SAXException("Unexpected end element '" + qName + "'.");
            }
        }
    }

    public void endEntity(String name) throws SAXException {
        if (this.state == 0) {
            this.lexicalhandler.endEntity(name);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.contenthandler.endPrefixMapping(prefix);
    }

    public LexicalProcessor getLexicalProcessor() {
        return this.processor;
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.state == 0) {
            this.contenthandler.characters(ch, start, length);
        } else if (this.state == 1) {
            try {
                this.processor.handleText(new String(ch, start, length));
            }
            catch (Exception e) {
                if (e instanceof SAXException) {
                    throw (SAXException)e;
                }
                throw new SAXException(e);
            }
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this.state == 0) {
            this.contenthandler.processingInstruction(target, data);
        }
    }

    public void setContentHandler(ContentHandler contenthandler) {
        this.contenthandler = contenthandler;
    }

    public void setDocumentLocator(org.xml.sax.Locator locator) {
        this.saxlocator = locator;
        if (locator != null) {
            this.locator = new LocatorAdapter(locator);
            this.contenthandler.setDocumentLocator(locator);
        } else {
            this.locator = null;
        }
    }

    public void setLexicalHandler(LexicalHandler lexicalhandler) {
        this.lexicalhandler = lexicalhandler;
    }

    public void setLexicalProcessor(LexicalProcessor processor) {
        this.processor = processor;
    }

    public void skippedEntity(String name) throws SAXException {
        if (this.state == 0) {
            this.contenthandler.skippedEntity(name);
        }
    }

    public void startCDATA() throws SAXException {
        if (this.state == 0) {
            this.lexicalhandler.startCDATA();
        }
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        if (this.state == 0) {
            this.lexicalhandler.startDTD(name, publicId, systemId);
        }
    }

    public void startDocument() throws SAXException {
        this.contenthandler.startDocument();
        this.state = 0;
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (this.state == 0) {
            if (namespaceURI != null && namespaceURI.equals(NS) && localName.equals(TEXT)) {
                this.state = 1;
                this.text = new StringBuffer();
                this.processor.handleLocator(this.locator);
                try {
                    this.processor.handleStartDocument();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (e instanceof SAXException) {
                        throw (SAXException)e;
                    }
                    throw new SAXException(e);
                }
            } else {
                this.contenthandler.startElement(namespaceURI, localName, qName, atts);
            }
        } else if (this.state == 1) {
            throw new SAXException("Unexpected start element '" + qName + "'.");
        }
    }

    public void startEntity(String name) throws SAXException {
        if (this.state == 0) {
            this.lexicalhandler.startEntity(name);
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.contenthandler.startPrefixMapping(prefix, uri);
    }
}

