/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.adapter.sax;

import java.util.Stack;
import net.sourceforge.chaperon.process.Locator;
import net.sourceforge.chaperon.process.ParserHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.LocatorImpl;

public class ParserHandlerAdapter
implements ParserHandler {
    public static final String NS = "http://chaperon.sourceforge.net/schema/syntaxtree/1.0";
    private String ns = "http://chaperon.sourceforge.net/schema/syntaxtree/1.0";
    private ContentHandler handler;
    private boolean embedded = false;
    private boolean flatten = false;
    private Locator locator = null;
    private LocatorImpl saxlocator = null;
    private Stack stack;

    public ParserHandlerAdapter() {
    }

    public ParserHandlerAdapter(boolean embedded) {
        this.embedded = embedded;
    }

    private void fireEvents(Production parent, Node node) throws Exception {
        if (node instanceof Production) {
            Production production = (Production)node;
            if (this.locator != null) {
                this.saxlocator.setLineNumber(production.linenumber);
                this.saxlocator.setColumnNumber(production.columnnumber);
            }
            if (!this.flatten || !parent.symbol.equals(production.symbol)) {
                this.handler.startElement(this.ns, production.symbol, production.symbol, new AttributesImpl());
            }
            Node next = production.firstchild;
            while (next != null) {
                this.fireEvents(production, next);
                next = next.nextsibling;
            }
            if (!this.flatten || !parent.symbol.equals(production.symbol)) {
                this.handler.endElement(this.ns, production.symbol, production.symbol);
            }
        } else {
            Token token = (Token)node;
            if (this.locator != null) {
                this.saxlocator.setLineNumber(token.linenumber);
                this.saxlocator.setColumnNumber(token.columnnumber);
            }
            this.handler.startElement(this.ns, token.symbol, token.symbol, new AttributesImpl());
            this.handler.characters(token.text.toCharArray(), 0, token.text.length());
            this.handler.endElement(this.ns, token.symbol, token.symbol);
        }
    }

    public void handleEndDocument() throws Exception {
        Production production = (Production)this.stack.pop();
        if (this.locator != null) {
            this.saxlocator.setLineNumber(production.linenumber);
            this.saxlocator.setColumnNumber(production.columnnumber);
            this.handler.setDocumentLocator(this.saxlocator);
        }
        if (!this.embedded) {
            this.handler.startDocument();
        }
        this.handler.startPrefixMapping("", this.ns);
        AttributesImpl atts = new AttributesImpl();
        this.handler.startElement(this.ns, production.symbol, production.symbol, atts);
        Node next = production.firstchild;
        while (next != null) {
            this.fireEvents(production, next);
            next = next.nextsibling;
        }
        this.handler.endElement(this.ns, production.symbol, production.symbol);
        this.handler.endPrefixMapping("");
        if (!this.embedded) {
            this.handler.endDocument();
        }
    }

    public void handleLocator(Locator locator) {
        this.locator = locator;
        if (locator != null) {
            this.saxlocator = new LocatorImpl();
            this.saxlocator.setSystemId(locator.getURI());
            this.saxlocator.setLineNumber(locator.getLineNumber());
            this.saxlocator.setColumnNumber(locator.getColumnNumber());
        } else {
            this.saxlocator = null;
        }
    }

    public void handleRecovery() throws Exception {
        System.out.println("handler stack=" + this.stack);
        this.stack.pop();
    }

    public void handleReduceProduction(String symbol, int length) throws Exception {
        Production newnode = new Production(symbol);
        Node node = null;
        int i = 0;
        while (i < length) {
            node = (Node)this.stack.pop();
            newnode.insert(node);
            ++i;
        }
        if (node != null) {
            newnode.linenumber = node.linenumber;
            newnode.columnnumber = node.columnnumber;
        }
        this.stack.push(newnode);
    }

    public void handleShiftLexeme(String symbol, String text) throws Exception {
        Token token = new Token(symbol, text);
        if (this.locator != null) {
            token.linenumber = this.locator.getLineNumber();
            token.columnnumber = this.locator.getColumnNumber();
        }
        this.stack.push(token);
    }

    public void handleStartDocument() {
        this.stack = new Stack();
    }

    public void setContentHandler(ContentHandler handler) {
        this.handler = handler;
    }

    public void setEmbedded(boolean embedded) {
        this.embedded = embedded;
    }

    public void setFlatten(boolean flatten) {
        this.flatten = flatten;
    }

    public void setNamespace(String namespace) {
        this.ns = namespace;
    }

    private class Node {
        public String symbol = null;
        public int linenumber = 1;
        public int columnnumber = 1;
        public Node previoussibling = null;
        public Node nextsibling = null;

        Node() {
        }
    }

    private class Token
    extends Node {
        public String text = null;

        public Token(String symbol, String text) {
            this.symbol = symbol;
            this.text = text;
        }
    }

    private class Production
    extends Node {
        public Node firstchild = null;
        public Node lastchild = null;

        public Production(String symbol) {
            this.symbol = symbol;
        }

        public void insert(Node node) {
            if (this.firstchild == null) {
                this.firstchild = node;
                this.lastchild = node;
            } else {
                this.firstchild.previoussibling = node;
                node.nextsibling = this.firstchild;
                this.firstchild = node;
            }
        }

        public void insertChilds(Production production) {
            if (this.firstchild == null) {
                this.firstchild = production.firstchild;
                this.lastchild = production.lastchild;
            } else {
                this.firstchild.previoussibling = production.lastchild;
                production.lastchild.nextsibling = this.firstchild;
                this.firstchild = production.firstchild;
            }
        }
    }
}

