/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.build;

import net.sourceforge.chaperon.model.Violations;
import net.sourceforge.chaperon.model.pattern.Alternation;
import net.sourceforge.chaperon.model.pattern.BeginOfLine;
import net.sourceforge.chaperon.model.pattern.CharacterClass;
import net.sourceforge.chaperon.model.pattern.CharacterInterval;
import net.sourceforge.chaperon.model.pattern.CharacterSet;
import net.sourceforge.chaperon.model.pattern.CharacterString;
import net.sourceforge.chaperon.model.pattern.Concatenation;
import net.sourceforge.chaperon.model.pattern.EndOfLine;
import net.sourceforge.chaperon.model.pattern.Pattern;
import net.sourceforge.chaperon.model.pattern.PatternGroup;
import net.sourceforge.chaperon.model.pattern.UniversalCharacter;
import net.sourceforge.chaperon.process.PatternAutomaton;

public class PatternAutomatonBuilder {
    private Pattern pattern = null;
    private PatternAutomaton automaton = null;
    private Violations violations = new Violations();
    private int statecount = 0;
    private int stateindex = 0;
    private int groupcount = 0;
    private int groupindex = 0;

    public PatternAutomatonBuilder(Pattern pattern) {
        this.violations.addViolations(pattern.validate());
        if (this.violations != null && this.violations.getViolationCount() > 0) {
            throw new IllegalArgumentException("Pattern is not valid: " + this.violations.getViolation(0));
        }
        this.pattern = pattern;
        this.statecount = this.getStateCount(pattern) + 3;
        this.stateindex = this.statecount - 1;
        this.groupindex = this.groupcount = this.getGroupCount(pattern);
        PatternAutomaton automaton = new PatternAutomaton(this.statecount);
        automaton.setGroupCount(this.groupcount + 1);
        int finalstate = this.stateindex--;
        automaton.setFinalState(finalstate);
        automaton.setType(this.stateindex, 7);
        automaton.setGroupIndex(this.stateindex, 0);
        automaton.setTransitions(this.stateindex, new int[]{finalstate});
        int state = this.stateindex--;
        state = this.traverse(automaton, pattern, state);
        automaton.setType(this.stateindex, 6);
        automaton.setGroupIndex(this.stateindex, 0);
        automaton.setTransitions(this.stateindex, new int[]{state});
        automaton.setFirstState(this.stateindex);
        this.automaton = automaton;
    }

    private int evalAlternation(PatternAutomaton automaton, Alternation element, int laststate) {
        if (element.getPatternCount() == 1) {
            return this.traverse(automaton, element.getPattern(0), laststate);
        }
        int nextstate = this.stateindex--;
        int i = element.getPatternCount() - 1;
        while (i >= 0) {
            int state = this.traverse(automaton, element.getPattern(i), laststate);
            automaton.addTransition(nextstate, state);
            --i;
        }
        return nextstate;
    }

    private int evalBeginOfLine(PatternAutomaton automaton, BeginOfLine element, int laststate) {
        automaton.setType(this.stateindex, 4);
        automaton.setTransitions(this.stateindex, new int[]{laststate});
        return this.stateindex--;
    }

    private int evalCharacterClass(PatternAutomaton automaton, CharacterClass element, int laststate) {
        if (!element.isExclusive()) {
            int firststate = this.stateindex--;
            int i = 0;
            while (i < element.getCharacterClassElementCount()) {
                int state;
                if (element.getCharacterClassElement(i) instanceof CharacterInterval) {
                    CharacterInterval interval = (CharacterInterval)element.getCharacterClassElement(i);
                    automaton.setType(this.stateindex, 1);
                    automaton.setInterval(this.stateindex, interval.getMinimum(), interval.getMaximum());
                    automaton.addTransition(this.stateindex, laststate);
                    --this.stateindex;
                    automaton.addTransition(firststate, state);
                } else if (element.getCharacterClassElement(i) instanceof CharacterSet) {
                    CharacterSet set = (CharacterSet)element.getCharacterClassElement(i);
                    String chars = set.getCharacters();
                    int j = 0;
                    while (j < chars.length()) {
                        automaton.setType(this.stateindex, 1);
                        automaton.setInterval(this.stateindex, chars.charAt(j), chars.charAt(j));
                        automaton.addTransition(this.stateindex, laststate);
                        --this.stateindex;
                        automaton.addTransition(firststate, state);
                        ++j;
                    }
                }
                ++i;
            }
            return firststate;
        }
        int state = this.stateindex--;
        automaton.setType(state, 3);
        automaton.setTransitions(state, new int[]{laststate});
        int i = element.getCharacterClassElementCount() - 1;
        while (i >= 0) {
            if (element.getCharacterClassElement(i) instanceof CharacterInterval) {
                CharacterInterval interval = (CharacterInterval)element.getCharacterClassElement(i);
                automaton.setType(this.stateindex, 1);
                automaton.setInterval(this.stateindex, interval.getMinimum(), interval.getMaximum());
                automaton.setTransitions(this.stateindex, new int[]{state});
                --this.stateindex;
            } else if (element.getCharacterClassElement(i) instanceof CharacterSet) {
                CharacterSet set = (CharacterSet)element.getCharacterClassElement(i);
                String chars = set.getCharacters();
                int j = 0;
                while (j < chars.length()) {
                    automaton.setType(this.stateindex, 2);
                    automaton.setInterval(this.stateindex, chars.charAt(j), chars.charAt(j));
                    automaton.setType(this.stateindex, 2);
                    automaton.setTransitions(this.stateindex, new int[]{state});
                    --this.stateindex;
                    ++j;
                }
            }
            --i;
        }
        return state;
    }

    private int evalCharacterString(PatternAutomaton automaton, CharacterString element, int laststate) {
        int state = laststate;
        int i = element.getString().length() - 1;
        while (i >= 0) {
            automaton.setType(this.stateindex, 1);
            automaton.setInterval(this.stateindex, element.getString().charAt(i), element.getString().charAt(i));
            automaton.setTransitions(this.stateindex, new int[]{state});
            --this.stateindex;
            --i;
        }
        return state;
    }

    private int evalConcatenation(PatternAutomaton automaton, Concatenation element, int laststate) {
        int state = laststate;
        int i = element.getPatternCount() - 1;
        while (i >= 0) {
            state = this.traverse(automaton, element.getPattern(i), state);
            --i;
        }
        return state;
    }

    private int evalEndOfLine(PatternAutomaton automaton, EndOfLine element, int laststate) {
        automaton.setType(this.stateindex, 5);
        automaton.setTransitions(this.stateindex, new int[]{laststate});
        return this.stateindex--;
    }

    private int evalPattern(PatternAutomaton automaton, Pattern element, int laststate) {
        if (element instanceof Alternation) {
            return this.evalAlternation(automaton, (Alternation)element, laststate);
        }
        if (element instanceof BeginOfLine) {
            return this.evalBeginOfLine(automaton, (BeginOfLine)element, laststate);
        }
        if (element instanceof CharacterClass) {
            return this.evalCharacterClass(automaton, (CharacterClass)element, laststate);
        }
        if (element instanceof CharacterString) {
            return this.evalCharacterString(automaton, (CharacterString)element, laststate);
        }
        if (element instanceof Concatenation) {
            return this.evalConcatenation(automaton, (Concatenation)element, laststate);
        }
        if (element instanceof EndOfLine) {
            return this.evalEndOfLine(automaton, (EndOfLine)element, laststate);
        }
        if (element instanceof PatternGroup) {
            return this.evalPatternGroup(automaton, (PatternGroup)element, laststate);
        }
        if (element instanceof UniversalCharacter) {
            return this.evalUniversalCharacter(automaton, (UniversalCharacter)element, laststate);
        }
        throw new IllegalArgumentException("Pattern element not recognized");
    }

    private int evalPatternGroup(PatternAutomaton automaton, PatternGroup element, int laststate) {
        int endstate = this.stateindex--;
        automaton.setType(endstate, 7);
        automaton.setGroupIndex(endstate, this.groupindex);
        automaton.setTransitions(endstate, new int[]{laststate});
        int nextstate = endstate;
        int i = element.getPatternCount() - 1;
        while (i >= 0) {
            nextstate = this.traverse(automaton, element.getPattern(i), nextstate);
            --i;
        }
        automaton.setGroupIndex(endstate, this.groupindex);
        automaton.setType(this.stateindex, 6);
        automaton.setGroupIndex(this.stateindex, this.groupindex);
        automaton.setTransitions(this.stateindex, new int[]{nextstate});
        return this.stateindex--;
    }

    private int evalUniversalCharacter(PatternAutomaton automaton, UniversalCharacter element, int laststate) {
        automaton.setType(this.stateindex, 3);
        automaton.setTransitions(this.stateindex, new int[]{laststate});
        return this.stateindex--;
    }

    private int getGroupCount(Pattern element) {
        int groupcount;
        block4: {
            block5: {
                block3: {
                    groupcount = 0;
                    if (!(element instanceof Alternation)) break block3;
                    Alternation alternation = (Alternation)element;
                    int i = 0;
                    while (i < alternation.getPatternCount()) {
                        groupcount += this.getGroupCount(alternation.getPattern(i));
                        ++i;
                    }
                    break block4;
                }
                if (!(element instanceof Concatenation)) break block5;
                Concatenation concatenation = (Concatenation)element;
                int i = 0;
                while (i < concatenation.getPatternCount()) {
                    groupcount += this.getGroupCount(concatenation.getPattern(i));
                    ++i;
                }
                break block4;
            }
            if (!(element instanceof PatternGroup)) break block4;
            ++groupcount;
            PatternGroup group = (PatternGroup)element;
            int i = 0;
            while (i < group.getPatternCount()) {
                groupcount += this.getGroupCount(group.getPattern(i));
                ++i;
            }
        }
        return groupcount;
    }

    public PatternAutomaton getPatternAutomaton() {
        return this.automaton;
    }

    private int getStateCount(Pattern element) {
        int factor = 1;
        int offset = 0;
        int statecount = 0;
        if (element.getMinOccurs() != 1 || element.getMaxOccurs() != 1) {
            if (element.getMinOccurs() == 0 && element.getMaxOccurs() == 1) {
                offset = 1;
            } else if (element.getMinOccurs() == 1 && element.getMaxOccurs() == Integer.MAX_VALUE) {
                offset = 1;
            } else if (element.getMinOccurs() == 0 && element.getMaxOccurs() == Integer.MAX_VALUE) {
                offset = 2;
            } else {
                factor = element.getMaxOccurs();
                offset = 1;
            }
        }
        if (element instanceof Alternation) {
            Alternation alternation = (Alternation)element;
            int i = 0;
            while (i < alternation.getPatternCount()) {
                statecount += this.getStateCount(alternation.getPattern(i));
                ++i;
            }
            if (alternation.getPatternCount() > 1) {
                ++statecount;
            }
        } else if (element instanceof BeginOfLine) {
            statecount = 1;
        } else if (element instanceof CharacterClass) {
            CharacterClass characterclass = (CharacterClass)element;
            int i = 0;
            while (i < characterclass.getCharacterClassElementCount()) {
                if (characterclass.getCharacterClassElement(i) instanceof CharacterInterval) {
                    ++statecount;
                } else if (characterclass.getCharacterClassElement(i) instanceof CharacterSet) {
                    CharacterSet set = (CharacterSet)characterclass.getCharacterClassElement(i);
                    statecount += set.getCharacters().length();
                }
                ++i;
            }
            ++statecount;
        } else if (element instanceof CharacterString) {
            CharacterString string = (CharacterString)element;
            statecount += string.getString().length();
        } else if (element instanceof Concatenation) {
            Concatenation concatenation = (Concatenation)element;
            int i = 0;
            while (i < concatenation.getPatternCount()) {
                statecount += this.getStateCount(concatenation.getPattern(i));
                ++i;
            }
        } else if (element instanceof EndOfLine) {
            statecount = 1;
        } else if (element instanceof PatternGroup) {
            statecount = 2;
            PatternGroup group = (PatternGroup)element;
            int i = 0;
            while (i < group.getPatternCount()) {
                statecount += this.getStateCount(group.getPattern(i));
                ++i;
            }
        } else if (element instanceof UniversalCharacter) {
            statecount = 1;
        } else {
            throw new IllegalArgumentException("Pattern element not recognized");
        }
        return factor * statecount + offset;
    }

    private int traverse(PatternAutomaton automaton, Pattern element, int laststate) {
        int firststate;
        if (element.getMinOccurs() == 1 && element.getMaxOccurs() == 1) {
            firststate = this.evalPattern(automaton, element, laststate);
        } else if (element.getMinOccurs() == 0 && element.getMaxOccurs() == 1) {
            int s1 = this.evalPattern(automaton, element, laststate);
            automaton.setTransitions(this.stateindex, new int[]{s1, laststate});
            firststate = this.stateindex--;
        } else if (element.getMinOccurs() == 1 && element.getMaxOccurs() == Integer.MAX_VALUE) {
            int s1 = this.stateindex--;
            firststate = this.evalPattern(automaton, element, s1);
            automaton.setTransitions(s1, new int[]{firststate, laststate});
        } else if (element.getMinOccurs() == 0 && element.getMaxOccurs() == Integer.MAX_VALUE) {
            int s2 = this.stateindex--;
            int s1 = this.evalPattern(automaton, element, s2);
            automaton.setTransitions(s2, new int[]{s1, laststate});
            firststate = this.stateindex--;
            automaton.setTransitions(firststate, new int[]{s1, laststate});
        } else {
            int s2 = laststate;
            int i = 0;
            while (i < element.getMinOccurs()) {
                s2 = this.evalPattern(automaton, element, s2);
                ++i;
            }
            int s1 = s2;
            int i2 = element.getMinOccurs();
            while (i2 < element.getMaxOccurs()) {
                s1 = this.evalPattern(automaton, element, s1);
                if (i2 > element.getMinOccurs()) {
                    automaton.addTransition(s1, s2);
                }
                ++i2;
            }
            firststate = this.stateindex--;
            automaton.setTransitions(firststate, new int[]{s1, s2});
        }
        if (element instanceof PatternGroup) {
            --this.groupindex;
        }
        return firststate;
    }
}

