/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.model.grammar;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.sourceforge.chaperon.common.IntegerList;
import net.sourceforge.chaperon.model.Violations;
import net.sourceforge.chaperon.model.grammar.Associativity;
import net.sourceforge.chaperon.model.grammar.Production;
import net.sourceforge.chaperon.model.symbol.Nonterminal;
import net.sourceforge.chaperon.model.symbol.Symbol;
import net.sourceforge.chaperon.model.symbol.SymbolList;
import net.sourceforge.chaperon.model.symbol.SymbolSet;
import net.sourceforge.chaperon.model.symbol.Terminal;

public class Grammar
implements Serializable,
Cloneable {
    private Nonterminal startsymbol = null;
    private Vector productions = new Vector();
    private Hashtable priorities = new Hashtable();
    private Hashtable associativities = new Hashtable();
    private String location = null;

    public int addProduction(Production production) {
        if (production == null) {
            throw new NullPointerException();
        }
        this.productions.addElement(production);
        return this.productions.size() - 1;
    }

    public void addProduction(Production[] list) {
        int i = 0;
        while (i < list.length) {
            try {
                this.addProduction((Production)list[i].clone());
            }
            catch (CloneNotSupportedException cnse) {
                throw new IllegalArgumentException("Could not clone token:" + cnse.getMessage());
            }
            ++i;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        Grammar clone = new Grammar();
        clone.startsymbol = this.startsymbol;
        int i = 0;
        while (i < this.productions.size()) {
            clone.addProduction((Production)((Production)this.productions.elementAt(i)).clone());
            ++i;
        }
        clone.location = this.location;
        return clone;
    }

    public boolean contains(Production production) {
        return this.indexOf(production) != -1;
    }

    public boolean contains(Symbol ntsymbol) {
        return this.indexOf(ntsymbol) != -1;
    }

    public Associativity getAssociativity(Production production) {
        if (!this.contains(production)) {
            return Associativity.NONASSOC;
        }
        if (production.getPrecedence() != null) {
            return this.getAssociativity(production.getPrecedence());
        }
        SymbolList definition = production.getDefinition();
        int i = definition.getSymbolCount() - 1;
        while (i >= 0) {
            if (definition.getSymbol(i) instanceof Terminal) {
                return this.getAssociativity((Terminal)definition.getSymbol(i));
            }
            --i;
        }
        return Associativity.NONASSOC;
    }

    public Associativity getAssociativity(Terminal terminal) {
        Associativity assoc = (Associativity)this.associativities.get(terminal);
        if (assoc == null) {
            return Associativity.NONASSOC;
        }
        return assoc;
    }

    public String getLocation() {
        return this.location;
    }

    public int getPriority(Production production) {
        if (!this.contains(production)) {
            return 0;
        }
        if (production.getPrecedence() != null) {
            return this.getPriority(production.getPrecedence());
        }
        SymbolList definition = production.getDefinition();
        int i = definition.getSymbolCount() - 1;
        while (i >= 0) {
            if (definition.getSymbol(i) instanceof Terminal) {
                int priority = this.getPriority((Terminal)definition.getSymbol(i));
                return priority;
            }
            --i;
        }
        return 0;
    }

    public int getPriority(Terminal terminal) {
        Integer priority = (Integer)this.priorities.get(terminal);
        if (priority == null) {
            return 0;
        }
        return priority;
    }

    public Production[] getProduction() {
        int size = this.productions.size();
        Production[] mArray = new Production[size];
        int index = 0;
        while (index < size) {
            mArray[index] = (Production)this.productions.elementAt(index);
            ++index;
        }
        return mArray;
    }

    public Production getProduction(int index) {
        return (Production)this.productions.elementAt(index);
    }

    public int getProductionCount() {
        return this.productions.size();
    }

    public IntegerList getProductionList(Symbol ntsymbol) {
        IntegerList list = new IntegerList();
        int i = 0;
        while (i < this.getProductionCount()) {
            if (this.getProduction(i).getSymbol().equals(ntsymbol)) {
                list.add(i);
            }
            ++i;
        }
        return list;
    }

    public Nonterminal getStartSymbol() {
        return this.startsymbol;
    }

    public SymbolSet getSymbols() {
        SymbolSet set = new SymbolSet();
        int i = 0;
        while (i < this.getProductionCount()) {
            set.addSymbol(this.getProduction(i).getSymbols());
            ++i;
        }
        return set;
    }

    public int indexOf(Production production) {
        int i = 0;
        while (i < this.productions.size()) {
            if (((Production)this.productions.elementAt(i)).equals(production)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOf(Symbol ntsymbol) {
        int i = 0;
        while (i < this.productions.size()) {
            if (((Production)this.productions.elementAt(i)).getSymbol().equals(ntsymbol)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void removeAllProduction() {
        this.productions.removeAllElements();
    }

    public void removeProduction(int index) {
        this.productions.removeElementAt(index);
    }

    public void setAssociativity(Terminal terminal, Associativity assoc) {
        if (terminal == null) {
            throw new NullPointerException();
        }
        this.associativities.put(terminal, assoc);
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setPriority(Terminal terminal, int priority) {
        if (terminal == null) {
            throw new NullPointerException();
        }
        this.priorities.put(terminal, new Integer(priority));
    }

    public void setProduction(int index, Production production) {
        if (index < 0 || index > this.productions.size()) {
            throw new IndexOutOfBoundsException();
        }
        this.productions.setElementAt(production, index);
    }

    public void setProduction(Production[] productionArray) {
        this.productions.removeAllElements();
        int i = 0;
        while (i < productionArray.length) {
            this.productions.addElement(productionArray[i]);
            ++i;
        }
    }

    public void setStartSymbol(Nonterminal startsymbol) {
        this.startsymbol = startsymbol;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Terminal symbols:\n");
        SymbolSet tsymbols = this.getSymbols().getTerminals();
        int i = 0;
        while (i < tsymbols.getSymbolCount()) {
            buffer.append(String.valueOf(i));
            buffer.append(".Terminal: ");
            buffer.append(tsymbols.getSymbol(i));
            buffer.append(" Priority=");
            buffer.append(String.valueOf(this.getPriority((Terminal)tsymbols.getSymbol(i))));
            buffer.append(" Associativity=");
            buffer.append(String.valueOf(this.getAssociativity((Terminal)tsymbols.getSymbol(i))));
            buffer.append("\n");
            ++i;
        }
        buffer.append("Produktions:\n");
        int i2 = 0;
        while (i2 < this.getProductionCount()) {
            buffer.append(String.valueOf(i2));
            buffer.append(".Production: ");
            buffer.append(this.getProduction(i2).toString());
            buffer.append("\n");
            ++i2;
        }
        buffer.append("\n");
        return buffer.toString();
    }

    public Violations validate() {
        Violations violations = new Violations();
        if (this.startsymbol == null) {
            violations.addViolation("Start symbol is not defined", this.location);
        } else if (!this.contains(this.startsymbol)) {
            violations.addViolation("Start symbol \"" + this.startsymbol + "\"" + "is not defined through a production", this.location);
        }
        if (this.getProductionCount() <= 0) {
            violations.addViolation("No productions are defined", this.location);
        }
        Enumeration e = this.productions.elements();
        while (e.hasMoreElements()) {
            violations.addViolations(((Production)e.nextElement()).validate());
        }
        SymbolSet ntsymbols = this.getSymbols().getNonterminals();
        int i = 0;
        while (i < ntsymbols.getSymbolCount()) {
            if (!this.contains(ntsymbols.getSymbol(i))) {
                violations.addViolation("Nonterminal symbol \"" + ntsymbols.getSymbol(i) + "\"" + "is not defined through a production", this.location);
            }
            ++i;
        }
        return violations;
    }
}

