/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.process;

import net.sourceforge.chaperon.common.Decoder;
import net.sourceforge.chaperon.process.LexicalAutomaton;
import net.sourceforge.chaperon.process.LexicalHandler;
import net.sourceforge.chaperon.process.Locator;
import net.sourceforge.chaperon.process.PatternProcessor;
import net.sourceforge.chaperon.process.ProcessingException;
import net.sourceforge.chaperon.process.TextHandler;
import net.sourceforge.chaperon.process.TextLocator;
import org.apache.avalon.framework.logger.Logger;

public class LexicalProcessor
implements TextHandler {
    private LexicalAutomaton automaton = null;
    private LexicalHandler handler = null;
    private Logger logger = null;
    private TextLocator locator = null;
    private StringBuffer buffer = null;
    private boolean recovery = false;

    public LexicalProcessor() {
    }

    public LexicalProcessor(LexicalAutomaton automaton, LexicalHandler handler) {
        this.automaton = automaton;
        this.handler = handler;
    }

    public void handleEndDocument() throws Exception {
        this.handler.handleStartDocument();
        PatternProcessor processor = new PatternProcessor();
        char[] text = this.buffer.toString().toCharArray();
        int lexemeindex = 0;
        int position = 0;
        do {
            int line;
            int column;
            String tokensymbol = null;
            String tokentext = null;
            lexemeindex = this.automaton.getLexemeCount() - 1;
            while (lexemeindex >= 0) {
                processor.setPatternAutomaton(this.automaton.getLexemeDefinition(lexemeindex));
                if (processor.match(text, position) && (tokentext == null || processor.getGroup().length() >= tokentext.length())) {
                    tokensymbol = this.automaton.getLexemeSymbol(lexemeindex);
                    tokentext = processor.getGroup();
                }
                --lexemeindex;
            }
            if (tokentext != null) {
                if (tokentext.length() == 0) {
                    throw new ProcessingException("Lexical processor recognized empty lexeme '" + tokensymbol + "'", this.locator);
                }
                if (tokensymbol != null) {
                    if (this.logger != null) {
                        this.logger.debug("Recognize token " + tokensymbol + " with '" + Decoder.decode(tokentext) + "'");
                    }
                    this.handler.handleLexeme(tokensymbol, tokentext);
                } else if (this.logger != null) {
                    this.logger.debug("Ignore lexeme with '" + Decoder.decode(tokentext) + "'");
                }
                if (this.locator != null) {
                    column = this.locator.getColumnNumber();
                    line = this.locator.getLineNumber();
                    int i = position;
                    while (i < position + tokentext.length()) {
                        if (text[i] == '\n' && (i == 0 || text[i - 1] != '\r')) {
                            column = 1;
                            ++line;
                        } else if (text[i] == '\r' && (i == text.length - 1 || text[i + 1] != '\n')) {
                            column = 1;
                            ++line;
                        } else {
                            ++column;
                        }
                        ++i;
                    }
                    this.locator.setColumnNumber(column);
                    this.locator.setLineNumber(line);
                }
                position += tokentext.length();
                continue;
            }
            if (!this.recovery) {
                StringBuffer rest = new StringBuffer();
                while (position < text.length && text[position] != '\n' && text[position] != '\r') {
                    rest.append(text[position]);
                    ++position;
                }
                throw new ProcessingException("Lexeme was not recognized '" + rest.toString() + "'", this.locator);
            }
            if (this.locator != null) {
                column = this.locator.getColumnNumber();
                line = this.locator.getLineNumber();
                if (text[position] == '\n' && (position == 0 || text[position - 1] != '\r')) {
                    column = 1;
                    ++line;
                } else if (text[position] == '\r' && (position == text.length - 1 || text[position + 1] != '\n')) {
                    column = 1;
                    ++line;
                } else {
                    ++column;
                }
                this.locator.setColumnNumber(column);
                this.locator.setLineNumber(line);
            }
            ++position;
        } while (position < text.length);
        this.handler.handleEndDocument();
        this.locator = null;
    }

    public void handleLocator(Locator locator) {
        this.locator = locator != null ? new TextLocator(locator) : null;
        this.handler.handleLocator(this.locator);
    }

    public void handleStartDocument() throws Exception {
        this.buffer = new StringBuffer();
    }

    public void handleText(String text) throws Exception {
        this.buffer.append(text);
    }

    public void setLexicalAutomaton(LexicalAutomaton automaton) {
        this.automaton = automaton;
    }

    public void setLexicalHandler(LexicalHandler handler) {
        this.handler = handler;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setRecovery(boolean recovery) {
        this.recovery = recovery;
    }
}

